/*     */ package org.jboss.ejb3.protocol.jarjar;
/*     */ 
/*     */ import java.io.EOFException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PipedInputStream;
/*     */ import java.io.PipedOutputStream;
/*     */ import java.util.Enumeration;
/*     */ import java.util.jar.JarEntry;
/*     */ import java.util.jar.JarFile;
/*     */ import java.util.jar.JarOutputStream;
/*     */ import java.util.jar.Manifest;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JarJarInputStream extends InputStream
/*     */ {
/*  47 */   private static final Logger log = Logger.getLogger(JarJarInputStream.class);
/*     */   private PipedInputStream pipedInputStream;
/*     */   private PipedOutputStream pipedOutputStream;
/*     */   private Thread writingThread;
/*     */ 
/*     */   protected JarJarInputStream(JarFile jarFile, JarEntry rootEntry)
/*     */     throws IOException
/*     */   {
/*  61 */     this.pipedInputStream = new PipedInputStream();
/*  62 */     this.pipedOutputStream = new PipedOutputStream(this.pipedInputStream);
/*     */ 
/*  64 */     Manifest mf = jarFile.getManifest();
/*     */     JarOutputStream jos;
/*     */     JarOutputStream jos;
/*  66 */     if (mf != null)
/*  67 */       jos = new JarOutputStream(this.pipedOutputStream, mf);
/*     */     else {
/*  69 */       jos = new JarOutputStream(this.pipedOutputStream);
/*     */     }
/*  71 */     this.writingThread = new Thread(jarFile, rootEntry, jos)
/*     */     {
/*     */       public void run()
/*     */       {
/*     */         try
/*     */         {
/*  78 */           Enumeration entries = this.val$jarFile.entries();
/*  79 */           while (entries.hasMoreElements())
/*     */           {
/*  81 */             JarEntry entry = (JarEntry)entries.nextElement();
/*  82 */             if (JarJarInputStream.this.isRelativeTo(this.val$rootEntry, entry))
/*     */             {
/*  84 */               InputStream in = this.val$jarFile.getInputStream(entry);
/*     */               try
/*     */               {
/*  87 */                 JarEntry newEntry = JarJarInputStream.this.createEntry(this.val$rootEntry, entry);
/*  88 */                 this.val$jos.putNextEntry(newEntry);
/*     */ 
/*  90 */                 JarJarInputStream.this.copy(in, this.val$jos, entry.getSize());
/*  91 */                 JarJarInputStream.log.trace("emitted " + newEntry);
/*     */ 
/*  93 */                 this.val$jos.closeEntry();
/*     */               }
/*     */               finally
/*     */               {
/*  97 */                 in.close();
/*     */               }
/*     */             }
/*     */           }
/* 101 */           this.val$jos.flush();
/* 102 */           this.val$jos.finish();
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 107 */           JarJarInputStream.log.warn(e.getMessage(), e);
/*     */         }
/*     */       }
/*     */     };
/* 111 */     this.writingThread.start();
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 117 */     this.pipedOutputStream.close();
/* 118 */     this.pipedInputStream.close();
/*     */ 
/* 122 */     super.close();
/*     */   }
/*     */ 
/*     */   protected void copy(InputStream in, OutputStream out, long size) throws IOException
/*     */   {
/* 127 */     byte[] buf = new byte[65536];
/*     */ 
/* 129 */     while (size > 0L)
/*     */     {
/* 131 */       int len = in.read(buf);
/* 132 */       if (len < 0)
/* 133 */         throw new EOFException("Unexpected EOF");
/* 134 */       out.write(buf, 0, len);
/* 135 */       size -= len;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected JarEntry createEntry(JarEntry rootEntry, JarEntry template)
/*     */   {
/* 141 */     if (rootEntry == null) {
/* 142 */       return new JarEntry(template);
/*     */     }
/* 144 */     String name = template.getName().substring(rootEntry.getName().length());
/* 145 */     JarEntry entry = new JarEntry(name);
/* 146 */     entry.setComment(template.getComment());
/* 147 */     entry.setSize(template.getSize());
/* 148 */     entry.setTime(template.getTime());
/* 149 */     return entry;
/*     */   }
/*     */ 
/*     */   protected boolean isRelativeTo(JarEntry rootEntry, JarEntry current)
/*     */   {
/* 154 */     if (rootEntry == null) {
/* 155 */       return true;
/*     */     }
/*     */ 
/* 158 */     return (current.getName().startsWith(rootEntry.getName())) && (!current.getName().equals(rootEntry.getName()));
/*     */   }
/*     */ 
/*     */   public int read()
/*     */     throws IOException
/*     */   {
/* 169 */     return this.pipedInputStream.read();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.protocol.jarjar.JarJarInputStream
 * JD-Core Version:    0.6.0
 */