/*     */ package org.jboss.ejb3.proxy;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.rmi.RemoteException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBMetaData;
/*     */ import javax.ejb.HomeHandle;
/*     */ 
/*     */ public class EJBMetaDataImpl
/*     */   implements EJBMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -3698855455664391097L;
/*     */   private final Class remote;
/*     */   private final Class home;
/*     */   private final Class pkClass;
/*     */   private final boolean session;
/*     */   private final boolean statelessSession;
/*     */   private final HomeHandle homeHandle;
/*     */ 
/*     */   public EJBMetaDataImpl(Class remote, Class home, Class pkClass, boolean session, boolean statelessSession, HomeHandle homeHandle)
/*     */   {
/*  69 */     this.remote = remote;
/*  70 */     this.home = home;
/*  71 */     this.pkClass = pkClass;
/*  72 */     this.session = session;
/*  73 */     this.statelessSession = statelessSession;
/*  74 */     this.homeHandle = homeHandle;
/*     */   }
/*     */ 
/*     */   public EJBHome getEJBHome()
/*     */   {
/*     */     try
/*     */     {
/*  94 */       return this.homeHandle.getEJBHome();
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/*  98 */       throw e;
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 102 */       e.printStackTrace();
/* 103 */     }throw new EJBException(e);
/*     */   }
/*     */ 
/*     */   public Class getHomeInterfaceClass()
/*     */   {
/* 112 */     return this.home;
/*     */   }
/*     */ 
/*     */   public Class getRemoteInterfaceClass()
/*     */   {
/* 120 */     return this.remote;
/*     */   }
/*     */ 
/*     */   public Class getPrimaryKeyClass()
/*     */   {
/* 128 */     if (this.session == true) {
/* 129 */       throw new RuntimeException("A session bean does not have a primary key class");
/*     */     }
/* 131 */     return this.pkClass;
/*     */   }
/*     */ 
/*     */   public boolean isSession()
/*     */   {
/* 141 */     return this.session;
/*     */   }
/*     */ 
/*     */   public boolean isStatelessSession()
/*     */   {
/* 151 */     return this.statelessSession;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.proxy.EJBMetaDataImpl
 * JD-Core Version:    0.6.0
 */