/*    */ package org.jboss.ejb3.security;
/*    */ 
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.advice.AspectFactory;
/*    */ import org.jboss.ejb3.Container;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.security.AuthenticationManager;
/*    */ 
/*    */ public class AuthenticationInterceptorFactory extends PerClassAspectFactoryAdaptor
/*    */   implements AspectFactory
/*    */ {
/* 38 */   private static final Logger log = Logger.getLogger(AuthenticationInterceptorFactory.class);
/*    */ 
/*    */   public Object createPerClass(Advisor advisor)
/*    */   {
/* 42 */     Container container = (Container)advisor;
/* 43 */     AuthenticationManager manager = (AuthenticationManager)container.getSecurityManager(AuthenticationManager.class);
/* 44 */     log.debug("Creating interceptor with authentication manager '" + manager + "'" + (manager != null ? " (security domain '" + manager.getSecurityDomain() + "')" : ""));
/*    */ 
/* 47 */     return new Ejb3AuthenticationInterceptorv2(container);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.security.AuthenticationInterceptorFactory
 * JD-Core Version:    0.6.0
 */