/*     */ package org.jboss.ejb3.security;
/*     */ 
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.jacc.PolicyContext;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.security.RunAs;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextFactory;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ import org.jboss.security.plugins.SecurityContextAssociation;
/*     */ 
/*     */ class SecurityActions
/*     */ {
/*     */   static Subject getContextSubject()
/*     */     throws PolicyContextException
/*     */   {
/* 194 */     if (System.getSecurityManager() == null)
/*     */     {
/* 196 */       return PolicyContextActions.NON_PRIVILEGED.getContextSubject();
/*     */     }
/*     */ 
/* 200 */     return PolicyContextActions.PRIVILEGED.getContextSubject();
/*     */   }
/*     */ 
/*     */   static String setContextID(String contextID)
/*     */   {
/* 206 */     PrivilegedAction action = new SetContextID(contextID);
/* 207 */     String previousID = (String)AccessController.doPrivileged(action);
/* 208 */     return previousID;
/*     */   }
/*     */ 
/*     */   static RunAsIdentity peekRunAsIdentity()
/*     */   {
/* 213 */     if (System.getSecurityManager() == null)
/*     */     {
/* 215 */       return RunAsIdentityActions.NON_PRIVILEGED.peek();
/*     */     }
/*     */ 
/* 219 */     return RunAsIdentityActions.PRIVILEGED.peek();
/*     */   }
/*     */ 
/*     */   static void pushRunAsIdentity(RunAsIdentity principal)
/*     */   {
/* 225 */     if (System.getSecurityManager() == null)
/*     */     {
/* 227 */       RunAsIdentityActions.NON_PRIVILEGED.push(principal);
/*     */     }
/*     */     else
/*     */     {
/* 231 */       RunAsIdentityActions.PRIVILEGED.push(principal);
/*     */     }
/*     */   }
/*     */ 
/*     */   static RunAsIdentity popRunAsIdentity()
/*     */   {
/* 237 */     if (System.getSecurityManager() == null)
/*     */     {
/* 239 */       return RunAsIdentityActions.NON_PRIVILEGED.pop();
/*     */     }
/*     */ 
/* 243 */     return RunAsIdentityActions.PRIVILEGED.pop();
/*     */   }
/*     */ 
/*     */   static Principal getCallerPrincipal()
/*     */   {
/* 249 */     return (Principal)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 253 */         return SecurityAssociation.getCallerPrincipal();
/*     */       } } );
/*     */   }
/*     */ 
/*     */   static SecurityContext createSecurityContext(String domainName) throws PrivilegedActionException {
/* 259 */     return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(domainName)
/*     */     {
/*     */       public Object run() throws Exception
/*     */       {
/* 263 */         return SecurityContextFactory.createSecurityContext(this.val$domainName);
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static SecurityContext createSecurityContext(Principal p, Object cred, Subject s, String domainName) throws PrivilegedActionException
/*     */   {
/* 271 */     return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(p, cred, s, domainName)
/*     */     {
/*     */       public Object run() throws Exception
/*     */       {
/* 275 */         return SecurityContextFactory.createSecurityContext(this.val$p, this.val$cred, this.val$s, this.val$domainName);
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static SecurityContext getSecurityContext() {
/* 282 */     return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 286 */         return SecurityContextAssociation.getSecurityContext();
/*     */       } } );
/*     */   }
/*     */ 
/*     */   static void setSecurityContext(SecurityContext sc) {
/* 292 */     AccessController.doPrivileged(new PrivilegedAction(sc)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 296 */         SecurityContextAssociation.setSecurityContext(this.val$sc);
/* 297 */         return null;
/*     */       } } );
/*     */   }
/*     */ 
/*     */   static void pushSubjectContext(Principal p, Object cred, Subject s) {
/* 303 */     AccessController.doPrivileged(new PrivilegedAction(p, cred, s)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 307 */         SecurityContext sc = SecurityActions.getSecurityContext();
/* 308 */         if (sc == null)
/* 309 */           throw new IllegalStateException("Security Context is null");
/* 310 */         sc.getUtil().createSubjectInfo(this.val$p, this.val$cred, this.val$s);
/* 311 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static void pushCallerRunAsIdentity(RunAs ra) {
/* 318 */     AccessController.doPrivileged(new PrivilegedAction(ra)
/*     */     {
/*     */       public Object run() {
/* 321 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 322 */         if (sc == null)
/* 323 */           throw new IllegalStateException("Security Context is null");
/* 324 */         sc.setIncomingRunAs(this.val$ra);
/* 325 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public static void popCallerRunAsIdentity()
/*     */   {
/* 333 */     AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run() {
/* 336 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 337 */         if (sc == null)
/* 338 */           throw new IllegalStateException("Security Context is null");
/* 339 */         sc.setIncomingRunAs(null);
/* 340 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static abstract interface RunAsIdentityActions
/*     */   {
/* 123 */     public static final RunAsIdentityActions PRIVILEGED = new RunAsIdentityActions()
/*     */     {
/* 125 */       private final PrivilegedAction peekAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 129 */           return SecurityAssociation.peekRunAsIdentity();
/*     */         }
/* 125 */       };
/*     */ 
/* 133 */       private final PrivilegedAction popAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 137 */           return SecurityAssociation.popRunAsIdentity();
/*     */         }
/* 133 */       };
/*     */ 
/*     */       public RunAsIdentity peek()
/*     */       {
/* 143 */         return (RunAsIdentity)AccessController.doPrivileged(this.peekAction);
/*     */       }
/*     */ 
/*     */       public void push(RunAsIdentity id)
/*     */       {
/* 148 */         AccessController.doPrivileged(new PrivilegedAction(id)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 153 */             SecurityAssociation.pushRunAsIdentity(this.val$id);
/* 154 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public RunAsIdentity pop()
/*     */       {
/* 162 */         return (RunAsIdentity)AccessController.doPrivileged(this.popAction);
/*     */       }
/* 123 */     };
/*     */ 
/* 166 */     public static final RunAsIdentityActions NON_PRIVILEGED = new RunAsIdentityActions()
/*     */     {
/*     */       public RunAsIdentity peek()
/*     */       {
/* 170 */         return SecurityAssociation.peekRunAsIdentity();
/*     */       }
/*     */ 
/*     */       public void push(RunAsIdentity id)
/*     */       {
/* 175 */         SecurityAssociation.pushRunAsIdentity(id);
/*     */       }
/*     */ 
/*     */       public RunAsIdentity pop()
/*     */       {
/* 180 */         return SecurityAssociation.popRunAsIdentity();
/*     */       }
/* 166 */     };
/*     */ 
/*     */     public abstract RunAsIdentity peek();
/*     */ 
/*     */     public abstract void push(RunAsIdentity paramRunAsIdentity);
/*     */ 
/*     */     public abstract RunAsIdentity pop();
/*     */   }
/*     */ 
/*     */   static abstract interface PolicyContextActions
/*     */   {
/*     */     public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
/*  80 */     public static final PolicyContextActions PRIVILEGED = new PolicyContextActions()
/*     */     {
/*  82 */       private final PrivilegedExceptionAction exAction = new PrivilegedExceptionAction()
/*     */       {
/*     */         public Object run() throws Exception
/*     */         {
/*  86 */           return (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
/*     */         }
/*  82 */       };
/*     */ 
/*     */       public Subject getContextSubject()
/*     */         throws PolicyContextException
/*     */       {
/*     */         Exception ex;
/*     */         try
/*     */         {
/*  95 */           return (Subject)AccessController.doPrivileged(this.exAction);
/*     */         }
/*     */         catch (PrivilegedActionException e)
/*     */         {
/*  99 */           ex = e.getException();
/* 100 */           if ((ex instanceof PolicyContextException))
/* 101 */             throw ((PolicyContextException)ex);
/*     */         }
/* 103 */         throw new UndeclaredThrowableException(ex);
/*     */       }
/*  80 */     };
/*     */ 
/* 108 */     public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions()
/*     */     {
/*     */       public Subject getContextSubject()
/*     */         throws PolicyContextException
/*     */       {
/* 113 */         return (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
/*     */       }
/* 108 */     };
/*     */ 
/*     */     public abstract Subject getContextSubject()
/*     */       throws PolicyContextException;
/*     */   }
/*     */ 
/*     */   private static class SetContextID
/*     */     implements PrivilegedAction
/*     */   {
/*     */     String contextID;
/*     */ 
/*     */     SetContextID(String contextID)
/*     */     {
/*  63 */       this.contextID = contextID;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/*  68 */       String previousID = PolicyContext.getContextID();
/*  69 */       PolicyContext.setContextID(this.contextID);
/*  70 */       return previousID;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.security.SecurityActions
 * JD-Core Version:    0.6.0
 */