/*     */ package org.jboss.ejb3.service;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.util.Arrays;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.advice.AdviceStack;
/*     */ import org.jboss.ejb3.JBossProxy;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.ejb3.annotation.RemoteBinding;
/*     */ import org.jboss.ejb3.remoting.RemoteProxyFactory;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class ServiceRemoteProxyFactory extends BaseServiceProxyFactory
/*     */   implements RemoteProxyFactory
/*     */ {
/*     */   private RemoteBinding binding;
/*     */   private InvokerLocator locator;
/*     */ 
/*     */   protected ServiceRemoteProxyFactory(ServiceContainer container, RemoteBinding binding)
/*     */   {
/*  50 */     super(container, binding.jndiBinding());
/*     */ 
/*  52 */     this.binding = binding;
/*     */   }
/*     */ 
/*     */   protected Class<?>[] getInterfaces()
/*     */   {
/*  63 */     Set uniqueInterfaces = new HashSet();
/*     */ 
/*  66 */     uniqueInterfaces.addAll(Arrays.asList(ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(this.container)));
/*     */ 
/*  69 */     uniqueInterfaces.add(JBossProxy.class);
/*     */ 
/*  72 */     return (Class[])uniqueInterfaces.toArray(new Class[0]);
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*  77 */     String clientBindUrl = ProxyFactoryHelper.getClientBindUrl(this.binding);
/*  78 */     this.locator = new InvokerLocator(clientBindUrl);
/*  79 */     super.start();
/*     */   }
/*     */ 
/*     */   public Object createProxy()
/*     */   {
/*     */     try
/*     */     {
/*  86 */       String stackName = "ServiceClientInterceptors";
/*  87 */       if ((this.binding.interceptorStack() != null) && (!this.binding.interceptorStack().equals("")))
/*     */       {
/*  89 */         stackName = this.binding.interceptorStack();
/*     */       }
/*  91 */       AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
/*  92 */       Object[] args = { new ServiceRemoteProxy(this.container, stack.createInterceptors(this.container, null), this.locator) };
/*  93 */       return this.proxyConstructor.newInstance(args);
/*     */     }
/*     */     catch (InstantiationException e)
/*     */     {
/*  97 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 101 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (IllegalArgumentException e)
/*     */     {
/* 105 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (InvocationTargetException e) {
/*     */     }
/* 109 */     throw new RuntimeException(e.getTargetException());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.service.ServiceRemoteProxyFactory
 * JD-Core Version:    0.6.0
 */