/*     */ package org.jboss.ejb3.session;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBLocalHome;
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.ejb.EJBMetaData;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.HomeHandle;
/*     */ import javax.ejb.Remote;
/*     */ import javax.ejb.RemoteHome;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.Ejb3Registry;
/*     */ import org.jboss.ejb3.ProxyFactory;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.ejb3.annotation.RemoteBinding;
/*     */ import org.jboss.ejb3.proxy.EJBMetaDataImpl;
/*     */ import org.jboss.ejb3.proxy.handle.HomeHandleImpl;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class BaseSessionProxyFactory
/*     */   implements ProxyFactory, Externalizable
/*     */ {
/*     */   private static final Logger log;
/*     */   private EJBContainer container;
/*     */   protected String containerGuid;
/*     */   protected String containerClusterUid;
/*  64 */   protected boolean isClustered = false;
/*     */ 
/*     */   public BaseSessionProxyFactory()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected BaseSessionProxyFactory(SessionContainer container)
/*     */   {
/*  72 */     assert (container != null) : "container is null";
/*     */ 
/*  74 */     setContainer(container);
/*     */   }
/*     */ 
/*     */   public Object createHomeProxy()
/*     */   {
/*  79 */     throw new RuntimeException("NYI");
/*     */   }
/*     */ 
/*     */   protected void setContainer(Container container)
/*     */   {
/*  84 */     this.container = ((EJBContainer)container);
/*  85 */     this.containerGuid = Ejb3Registry.guid(container);
/*  86 */     this.containerClusterUid = Ejb3Registry.clusterUid(container);
/*  87 */     this.isClustered = container.isClustered();
/*     */   }
/*     */ 
/*     */   protected Container getContainer()
/*     */   {
/*  92 */     if (this.container == null)
/*     */     {
/*  94 */       this.container = ((EJBContainer)Ejb3Registry.findContainer(this.containerGuid));
/*     */ 
/*  96 */       if ((this.container == null) && (this.isClustered)) {
/*  97 */         this.container = ((EJBContainer)Ejb3Registry.getClusterContainer(this.containerClusterUid));
/*     */       }
/*     */     }
/* 100 */     return this.container;
/*     */   }
/*     */ 
/*     */   protected void setEjb21Objects(BaseSessionRemoteProxy proxy)
/*     */   {
/* 105 */     proxy.setHandle(getHandle());
/* 106 */     proxy.setHomeHandle(getHomeHandle());
/* 107 */     proxy.setEjbMetaData(getEjbMetaData());
/*     */   }
/*     */ 
/*     */   protected abstract Handle getHandle();
/*     */ 
/*     */   protected HomeHandle getHomeHandle() {
/* 114 */     EJBContainer ejbContainer = this.container;
/*     */ 
/* 116 */     HomeHandleImpl homeHandle = null;
/*     */ 
/* 118 */     RemoteBinding remoteBindingAnnotation = (RemoteBinding)ejbContainer.resolveAnnotation(RemoteBinding.class);
/* 119 */     if (remoteBindingAnnotation != null) {
/* 120 */       homeHandle = new HomeHandleImpl(ProxyFactoryHelper.getHomeJndiName(this.container));
/*     */     }
/* 122 */     return homeHandle;
/*     */   }
/*     */ 
/*     */   protected EJBMetaData getEjbMetaData()
/*     */   {
/* 127 */     Class remote = null;
/* 128 */     Class home = null;
/* 129 */     Class pkClass = Object.class;
/* 130 */     HomeHandleImpl homeHandle = null;
/*     */ 
/* 132 */     EJBContainer ejbContainer = this.container;
/*     */ 
/* 134 */     Remote remoteAnnotation = (Remote)ejbContainer.resolveAnnotation(Remote.class);
/* 135 */     if (remoteAnnotation != null)
/* 136 */       remote = remoteAnnotation.value()[0];
/* 137 */     RemoteHome homeAnnotation = (RemoteHome)ejbContainer.resolveAnnotation(RemoteHome.class);
/* 138 */     if (homeAnnotation != null)
/* 139 */       home = homeAnnotation.value();
/* 140 */     RemoteBinding remoteBindingAnnotation = (RemoteBinding)ejbContainer.resolveAnnotation(RemoteBinding.class);
/* 141 */     if (remoteBindingAnnotation != null) {
/* 142 */       homeHandle = new HomeHandleImpl(remoteBindingAnnotation.jndiBinding());
/*     */     }
/* 144 */     EJBMetaDataImpl metadata = new EJBMetaDataImpl(remote, home, pkClass, true, false, homeHandle);
/*     */ 
/* 146 */     return metadata;
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/* 151 */     this.containerGuid = in.readUTF();
/* 152 */     this.containerClusterUid = in.readUTF();
/* 153 */     this.isClustered = in.readBoolean();
/*     */ 
/* 155 */     if (getContainer() == null)
/* 156 */       throw new EJBException("Invalid (i.e. remote) invocation of local interface (null container) for " + this.containerGuid);
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out) throws IOException
/*     */   {
/* 161 */     out.writeUTF(this.containerGuid);
/* 162 */     out.writeUTF(this.containerClusterUid);
/* 163 */     out.writeBoolean(this.isClustered);
/*     */   }
/*     */ 
/*     */   protected void ensureEjb21ViewComplete(Class<?> home, Class<?>[] localOrRemoteInterfaces)
/*     */     throws RuntimeException
/*     */   {
/* 179 */     assert ((home == null) || (EJBHome.class.isAssignableFrom(home)) || (EJBLocalHome.class.isAssignableFrom(home)));
/*     */ 
/* 182 */     for (Class localOrRemoteInterface : localOrRemoteInterfaces)
/*     */     {
/* 184 */       assert ((EJBObject.class.isAssignableFrom(localOrRemoteInterface)) || (EJBLocalObject.class.isAssignableFrom(localOrRemoteInterface)));
/*     */     }
/*     */ 
/* 189 */     if ((home != null) && (localOrRemoteInterfaces.length == 0))
/*     */     {
/* 191 */       throw new RuntimeException("EJBTHREE-1075: " + this.container.getBeanClassName() + " defines home" + " but provides no local/remote interfaces extending " + EJBLocalObject.class.getName() + "/" + EJBObject.class.getName() + "; EJB 2.1 view cannot be realized");
/*     */     }
/*     */ 
/* 197 */     if ((home == null) && (localOrRemoteInterfaces.length != 0))
/*     */     {
/* 199 */       throw new RuntimeException("EJBTHREE-1075: " + this.container.getBeanClassName() + " defines local/remote interfaces" + " but provides no home; EJB 2.1 view cannot be realized");
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  59 */     log = Logger.getLogger(BaseSessionProxyFactory.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.session.BaseSessionProxyFactory
 * JD-Core Version:    0.6.0
 */