/*     */ package org.jboss.ejb3.session;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.aop.annotation.AnnotationRepository;
/*     */ import org.jboss.ejb3.Ejb3Deployment;
/*     */ import org.jboss.ejb3.ProxyFactory;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.ejb3.annotation.LocalBinding;
/*     */ import org.jboss.ejb3.annotation.RemoteBinding;
/*     */ import org.jboss.ejb3.annotation.RemoteBindings;
/*     */ import org.jboss.ejb3.annotation.impl.LocalBindingImpl;
/*     */ import org.jboss.ejb3.annotation.impl.RemoteBindingImpl;
/*     */ import org.jboss.ejb3.annotation.impl.RemoteBindingsImpl;
/*     */ import org.jboss.ejb3.remoting.RemoteProxyFactory;
/*     */ import org.jboss.ejb3.remoting.RemoteProxyFactoryRegistry;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ProxyDeployer
/*     */ {
/*     */   private static final Logger log;
/*     */   private SessionContainer container;
/*  50 */   private ArrayList<ProxyFactory> proxyFactories = new ArrayList();
/*     */   private RemoteBindings remoteBindings;
/*     */   private LocalBinding localBinding;
/*     */ 
/*     */   public ProxyDeployer(SessionContainer container)
/*     */   {
/*  56 */     assert (container != null) : "container is null";
/*     */ 
/*  58 */     this.container = container;
/*     */   }
/*     */   public List<ProxyFactory> getProxyFactories() {
/*  61 */     return this.proxyFactories;
/*     */   }
/*     */ 
/*     */   public void start() throws Exception {
/*  65 */     if (this.remoteBindings != null)
/*     */     {
/*  67 */       RemoteBinding[] list = this.remoteBindings.value();
/*  68 */       for (RemoteBinding binding : list)
/*     */       {
/*  70 */         assert (binding.jndiBinding().length() != 0) : ("jndiBinding not set on binding " + binding);
/*     */ 
/*  73 */         String factoryImplementationRegistryKey = binding.factory();
/*     */         RemoteProxyFactory factory;
/*     */         RemoteProxyFactory factory;
/*  74 */         if (factoryImplementationRegistryKey.equals("RemoteProxyFactory"))
/*     */         {
/*  76 */           factory = this.container.createRemoteProxyFactory(binding);
/*     */         }
/*     */         else
/*     */         {
/*  80 */           Class remoteFactoryClass = this.container.getDeployment().getRemoteProxyFactoryRegistry().getProxyFactoryClass(binding.factory());
/*  81 */           Constructor constructor = remoteFactoryClass.getConstructor(new Class[] { SessionContainer.class, RemoteBinding.class });
/*  82 */           factory = (RemoteProxyFactory)constructor.newInstance(new Object[] { this.container, binding });
/*     */         }
/*  84 */         factory.start();
/*  85 */         this.proxyFactories.add(factory);
/*     */       }
/*     */     }
/*     */ 
/*  89 */     if (this.localBinding != null)
/*     */     {
/*  91 */       ProxyFactory factory = this.container.createProxyFactory(this.localBinding);
/*  92 */       factory.start();
/*  93 */       this.proxyFactories.add(factory);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean hasJNDIBinding(String jndiName)
/*     */   {
/*  99 */     assert (jndiName != null) : "jndiName is null";
/*     */ 
/* 101 */     if (this.localBinding != null)
/*     */     {
/* 103 */       if (this.localBinding.jndiBinding().equals(jndiName)) {
/* 104 */         return true;
/*     */       }
/*     */     }
/* 107 */     if (this.remoteBindings != null)
/*     */     {
/* 109 */       for (RemoteBinding binding : this.remoteBindings.value())
/*     */       {
/* 111 */         if (binding.jndiBinding().equals(jndiName)) {
/* 112 */           return true;
/*     */         }
/*     */       }
/*     */     }
/* 116 */     return false;
/*     */   }
/*     */ 
/*     */   public void initializeLocalBindingMetadata()
/*     */   {
/* 121 */     this.localBinding = ((LocalBinding)this.container.resolveAnnotation(LocalBinding.class));
/* 122 */     if (this.localBinding == null)
/*     */     {
/* 124 */       if (ProxyFactoryHelper.getLocalAndBusinessLocalInterfaces(this.container).length > 0)
/*     */       {
/* 126 */         this.localBinding = new LocalBindingImpl(ProxyFactoryHelper.getLocalJndiName(this.container));
/* 127 */         this.container.getAnnotations().addClassAnnotation(LocalBinding.class, this.localBinding);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private RemoteBinding initializeRemoteBinding(RemoteBinding binding)
/*     */   {
/* 134 */     if (binding.jndiBinding().length() == 0)
/*     */     {
/* 136 */       return new RemoteBindingImpl(ProxyFactoryHelper.getDefaultRemoteJndiName(this.container), binding.interceptorStack(), binding.clientBindUrl(), binding.factory());
/*     */     }
/* 138 */     return binding;
/*     */   }
/*     */ 
/*     */   public void initializeRemoteBindingMetadata()
/*     */   {
/* 143 */     this.remoteBindings = ((RemoteBindings)this.container.resolveAnnotation(RemoteBindings.class));
/* 144 */     if (this.remoteBindings == null)
/*     */     {
/* 146 */       RemoteBinding binding = (RemoteBinding)this.container.resolveAnnotation(RemoteBinding.class);
/* 147 */       if (binding == null)
/*     */       {
/* 149 */         log.debug("no declared remote bindings for : " + this.container.getEjbName());
/* 150 */         if (ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(this.container).length > 0)
/*     */         {
/* 152 */           log.debug("there is remote interfaces for " + this.container.getEjbName());
/* 153 */           String jndiName = ProxyFactoryHelper.getDefaultRemoteJndiName(this.container);
/* 154 */           log.debug("default remote binding has jndiName of " + jndiName);
/* 155 */           String uri = "";
/* 156 */           RemoteBinding[] list = { new RemoteBindingImpl(jndiName, "", uri, "RemoteProxyFactory") };
/* 157 */           this.remoteBindings = new RemoteBindingsImpl(list);
/* 158 */           this.container.getAnnotations().addClassAnnotation(RemoteBindings.class, this.remoteBindings);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 163 */         RemoteBinding[] list = { initializeRemoteBinding(binding) };
/* 164 */         this.remoteBindings = new RemoteBindingsImpl(list);
/* 165 */         this.container.getAnnotations().addClassAnnotation(RemoteBindings.class, this.remoteBindings);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 170 */       List list = new ArrayList();
/* 171 */       for (RemoteBinding binding : this.remoteBindings.value())
/*     */       {
/* 173 */         list.add(initializeRemoteBinding(binding));
/*     */       }
/* 175 */       this.remoteBindings = new RemoteBindingsImpl(list);
/* 176 */       this.container.getAnnotations().addClassAnnotation(RemoteBindings.class, this.remoteBindings);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 182 */     for (int i = 0; i < this.proxyFactories.size(); i++)
/*     */     {
/* 184 */       ProxyFactory factory = (ProxyFactory)this.proxyFactories.get(i);
/* 185 */       factory.stop();
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  48 */     log = Logger.getLogger(ProxyDeployer.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.session.ProxyDeployer
 * JD-Core Version:    0.6.0
 */