/*     */ package org.jboss.ejb3.session;
/*     */ 
/*     */ import gnu.trove.TLongObjectHashMap;
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBLocalHome;
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.LocalHome;
/*     */ import javax.ejb.RemoteHome;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.Dispatcher;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.InvocationResponse;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.aspects.asynch.FutureHolder;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.EJBContainerInvocation;
/*     */ import org.jboss.ejb3.Ejb3Deployment;
/*     */ import org.jboss.ejb3.ProxyFactory;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.ejb3.ProxyUtils;
/*     */ import org.jboss.ejb3.ThreadLocalStack;
/*     */ import org.jboss.ejb3.annotation.LocalBinding;
/*     */ import org.jboss.ejb3.annotation.RemoteBinding;
/*     */ import org.jboss.ejb3.annotation.RemoteBindings;
/*     */ import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
/*     */ import org.jboss.ejb3.remoting.RemoteProxyFactory;
/*     */ import org.jboss.ejb3.stateful.StatefulContainerInvocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.serial.io.MarshalledObjectForLocalCalls;
/*     */ 
/*     */ public abstract class SessionContainer extends EJBContainer
/*     */ {
/*  71 */   private static final Logger log = Logger.getLogger(SessionContainer.class);
/*     */   protected ProxyDeployer proxyDeployer;
/*  74 */   protected Map clusterFamilies = new HashMap();
/*     */ 
/* 138 */   protected ThreadLocalStack<InvokedMethod> invokedMethod = new ThreadLocalStack();
/*     */ 
/*     */   /** @deprecated */
/*     */   public Object createLocalProxy(Object id)
/*     */     throws Exception
/*     */   {
/*  96 */     LocalBinding binding = (LocalBinding)getAnnotation(LocalBinding.class);
/*  97 */     return createLocalProxy(id, binding);
/*     */   }
/*     */ 
/*     */   public abstract Object createLocalProxy(Object paramObject, LocalBinding paramLocalBinding)
/*     */     throws Exception;
/*     */ 
/*     */   @Deprecated
/*     */   public Object createRemoteProxy(Object id)
/*     */     throws Exception
/*     */   {
/* 119 */     RemoteBinding binding = null;
/* 120 */     RemoteBindings bindings = (RemoteBindings)getAnnotation(RemoteBindings.class);
/* 121 */     if (bindings != null)
/* 122 */       binding = bindings.value()[0];
/*     */     else {
/* 124 */       binding = (RemoteBinding)getAnnotation(RemoteBinding.class);
/*     */     }
/* 126 */     return createRemoteProxy(id, binding);
/*     */   }
/*     */ 
/*     */   public abstract Object createRemoteProxy(Object paramObject, RemoteBinding paramRemoteBinding)
/*     */     throws Exception;
/*     */ 
/*     */   public SessionContainer(ClassLoader cl, String beanClassName, String ejbName, AspectManager manager, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment)
/*     */   {
/* 144 */     super("jboss.j2ee:service=EJB3,name=" + ejbName, manager, cl, beanClassName, ejbName, ctxProperties, interceptorRepository, deployment);
/* 145 */     this.proxyDeployer = new ProxyDeployer(this);
/*     */   }
/*     */ 
/*     */   protected abstract ProxyFactory createProxyFactory(LocalBinding paramLocalBinding);
/*     */ 
/*     */   protected abstract RemoteProxyFactory createRemoteProxyFactory(RemoteBinding paramRemoteBinding);
/*     */ 
/*     */   public Class<?> getInvokedBusinessInterface()
/*     */   {
/* 166 */     InvokedMethod method = (InvokedMethod)this.invokedMethod.get();
/* 167 */     if (method == null) throw new IllegalStateException("getInvokedBusinessInterface() being invoked outside of a business invocation");
/* 168 */     if (method.method == null) throw new IllegalStateException("getInvokedBusinessInterface() being invoked outside of a business invocation");
/* 169 */     if (method.isLocalInterface) return method.method.getDeclaringClass();
/* 170 */     Class[] remoteInterfaces = ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(this);
/* 171 */     for (Class intf : remoteInterfaces)
/*     */     {
/*     */       try
/*     */       {
/* 175 */         intf.getMethod(method.method.getName(), method.method.getParameterTypes());
/* 176 */         return intf;
/*     */       }
/*     */       catch (NoSuchMethodException ignored)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 183 */     throw new IllegalStateException("Unable to find geInvokedBusinessInterface()");
/*     */   }
/*     */ 
/*     */   public void instantiated()
/*     */   {
/* 189 */     super.instantiated();
/* 190 */     this.proxyDeployer.initializeRemoteBindingMetadata();
/* 191 */     this.proxyDeployer.initializeLocalBindingMetadata();
/*     */   }
/*     */ 
/*     */   protected List<Class<?>> resolveBusinessInterfaces()
/*     */   {
/* 198 */     List list = new ArrayList();
/* 199 */     list.addAll(Arrays.asList(ProxyFactoryHelper.getLocalBusinessInterfaces(this)));
/* 200 */     list.addAll(Arrays.asList(ProxyFactoryHelper.getRemoteBusinessInterfaces(this)));
/*     */ 
/* 202 */     return list;
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 207 */     super.start();
/*     */ 
/* 209 */     Dispatcher.singleton.registerTarget(getObjectName().getCanonicalName(), this);
/* 210 */     this.proxyDeployer.start();
/*     */   }
/*     */ 
/*     */   public Map getClusterFamilies()
/*     */   {
/* 215 */     return this.clusterFamilies;
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 222 */       this.proxyDeployer.stop();
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/* 226 */       log.trace("Proxy deployer stop failed", ignore);
/*     */     }
/*     */     try
/*     */     {
/* 230 */       Dispatcher.singleton.unregisterTarget(getObjectName().getCanonicalName());
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/* 234 */       log.trace("Dispatcher unregister target failed", ignore);
/*     */     }
/* 236 */     super.stop();
/*     */   }
/*     */ 
/*     */   protected void createMethodMap()
/*     */   {
/* 241 */     super.createMethodMap();
/*     */     try
/*     */     {
/* 244 */       RemoteHome home = (RemoteHome)resolveAnnotation(RemoteHome.class);
/* 245 */       if (home != null)
/*     */       {
/* 247 */         Method[] declaredMethods = home.value().getMethods();
/* 248 */         for (int i = 0; i < declaredMethods.length; i++)
/*     */         {
/* 250 */           long hash = MethodHashing.methodHash(declaredMethods[i]);
/* 251 */           this.advisedMethods.put(hash, declaredMethods[i]);
/*     */         }
/*     */ 
/* 254 */         declaredMethods = EJBObject.class.getMethods();
/* 255 */         for (int i = 0; i < declaredMethods.length; i++)
/*     */         {
/* 257 */           long hash = MethodHashing.methodHash(declaredMethods[i]);
/* 258 */           this.advisedMethods.put(hash, declaredMethods[i]);
/*     */         }
/*     */       }
/*     */ 
/* 262 */       LocalHome localHome = (LocalHome)resolveAnnotation(LocalHome.class);
/* 263 */       if (localHome != null)
/*     */       {
/* 265 */         Method[] declaredMethods = localHome.value().getMethods();
/* 266 */         for (int i = 0; i < declaredMethods.length; i++)
/*     */         {
/* 268 */           long hash = MethodHashing.methodHash(declaredMethods[i]);
/* 269 */           this.advisedMethods.put(hash, declaredMethods[i]);
/*     */         }
/*     */ 
/* 272 */         declaredMethods = EJBLocalObject.class.getMethods();
/* 273 */         for (int i = 0; i < declaredMethods.length; i++)
/*     */         {
/* 275 */           long hash = MethodHashing.methodHash(declaredMethods[i]);
/* 276 */           this.advisedMethods.put(hash, declaredMethods[i]);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 282 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean isHomeMethod(Method method)
/*     */   {
/* 288 */     if (EJBHome.class.isAssignableFrom(method.getDeclaringClass())) return true;
/* 289 */     return EJBLocalHome.class.isAssignableFrom(method.getDeclaringClass());
/*     */   }
/*     */ 
/*     */   protected boolean isEJBObjectMethod(Method method)
/*     */   {
/* 295 */     if (method.getDeclaringClass().getName().equals("javax.ejb.EJBObject")) {
/* 296 */       return true;
/*     */     }
/*     */ 
/* 299 */     return method.getDeclaringClass().getName().equals("javax.ejb.EJBLocalObject");
/*     */   }
/*     */ 
/*     */   protected boolean isHandleMethod(Method method)
/*     */   {
/* 307 */     return method.getDeclaringClass().getName().equals("javax.ejb.Handle");
/*     */   }
/*     */ 
/*     */   public static InvocationResponse marshallException(Invocation invocation, Throwable exception, Map responseContext)
/*     */     throws Throwable
/*     */   {
/* 314 */     if (invocation.getMetaData("IS_LOCAL", "IS_LOCAL") == null) throw exception;
/*     */ 
/* 316 */     InvocationResponse response = new InvocationResponse();
/* 317 */     response.setContextInfo(responseContext);
/*     */ 
/* 319 */     response.addAttachment("IS_LOCAL_EXCEPTION", new MarshalledObjectForLocalCalls(exception));
/*     */ 
/* 321 */     return response;
/*     */   }
/*     */ 
/*     */   public static InvocationResponse marshallResponse(Invocation invocation, Object rtn, Map responseContext)
/*     */     throws IOException
/*     */   {
/*     */     InvocationResponse response;
/*     */     InvocationResponse response;
/* 329 */     if ((rtn != null) && (invocation.getMetaData("IS_LOCAL", "IS_LOCAL") != null))
/*     */     {
/* 331 */       response = new InvocationResponse(new MarshalledObjectForLocalCalls(rtn));
/*     */     }
/*     */     else
/*     */     {
/* 335 */       response = new InvocationResponse(rtn);
/*     */     }
/* 337 */     response.setContextInfo(responseContext);
/* 338 */     return response;
/*     */   }
/*     */ 
/*     */   public Object invoke(ProxyFactory factory, Object id, Method method, Object[] args, FutureHolder provider)
/*     */     throws Throwable
/*     */   {
/* 355 */     ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
/* 356 */     pushEnc();
/*     */     try
/*     */     {
/* 359 */       long hash = MethodHashing.calculateHash(method);
/* 360 */       MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
/* 361 */       if (info == null)
/*     */       {
/* 363 */         throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
/*     */       }
/*     */ 
/* 368 */       Method unadvisedMethod = info.getUnadvisedMethod();
/*     */       Object localObject1;
/* 370 */       if ((unadvisedMethod != null) && (isHomeMethod(unadvisedMethod)))
/*     */       {
/* 372 */         localObject1 = invokeHomeMethod(factory, info, args);
/*     */         return localObject1;
/*     */       }
/* 374 */       if ((unadvisedMethod != null) && (isEJBObjectMethod(unadvisedMethod)))
/*     */       {
/* 376 */         localObject1 = invokeEJBObjectMethod(factory, id, info, args);
/*     */         return localObject1;
/*     */       }
/* 380 */       Object nextInvocation = new StatefulContainerInvocation(info, id);
/* 381 */       ((EJBContainerInvocation)nextInvocation).setAdvisor(this);
/* 382 */       ((EJBContainerInvocation)nextInvocation).setArguments(args);
/*     */ 
/* 385 */       nextInvocation = populateInvocation((EJBContainerInvocation)nextInvocation);
/*     */ 
/* 387 */       ProxyUtils.addLocalAsynchronousInfo((MethodInvocation)nextInvocation, provider);
/*     */       try
/*     */       {
/* 390 */         this.invokedMethod.push(new InvokedMethod(true, method));
/* 391 */         Object localObject2 = ((EJBContainerInvocation)nextInvocation).invokeNext();
/*     */ 
/* 395 */         this.invokedMethod.pop();
/*     */ 
/* 400 */         Thread.currentThread().setContextClassLoader(oldLoader);
/* 401 */         popEnc(); return localObject2;
/*     */       }
/*     */       finally
/*     */       {
/* 395 */         this.invokedMethod.pop();
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 400 */       Thread.currentThread().setContextClassLoader(oldLoader);
/* 401 */       popEnc(); } throw localObject4;
/*     */   }
/*     */ 
/*     */   private Object invokeHomeMethod(ProxyFactory factory, MethodInfo info, Object[] args)
/*     */     throws Exception
/*     */   {
/* 410 */     Method unadvisedMethod = info.getUnadvisedMethod();
/* 411 */     if (unadvisedMethod.getName().equals("create"))
/*     */     {
/* 413 */       Class[] initParameterTypes = new Class[0];
/* 414 */       Object[] initParameterValues = new Object[0];
/* 415 */       if (unadvisedMethod.getParameterTypes().length > 0)
/*     */       {
/* 417 */         initParameterTypes = unadvisedMethod.getParameterTypes();
/* 418 */         initParameterValues = args;
/*     */       }
/*     */ 
/* 421 */       Object id = createSession(initParameterTypes, initParameterValues);
/*     */ 
/* 423 */       Object proxy = factory.createProxy(id);
/*     */ 
/* 425 */       return proxy;
/*     */     }
/* 427 */     if (unadvisedMethod.getName().equals("remove"))
/*     */     {
/* 429 */       if ((args[0] instanceof Handle))
/* 430 */         removeHandle((Handle)args[0]);
/*     */       else {
/* 432 */         destroySession(args[0]);
/*     */       }
/* 434 */       return null;
/*     */     }
/*     */ 
/* 438 */     throw new IllegalArgumentException("illegal home method " + unadvisedMethod);
/*     */   }
/*     */ 
/*     */   public abstract Object createSession(Class[] paramArrayOfClass, Object[] paramArrayOfObject);
/*     */ 
/*     */   public abstract Object localInvoke(Object paramObject, Method paramMethod, Object[] paramArrayOfObject, FutureHolder paramFutureHolder)
/*     */     throws Throwable;
/*     */ 
/*     */   public abstract Object localHomeInvoke(Method paramMethod, Object[] paramArrayOfObject)
/*     */     throws Throwable;
/*     */ 
/*     */   public Object createSession()
/*     */   {
/* 457 */     return createSession(null, null);
/*     */   }
/*     */ 
/*     */   protected void destroySession(Object id)
/*     */   {
/* 467 */     throw new RuntimeException("NYI");
/*     */   }
/*     */ 
/*     */   public boolean hasJNDIBinding(String jndiName)
/*     */   {
/* 476 */     return this.proxyDeployer.hasJNDIBinding(jndiName);
/*     */   }
/*     */ 
/*     */   protected Object invokeEJBObjectMethod(ProxyFactory factory, Object id, MethodInfo info, Object[] args) throws Exception
/*     */   {
/* 481 */     Method unadvisedMethod = info.getUnadvisedMethod();
/* 482 */     if (unadvisedMethod.getName().equals("getEJBHome"))
/*     */     {
/* 484 */       return factory.createHomeProxy();
/*     */     }
/* 486 */     if (unadvisedMethod.getName().equals("getPrimaryKey"))
/*     */     {
/* 488 */       return id;
/*     */     }
/* 490 */     if (unadvisedMethod.getName().equals("isIdentical"))
/*     */     {
/* 493 */       if (id == null) {
/* 494 */         return Boolean.valueOf(false);
/*     */       }
/* 496 */       EJBObject bean = (EJBObject)args[0];
/*     */ 
/* 498 */       Object primaryKey = bean.getPrimaryKey();
/* 499 */       if (primaryKey == null) {
/* 500 */         return Boolean.valueOf(false);
/*     */       }
/* 502 */       boolean isIdentical = id.equals(primaryKey);
/*     */ 
/* 504 */       return Boolean.valueOf(isIdentical);
/*     */     }
/* 506 */     if (unadvisedMethod.getName().equals("remove"))
/*     */     {
/* 508 */       destroySession(id);
/*     */ 
/* 510 */       return null;
/*     */     }
/* 512 */     throw new RuntimeException("NYI");
/*     */   }
/*     */ 
/*     */   protected EJBContainerInvocation populateInvocation(EJBContainerInvocation invocation)
/*     */   {
/* 523 */     return invocation;
/*     */   }
/*     */ 
/*     */   protected abstract void removeHandle(Handle paramHandle)
/*     */     throws Exception;
/*     */ 
/*     */   public class InvokedMethod
/*     */   {
/*     */     public boolean isLocalInterface;
/*     */     public Method method;
/*     */ 
/*     */     public InvokedMethod(boolean localInterface, Method method)
/*     */     {
/*  80 */       this.isLocalInterface = localInterface;
/*  81 */       this.method = method;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.session.SessionContainer
 * JD-Core Version:    0.6.0
 */