/*      */ package org.jboss.ejb3.stateful;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.ObjectStreamException;
/*      */ import java.io.Serializable;
/*      */ import java.util.ArrayList;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import java.util.concurrent.locks.ReentrantLock;
/*      */ import javax.ejb.EJBContext;
/*      */ import javax.persistence.EntityManager;
/*      */ import javax.transaction.Synchronization;
/*      */ import javax.transaction.Transaction;
/*      */ import javax.transaction.TransactionManager;
/*      */ import org.jboss.aop.metadata.SimpleMetaData;
/*      */ import org.jboss.ejb3.Ejb3Registry;
/*      */ import org.jboss.ejb3.ThreadLocalStack;
/*      */ import org.jboss.ejb3.cache.Identifiable;
/*      */ import org.jboss.ejb3.cache.StatefulCache;
/*      */ import org.jboss.ejb3.interceptor.InterceptorInfo;
/*      */ import org.jboss.ejb3.session.SessionBeanContext;
/*      */ import org.jboss.ejb3.session.SessionContainer;
/*      */ import org.jboss.ejb3.tx.TxUtil;
/*      */ import org.jboss.serial.io.MarshalledObject;
/*      */ import org.jboss.tm.TxUtils;
/*      */ import org.jboss.util.id.GUID;
/*      */ 
/*      */ public class StatefulBeanContext extends SessionBeanContext
/*      */   implements Identifiable, Serializable
/*      */ {
/*      */   private static final long serialVersionUID = -102470788178912606L;
/*      */   protected Object id;
/*  102 */   protected boolean txSynchronized = false;
/*      */ 
/*  104 */   protected boolean inInvocation = false;
/*      */   protected MarshalledObject beanMO;
/*  108 */   protected ReentrantLock lock = new ReentrantLock();
/*      */   protected boolean discarded;
/*      */   public static ThreadLocalStack<StatefulBeanContext> propagatedContainedIn;
/*      */   public static ThreadLocalStack<StatefulBeanContext> currentBean;
/*      */   protected StatefulBeanContext containedIn;
/*      */   protected List<StatefulBeanContext> contains;
/*      */   protected HashMap<String, EntityManager> persistenceContexts;
/*      */   protected boolean removed;
/*      */   protected String containerClusterUid;
/*      */   protected String containerGuid;
/*  128 */   protected boolean isClustered = false;
/*      */ 
/*  130 */   protected boolean replicationIsPassivation = true;
/*      */ 
/*  132 */   protected transient boolean passivated = false;
/*      */ 
/*  822 */   public volatile boolean markedForPassivation = false;
/*      */ 
/*  824 */   public volatile boolean markedForReplication = false;
/*      */ 
/*  829 */   private volatile boolean inUse = false;
/*      */ 
/*  831 */   public long lastUsed = System.currentTimeMillis();
/*      */ 
/*      */   protected StatefulBeanContext(SessionContainer container, MarshalledObject beanMO)
/*      */   {
/*  142 */     super(container);
/*      */ 
/*  144 */     assert (beanMO != null) : "beanMO is null";
/*      */ 
/*  146 */     this.containerClusterUid = Ejb3Registry.clusterUid(container);
/*  147 */     this.containerGuid = Ejb3Registry.guid(container);
/*  148 */     this.isClustered = container.isClustered();
/*  149 */     this.beanMO = beanMO;
/*      */   }
/*      */ 
/*      */   protected StatefulBeanContext(SessionContainer container, Object bean)
/*      */   {
/*  160 */     super(container, bean);
/*      */ 
/*  162 */     this.containerClusterUid = Ejb3Registry.clusterUid(container);
/*  163 */     this.containerGuid = Ejb3Registry.guid(container);
/*  164 */     this.isClustered = container.isClustered();
/*  165 */     this.id = new GUID();
/*      */   }
/*      */ 
/*      */   public List<StatefulBeanContext> getContains()
/*      */   {
/*  170 */     if (this.bean == null)
/*  171 */       extractBeanAndInterceptors();
/*  172 */     return this.contains;
/*      */   }
/*      */ 
/*      */   private List<StatefulBeanContext> getThreadSafeContains()
/*      */   {
/*  185 */     List orig = getContains();
/*  186 */     List copy = null;
/*  187 */     if (orig != null)
/*      */     {
/*  189 */       synchronized (orig)
/*      */       {
/*  191 */         copy = new ArrayList(orig);
/*      */       }
/*      */     }
/*  194 */     return copy;
/*      */   }
/*      */ 
/*      */   public EJBContext getEJBContext()
/*      */   {
/*  200 */     if (this.ejbContext == null)
/*  201 */       this.ejbContext = new StatefulSessionContextImpl(this);
/*  202 */     return this.ejbContext;
/*      */   }
/*      */ 
/*      */   public EntityManager getExtendedPersistenceContext(String id)
/*      */   {
/*  207 */     EntityManager found = null;
/*  208 */     Map extendedPCS = getExtendedPersistenceContexts();
/*  209 */     if (extendedPCS != null)
/*      */     {
/*  211 */       found = (EntityManager)extendedPCS.get(id);
/*      */     }
/*  213 */     if (found != null)
/*  214 */       return found;
/*  215 */     if (this.containedIn != null)
/*      */     {
/*  217 */       found = this.containedIn.getExtendedPersistenceContext(id);
/*      */     }
/*  219 */     return found;
/*      */   }
/*      */ 
/*      */   public void addExtendedPersistenceContext(String id, EntityManager pc)
/*      */   {
/*  224 */     Map extendedPCS = getExtendedPersistenceContexts();
/*  225 */     if (extendedPCS == null)
/*      */     {
/*  227 */       extendedPCS = this.persistenceContexts = new HashMap();
/*      */     }
/*  229 */     extendedPCS.put(id, pc);
/*      */   }
/*      */ 
/*      */   public boolean scanForExtendedPersistenceContext(String id, StatefulBeanContext ignore)
/*      */   {
/*  234 */     if (equals(ignore)) {
/*  235 */       return false;
/*      */     }
/*  237 */     if (!this.removed)
/*      */     {
/*  239 */       Map extendedPCS = getExtendedPersistenceContexts();
/*  240 */       if ((extendedPCS != null) && (extendedPCS.containsKey(id))) {
/*  241 */         return true;
/*      */       }
/*      */     }
/*  244 */     if (getContains() != null)
/*      */     {
/*  246 */       synchronized (this.contains)
/*      */       {
/*  248 */         for (StatefulBeanContext contained : this.contains)
/*      */         {
/*  250 */           if (!contained.equals(ignore))
/*      */           {
/*  252 */             if (contained.scanForExtendedPersistenceContext(id, ignore)) {
/*  253 */               return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*  259 */     return false;
/*      */   }
/*      */ 
/*      */   public void removeExtendedPersistenceContext(String id)
/*      */   {
/*  264 */     Map extendedPCS = getExtendedPersistenceContexts();
/*  265 */     if (extendedPCS != null)
/*      */     {
/*  267 */       extendedPCS.remove(id);
/*      */     }
/*      */ 
/*  270 */     if (getContains() != null)
/*      */     {
/*  272 */       synchronized (this.contains)
/*      */       {
/*  274 */         for (StatefulBeanContext contained : this.contains)
/*      */         {
/*  276 */           contained.removeExtendedPersistenceContext(id);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Map<String, EntityManager> getExtendedPersistenceContexts()
/*      */   {
/*  284 */     if (this.persistenceContexts == null)
/*      */     {
/*  286 */       if (this.bean == null)
/*  287 */         extractBeanAndInterceptors();
/*      */     }
/*  289 */     return this.persistenceContexts;
/*      */   }
/*      */ 
/*      */   public StatefulBeanContext getContainedIn()
/*      */   {
/*  294 */     return this.containedIn;
/*      */   }
/*      */ 
/*      */   public StatefulBeanContext getUltimateContainedIn()
/*      */   {
/*  299 */     StatefulBeanContext child = this;
/*  300 */     StatefulBeanContext parent = this.containedIn;
/*      */ 
/*  302 */     while (parent != null)
/*      */     {
/*  304 */       child = parent;
/*  305 */       parent = parent.getContainedIn();
/*      */     }
/*      */ 
/*  308 */     if ((parent == null) && (this != child))
/*      */     {
/*  314 */       StatefulCache ultimateCache = ((StatefulContainer)child.getContainer()).getCache();
/*  315 */       child = ultimateCache.get(child.getId(), false);
/*      */     }
/*      */ 
/*  318 */     return child;
/*      */   }
/*      */ 
/*      */   public void addContains(StatefulBeanContext ctx)
/*      */   {
/*  323 */     if (getContains() == null) {
/*  324 */       this.contains = new ArrayList();
/*      */     }
/*  326 */     synchronized (this.contains)
/*      */     {
/*  328 */       this.contains.add(ctx);
/*  329 */       ctx.containedIn = this;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeContains(StatefulBeanContext ctx)
/*      */   {
/*  335 */     if (getContains() != null)
/*      */     {
/*  338 */       synchronized (this.contains)
/*      */       {
/*  340 */         if (this.contains.remove(ctx))
/*      */         {
/*  342 */           ctx.containedIn = null;
/*      */         }
/*      */       }
/*      */ 
/*  346 */       if (this.removed)
/*      */       {
/*  349 */         cleanExtendedPCs();
/*      */       }
/*      */ 
/*  352 */       if (getCanRemoveFromCache())
/*      */       {
/*  354 */         if (this.containedIn != null)
/*      */         {
/*  356 */           this.containedIn.removeContains(this);
/*      */         }
/*      */ 
/*  360 */         ((StatefulContainer)getContainer()).getCache().remove(getId());
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public StatefulBeanContext pushContainedIn()
/*      */   {
/*  367 */     StatefulBeanContext thisPtr = this;
/*  368 */     if (propagatedContainedIn.getList() != null)
/*      */     {
/*  382 */       this.containedIn = ((StatefulBeanContext)propagatedContainedIn.get());
/*  383 */       NestedStatefulBeanContext nested = new NestedStatefulBeanContext(getContainer(), this.bean);
/*  384 */       nested.id = this.id;
/*  385 */       nested.container = getContainer();
/*  386 */       nested.containerClusterUid = this.containerClusterUid;
/*  387 */       nested.containerGuid = this.containerGuid;
/*  388 */       nested.isClustered = this.isClustered;
/*  389 */       nested.replicationIsPassivation = this.replicationIsPassivation;
/*  390 */       this.containedIn.addContains(nested);
/*  391 */       thisPtr = new ProxiedStatefulBeanContext(nested);
/*      */     }
/*  393 */     propagatedContainedIn.push(thisPtr);
/*  394 */     return thisPtr;
/*      */   }
/*      */ 
/*      */   public boolean getCanPassivate()
/*      */   {
/*  402 */     boolean canPassivate = (this.removed) || (!this.inUse);
/*      */ 
/*  407 */     if ((canPassivate) && (this.contains != null))
/*      */     {
/*  409 */       synchronized (this.contains)
/*      */       {
/*  411 */         for (StatefulBeanContext contained : this.contains)
/*      */         {
/*  413 */           if (!contained.getCanPassivate())
/*      */           {
/*  415 */             canPassivate = false;
/*  416 */             break;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  422 */     return canPassivate;
/*      */   }
/*      */ 
/*      */   public void prePassivate()
/*      */   {
/*  431 */     if ((!this.removed) && (!this.passivated))
/*      */     {
/*  433 */       getContainer().invokePrePassivate(this);
/*  434 */       this.passivated = true;
/*      */     }
/*      */ 
/*  438 */     List children = getThreadSafeContains();
/*  439 */     if (children != null)
/*      */     {
/*  441 */       for (StatefulBeanContext contained : children)
/*      */       {
/*  443 */         contained.prePassivate();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void postActivate()
/*      */   {
/*  454 */     if ((!this.removed) && (this.passivated))
/*      */     {
/*  456 */       getContainer().invokePostActivate(this);
/*  457 */       this.passivated = false;
/*      */     }
/*      */ 
/*  461 */     List children = getThreadSafeContains();
/*  462 */     if (children != null)
/*      */     {
/*  464 */       for (StatefulBeanContext contained : children)
/*      */       {
/*  466 */         contained.postActivate();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void passivateAfterReplication()
/*      */   {
/*  481 */     if ((!this.removed) && (!this.passivated))
/*      */     {
/*  483 */       getInstance();
/*  484 */       getContainer().invokePrePassivate(this);
/*  485 */       this.passivated = true;
/*      */     }
/*      */ 
/*  491 */     if (this.contains != null)
/*      */     {
/*  494 */       List children = getThreadSafeContains();
/*  495 */       if (children != null)
/*      */       {
/*  497 */         for (StatefulBeanContext contained : children)
/*      */         {
/*  499 */           contained.passivateAfterReplication();
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void activateAfterReplication()
/*      */   {
/*  507 */     if ((!this.removed) && (this.passivated))
/*      */     {
/*  509 */       getInstance();
/*  510 */       getContainer().invokePostActivate(this);
/*  511 */       this.passivated = false;
/*      */     }
/*      */ 
/*  515 */     List children = getThreadSafeContains();
/*  516 */     if (children != null)
/*      */     {
/*  518 */       for (StatefulBeanContext contained : children)
/*      */       {
/*  520 */         contained.activateAfterReplication();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean getReplicationIsPassivation()
/*      */   {
/*  527 */     return this.replicationIsPassivation;
/*      */   }
/*      */ 
/*      */   public void setReplicationIsPassivation(boolean replicationIsPassivation)
/*      */   {
/*  532 */     this.replicationIsPassivation = replicationIsPassivation;
/*      */   }
/*      */ 
/*      */   public void preReplicate()
/*      */   {
/*  541 */     if ((!this.removed) && (this.replicationIsPassivation) && (!this.passivated))
/*      */     {
/*  543 */       getContainer().invokePrePassivate(this);
/*  544 */       this.passivated = true;
/*      */     }
/*      */ 
/*  548 */     List children = getThreadSafeContains();
/*  549 */     if (children != null)
/*      */     {
/*  551 */       for (StatefulBeanContext contained : children)
/*      */       {
/*  553 */         contained.preReplicate();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void postReplicate()
/*      */   {
/*  569 */     if ((!this.removed) && (this.passivated))
/*      */     {
/*  571 */       getContainer().invokePostActivate(this);
/*  572 */       this.passivated = false;
/*      */     }
/*      */ 
/*  576 */     List children = getThreadSafeContains();
/*  577 */     if (children != null)
/*      */     {
/*  579 */       for (StatefulBeanContext contained : children)
/*      */       {
/*  581 */         contained.postReplicate();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void popContainedIn()
/*      */   {
/*  588 */     propagatedContainedIn.pop();
/*      */   }
/*      */ 
/*      */   public boolean isInUse()
/*      */   {
/*  593 */     return this.inUse;
/*      */   }
/*      */ 
/*      */   public void setInUse(boolean inUse)
/*      */   {
/*  598 */     this.inUse = inUse;
/*      */   }
/*      */ 
/*      */   public boolean isDiscarded()
/*      */   {
/*  603 */     return this.discarded;
/*      */   }
/*      */ 
/*      */   public void setDiscarded(boolean discarded)
/*      */   {
/*  608 */     this.discarded = discarded;
/*      */   }
/*      */ 
/*      */   public ReentrantLock getLock()
/*      */   {
/*  613 */     return this.lock;
/*      */   }
/*      */ 
/*      */   public boolean isInInvocation()
/*      */   {
/*  618 */     return this.inInvocation;
/*      */   }
/*      */ 
/*      */   public void setInInvocation(boolean inInvocation)
/*      */   {
/*  623 */     this.inInvocation = inInvocation;
/*      */   }
/*      */ 
/*      */   public Object getId()
/*      */   {
/*  628 */     return this.id;
/*      */   }
/*      */ 
/*      */   public boolean isTxSynchronized()
/*      */   {
/*  633 */     return this.txSynchronized;
/*      */   }
/*      */ 
/*      */   public void setTxSynchronized(boolean txSynchronized)
/*      */   {
/*  638 */     this.txSynchronized = txSynchronized;
/*      */   }
/*      */ 
/*      */   public boolean isRemoved()
/*      */   {
/*  643 */     return this.removed;
/*      */   }
/*      */ 
/*      */   public void remove()
/*      */   {
/*  648 */     if (this.removed)
/*  649 */       return;
/*  650 */     this.removed = true;
/*  651 */     RuntimeException exceptionThrown = null;
/*      */     try
/*      */     {
/*  657 */       cleanExtendedPCs();
/*      */     }
/*      */     catch (RuntimeException e)
/*      */     {
/*  663 */       if (exceptionThrown == null) {
/*  664 */         exceptionThrown = e;
/*      */       }
/*      */     }
/*  667 */     if ((this.containedIn != null) && (getCanRemoveFromCache()))
/*      */     {
/*      */       try
/*      */       {
/*  671 */         this.containedIn.removeContains(this);
/*      */       }
/*      */       catch (RuntimeException e)
/*      */       {
/*  677 */         if (exceptionThrown == null) {
/*  678 */           exceptionThrown = e;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  684 */     this.bean = null;
/*  685 */     this.interceptorInstances = null;
/*      */ 
/*  687 */     if (exceptionThrown != null) throw new RuntimeException("exception thrown while removing SFSB", exceptionThrown);
/*      */   }
/*      */ 
/*      */   public boolean getCanRemoveFromCache()
/*      */   {
/*  692 */     boolean canRemove = this.removed;
/*      */ 
/*  694 */     if ((canRemove) && (getContains() != null))
/*      */     {
/*  696 */       synchronized (this.contains)
/*      */       {
/*  698 */         canRemove = this.contains.size() == 0;
/*      */       }
/*      */     }
/*      */ 
/*  702 */     return canRemove;
/*      */   }
/*      */ 
/*      */   private void cleanExtendedPCs()
/*      */   {
/*      */     try
/*      */     {
/*  709 */       Transaction tx = TxUtil.getTransactionManager().getTransaction();
/*  710 */       if ((tx != null) && (TxUtils.isActive(tx)))
/*      */       {
/*  712 */         tx.registerSynchronization(new XPCCloseSynchronization(this, null));
/*      */       }
/*      */       else
/*      */       {
/*  716 */         closeExtendedPCs();
/*      */       }
/*      */     }
/*      */     catch (RuntimeException e)
/*      */     {
/*  721 */       throw e;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  725 */       throw new RuntimeException("Error cleaning PersistenceContexts in SFSB removal", e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void closeExtendedPCs()
/*      */   {
/*  731 */     Map extendedPCS = getExtendedPersistenceContexts();
/*  732 */     if (extendedPCS != null)
/*      */     {
/*  734 */       RuntimeException exceptionThrown = null;
/*      */ 
/*  736 */       List closedXPCs = new ArrayList();
/*  737 */       StatefulBeanContext topCtx = getUltimateContainedIn();
/*      */ 
/*  739 */       Iterator iter = extendedPCS.entrySet().iterator();
/*  740 */       while (iter.hasNext())
/*      */       {
/*  742 */         Map.Entry entry = (Map.Entry)iter.next();
/*  743 */         String id = (String)entry.getKey();
/*  744 */         EntityManager xpc = (EntityManager)entry.getValue();
/*      */ 
/*  748 */         boolean canClose = topCtx.scanForExtendedPersistenceContext(id, this);
/*      */ 
/*  750 */         if ((canClose) && (getContains() != null))
/*      */         {
/*  753 */           synchronized (this.contains)
/*      */           {
/*  755 */             for (StatefulBeanContext contained : this.contains)
/*      */             {
/*  757 */               if (contained.scanForExtendedPersistenceContext(id, null))
/*      */               {
/*  759 */                 canClose = false;
/*  760 */                 break;
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/*  766 */         if (canClose)
/*      */         {
/*      */           try
/*      */           {
/*  770 */             xpc.close();
/*  771 */             closedXPCs.add(id);
/*      */           }
/*      */           catch (RuntimeException e)
/*      */           {
/*  775 */             exceptionThrown = e;
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  781 */       for (String id : closedXPCs)
/*      */       {
/*  783 */         topCtx.removeExtendedPersistenceContext(id);
/*      */       }
/*      */ 
/*  786 */       if (exceptionThrown != null) throw new RuntimeException("Error closing PersistenceContexts in SFSB removal", exceptionThrown);
/*      */     }
/*      */   }
/*      */ 
/*      */   public SessionContainer getContainer()
/*      */   {
/*  793 */     if (this.container == null)
/*      */     {
/*  795 */       this.container = ((SessionContainer)Ejb3Registry.findContainer(this.containerGuid));
/*      */ 
/*  797 */       if ((this.isClustered) && (this.container == null)) {
/*  798 */         this.container = ((SessionContainer)Ejb3Registry.getClusterContainer(this.containerClusterUid));
/*      */       }
/*      */     }
/*  801 */     return (SessionContainer)this.container;
/*      */   }
/*      */ 
/*      */   public Object getInstance()
/*      */   {
/*  807 */     if (this.bean == null)
/*      */     {
/*  809 */       extractBeanAndInterceptors();
/*      */     }
/*  811 */     assert (this.bean != null) : "bean is null";
/*  812 */     return this.bean;
/*      */   }
/*      */ 
/*      */   public SimpleMetaData getMetaData()
/*      */   {
/*  818 */     return super.getMetaData();
/*      */   }
/*      */ 
/*      */   public Object[] getInterceptorInstances(InterceptorInfo[] interceptorInfos)
/*      */   {
/*  836 */     if (this.bean == null)
/*      */     {
/*  838 */       extractBeanAndInterceptors();
/*      */     }
/*  840 */     return super.getInterceptorInstances(interceptorInfos);
/*      */   }
/*      */ 
/*      */   protected synchronized void extractBeanAndInterceptors()
/*      */   {
/*  845 */     if (this.beanMO == null) {
/*  846 */       return;
/*      */     }
/*      */     try
/*      */     {
/*  850 */       Object[] beanAndInterceptors = (Object[])(Object[])this.beanMO.get();
/*  851 */       this.bean = beanAndInterceptors[0];
/*  852 */       this.persistenceContexts = ((HashMap)beanAndInterceptors[1]);
/*  853 */       ArrayList list = (ArrayList)beanAndInterceptors[2];
/*  854 */       this.interceptorInstances = new HashMap();
/*      */       Iterator i$;
/*  855 */       if (list != null)
/*      */       {
/*  857 */         for (i$ = list.iterator(); i$.hasNext(); ) { Object o = i$.next();
/*      */ 
/*  859 */           this.interceptorInstances.put(o.getClass(), o);
/*      */         }
/*      */       }
/*  862 */       this.contains = ((List)beanAndInterceptors[3]);
/*      */ 
/*  865 */       if (this.contains != null)
/*      */       {
/*  867 */         for (StatefulBeanContext contained : this.contains)
/*      */         {
/*  869 */           contained.containedIn = this;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  875 */       this.beanMO = null;
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  879 */       throw new RuntimeException(e);
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*  883 */       throw new RuntimeException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private Object writeReplace() throws ObjectStreamException
/*      */   {
/*  889 */     Serialized state = new Serialized(null);
/*  890 */     if (this.beanMO == null)
/*      */     {
/*  892 */       Object[] beanAndInterceptors = new Object[4];
/*  893 */       beanAndInterceptors[0] = this.bean;
/*  894 */       beanAndInterceptors[1] = this.persistenceContexts;
/*  895 */       if ((this.interceptorInstances != null) && (this.interceptorInstances.size() > 0))
/*      */       {
/*  897 */         ArrayList list = new ArrayList();
/*  898 */         list.addAll(this.interceptorInstances.values());
/*  899 */         beanAndInterceptors[2] = list;
/*      */       }
/*  901 */       beanAndInterceptors[3] = this.contains;
/*      */       try
/*      */       {
/*  910 */         MarshalledObject mo = new MarshalledObject(beanAndInterceptors);
/*  911 */         Serialized.access$302(state, mo);
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/*  915 */         throw new RuntimeException("Marshalling of bean " + this.bean + " failed", e);
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  924 */       Serialized.access$302(state, this.beanMO);
/*      */     }
/*      */ 
/*  927 */     Serialized.access$402(state, this.containerClusterUid);
/*  928 */     Serialized.access$502(state, this.containerGuid);
/*  929 */     Serialized.access$602(state, this.isClustered);
/*  930 */     Serialized.access$702(state, this.id);
/*  931 */     Serialized.access$802(state, this.lastUsed);
/*  932 */     Serialized.access$902(state, this.metadata);
/*  933 */     Serialized.access$1002(state, this.removed);
/*  934 */     Serialized.access$1102(state, this.replicationIsPassivation);
/*  935 */     return state;
/*      */   }
/*      */ 
/*      */   public Object getInvokedMethodKey()
/*      */   {
/*  998 */     return getId();
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*  114 */     propagatedContainedIn = new ThreadLocalStack();
/*      */ 
/*  116 */     currentBean = new ThreadLocalStack();
/*      */   }
/*      */ 
/*      */   private static class XPCCloseSynchronization
/*      */     implements Synchronization
/*      */   {
/*      */     private StatefulBeanContext ctx;
/*      */ 
/*      */     private XPCCloseSynchronization(StatefulBeanContext context)
/*      */     {
/* 1007 */       this.ctx = context;
/*      */     }
/*      */ 
/*      */     public void beforeCompletion()
/*      */     {
/*      */     }
/*      */ 
/*      */     public void afterCompletion(int status)
/*      */     {
/* 1016 */       this.ctx.closeExtendedPCs();
/*      */ 
/* 1018 */       this.ctx = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class Serialized
/*      */     implements Serializable
/*      */   {
/*      */     private static final long serialVersionUID = 1L;
/*      */     private String containerClusterUid;
/*      */     private String containerGuid;
/*   73 */     private boolean isClustered = false;
/*      */     private Object id;
/*      */     private SimpleMetaData metadata;
/*      */     private long lastUsed;
/*      */     private MarshalledObject beanMO;
/*      */     private boolean removed;
/*      */     private boolean replicationIsPassivation;
/*      */ 
/*      */     private Object readResolve()
/*      */       throws ObjectStreamException
/*      */     {
/*   83 */       StatefulContainer container = (StatefulContainer)Ejb3Registry.findContainer(this.containerGuid);
/*      */ 
/*   85 */       if ((this.isClustered) && (container == null)) {
/*   86 */         container = (StatefulContainer)Ejb3Registry.getClusterContainer(this.containerClusterUid);
/*      */       }
/*   88 */       StatefulBeanContext context = new StatefulBeanContext(container, this.beanMO);
/*   89 */       context.id = this.id;
/*   90 */       StatefulBeanContext.access$002(context, this.metadata);
/*   91 */       context.lastUsed = this.lastUsed;
/*   92 */       context.removed = this.removed;
/*   93 */       context.replicationIsPassivation = this.replicationIsPassivation;
/*      */ 
/*   95 */       context.passivated = true;
/*   96 */       return context;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.StatefulBeanContext
 * JD-Core Version:    0.6.0
 */