/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.aspects.asynch.AsynchMixin;
/*     */ import org.jboss.aspects.asynch.AsynchProvider;
/*     */ import org.jboss.aspects.remoting.FamilyWrapper;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.JBossProxy;
/*     */ import org.jboss.ejb3.ProxyUtils;
/*     */ import org.jboss.ejb3.remoting.BaseRemoteProxy;
/*     */ import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class StatefulClusteredProxy extends BaseRemoteProxy
/*     */ {
/*     */   private static final long serialVersionUID = -1797802577940671292L;
/*     */   private Object id;
/*     */   protected FamilyWrapper family;
/*     */   protected LoadBalancePolicy lbPolicy;
/*     */   AsynchProvider provider;
/*     */   protected String partitionName;
/*     */ 
/*     */   public StatefulClusteredProxy(Container container, Interceptor[] interceptors, FamilyWrapper family, LoadBalancePolicy lb, String partitionName)
/*     */   {
/*  65 */     super(container, interceptors);
/*  66 */     this.family = family;
/*  67 */     this.lbPolicy = lb;
/*  68 */     this.partitionName = partitionName;
/*     */   }
/*     */ 
/*     */   public StatefulClusteredProxy(AsynchProvider provider, String containerId, String containerGuid, Interceptor[] interceptors, FamilyWrapper family, LoadBalancePolicy lb, String partitionName)
/*     */   {
/*  73 */     super(containerId, containerGuid, interceptors);
/*  74 */     this.provider = provider;
/*  75 */     this.family = family;
/*  76 */     this.lbPolicy = lb;
/*  77 */     this.partitionName = partitionName;
/*     */   }
/*     */ 
/*     */   protected StatefulClusteredProxy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  87 */     if (method.getDeclaringClass() == AsynchProvider.class)
/*     */     {
/*  89 */       return this.provider.getFuture();
/*     */     }
/*     */ 
/*  92 */     long hash = MethodHashing.calculateHash(method);
/*  93 */     Object ret = ProxyUtils.handleCallLocally(hash, (JBossProxy)proxy, this, method, args);
/*  94 */     if (ret != null)
/*     */     {
/*  96 */       return ret;
/*     */     }
/*     */ 
/*  99 */     StatefulRemoteInvocation sri = new StatefulRemoteInvocation(this.interceptors, hash, method, method, null, this.id);
/* 100 */     sri.setArguments(args);
/* 101 */     sri.setInstanceResolver(this.metadata);
/* 102 */     sri.getMetaData().addMetaData("DISPATCHER", "OID", this.containerId, PayloadKey.AS_IS);
/* 103 */     sri.getMetaData().addMetaData("CLUSTERED_REMOTING", "CLUSTER_FAMILY_WRAPPER", this.family, PayloadKey.AS_IS);
/* 104 */     sri.getMetaData().addMetaData("CLUSTERED_REMOTING", "LOADBALANCE_POLICY", this.lbPolicy, PayloadKey.AS_IS);
/* 105 */     sri.getMetaData().addMetaData("REMOTING", "SUBSYSTEM", "AOP", PayloadKey.AS_IS);
/* 106 */     sri.getMetaData().addMetaData("PARTITION_NAME", "PARTITION_NAME", this.partitionName, PayloadKey.TRANSIENT);
/* 107 */     sri.getMetaData().addMetaData("IS_LOCAL", "GUID", this.containerGuid, PayloadKey.AS_IS);
/*     */ 
/* 109 */     if (this.provider != null)
/*     */     {
/* 111 */       sri.getMetaData().addMetaData("ASYNCH", "INVOKE_ASYNCH", "YES", PayloadKey.AS_IS);
/*     */     }
/*     */     try
/*     */     {
/* 115 */       Object rtn = sri.invokeNext();
/*     */ 
/* 117 */       if (this.id == null)
/*     */       {
/* 119 */         this.id = sri.getResponseAttachment("NEW_ID");
/*     */       }
/* 121 */       return rtn;
/*     */     }
/*     */     catch (ForwardId forward)
/*     */     {
/* 127 */       this.id = forward.getId();
/* 128 */     }throw forward.getCause();
/*     */   }
/*     */ 
/*     */   public Object getAsynchronousProxy(Object proxy)
/*     */   {
/* 134 */     Class[] infs = proxy.getClass().getInterfaces();
/* 135 */     if (!ProxyUtils.isAsynchronous(infs))
/*     */     {
/* 137 */       Class[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
/* 138 */       AsynchMixin mixin = new AsynchMixin();
/* 139 */       Interceptor[] newInterceptors = ProxyUtils.addAsynchProxyInterceptor(mixin, this.interceptors);
/* 140 */       StatefulClusteredProxy handler = new StatefulClusteredProxy(mixin, this.containerId, this.containerGuid, newInterceptors, this.family, this.lbPolicy, this.partitionName);
/* 141 */       return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, handler);
/*     */     }
/*     */ 
/* 145 */     return proxy;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 150 */     if (this.id != null)
/*     */     {
/* 152 */       return this.containerId.toString() + ":" + this.id.toString();
/*     */     }
/*     */ 
/* 157 */     GUID guid = new GUID();
/* 158 */     return this.containerId.toString() + ":" + guid.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.StatefulClusteredProxy
 * JD-Core Version:    0.6.0
 */