/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.rmi.dgc.VMID;
/*     */ import java.util.Arrays;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.ejb.LocalHome;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.Ejb3Registry;
/*     */ import org.jboss.ejb3.JBossProxy;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.ejb3.annotation.LocalBinding;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.naming.Util;
/*     */ 
/*     */ public class StatefulLocalProxyFactory extends BaseStatefulProxyFactory
/*     */ {
/*  54 */   private VMID vmid = Ejb3Registry.getVMID();
/*     */ 
/*     */   public StatefulLocalProxyFactory()
/*     */   {
/*     */   }
/*     */ 
/*     */   public StatefulLocalProxyFactory(SessionContainer container, LocalBinding binding)
/*     */   {
/*  66 */     super(container, binding.jndiBinding());
/*     */   }
/*     */ 
/*     */   protected Class<?>[] getInterfaces()
/*     */   {
/*  71 */     SessionContainer statefulContainer = (SessionContainer)getContainer();
/*  72 */     LocalHome localHome = (LocalHome)statefulContainer.resolveAnnotation(LocalHome.class);
/*     */ 
/*  74 */     boolean bindTogether = false;
/*     */ 
/*  76 */     if ((localHome != null) && (bindHomeAndBusinessTogether(statefulContainer))) {
/*  77 */       bindTogether = true;
/*     */     }
/*     */ 
/*  80 */     Set localInterfaces = new HashSet();
/*  81 */     localInterfaces.addAll(Arrays.asList(ProxyFactoryHelper.getLocalAndBusinessLocalInterfaces(getContainer())));
/*     */ 
/*  84 */     ensureEjb21ViewComplete(localHome == null ? null : localHome.value(), ProxyFactoryHelper.getLocalInterfaces(getContainer()));
/*     */ 
/*  88 */     localInterfaces.add(JBossProxy.class);
/*     */ 
/*  91 */     if (bindTogether)
/*     */     {
/*  93 */       localInterfaces.add(localHome.value());
/*     */     }
/*     */ 
/*  97 */     return (Class[])localInterfaces.toArray(new Class[0]);
/*     */   }
/*     */ 
/*     */   protected boolean bindHomeAndBusinessTogether(SessionContainer container)
/*     */   {
/* 104 */     return ProxyFactoryHelper.getLocalHomeJndiName(container).equals(this.jndiName);
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 109 */     super.start();
/*     */     try
/*     */     {
/* 113 */       Util.rebind(getContainer().getInitialContext(), this.jndiName + "StatefulProxyFactory", this);
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 117 */       NamingException namingException = new NamingException("Could not bind stateful local proxy with ejb name " + getContainer().getEjbName() + " into JNDI under jndiName: " + getContainer().getInitialContext().getNameInNamespace() + "/" + this.jndiName + "StatefulProxyFactory");
/* 118 */       namingException.setRootCause(e);
/* 119 */       throw namingException;
/*     */     }
/*     */ 
/* 122 */     SessionContainer statefulContainer = (SessionContainer)getContainer();
/* 123 */     LocalHome localHome = (LocalHome)((EJBContainer)getContainer()).resolveAnnotation(LocalHome.class);
/* 124 */     if ((localHome != null) && (!bindHomeAndBusinessTogether(statefulContainer)))
/*     */     {
/* 126 */       Class[] interfaces = { localHome.value() };
/* 127 */       Object homeProxy = Proxy.newProxyInstance(getContainer().getBeanClass().getClassLoader(), interfaces, new StatefulLocalHomeProxy(getContainer()));
/*     */ 
/* 129 */       Util.rebind(getContainer().getInitialContext(), ProxyFactoryHelper.getLocalHomeJndiName(getContainer()), homeProxy);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 135 */     super.stop();
/* 136 */     Util.unbind(getContainer().getInitialContext(), this.jndiName + "StatefulProxyFactory");
/* 137 */     SessionContainer statefulContainer = (SessionContainer)getContainer();
/* 138 */     LocalHome localHome = (LocalHome)((EJBContainer)getContainer()).resolveAnnotation(LocalHome.class);
/* 139 */     if ((localHome != null) && (!bindHomeAndBusinessTogether(statefulContainer)))
/*     */     {
/* 141 */       Util.unbind(getContainer().getInitialContext(), ProxyFactoryHelper.getLocalHomeJndiName(getContainer()));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object createProxy()
/*     */   {
/* 147 */     SessionContainer sfsb = (SessionContainer)getContainer();
/* 148 */     Object id = sfsb.createSession();
/* 149 */     return constructProxy(new StatefulLocalProxy(getContainer(), id, this.vmid));
/*     */   }
/*     */ 
/*     */   public Object createProxy(Object id)
/*     */   {
/* 154 */     return constructProxy(new StatefulLocalProxy(getContainer(), id, this.vmid));
/*     */   }
/*     */ 
/*     */   public Object createProxy(Class[] initTypes, Object[] initValues)
/*     */   {
/* 159 */     SessionContainer sfsb = (SessionContainer)getContainer();
/* 160 */     Object id = sfsb.createSession(initTypes, initValues);
/* 161 */     return constructProxy(new StatefulLocalProxy(getContainer(), id, this.vmid));
/*     */   }
/*     */ 
/*     */   protected StatefulHandleImpl getHandle()
/*     */   {
/* 166 */     StatefulHandleImpl handle = new StatefulHandleImpl();
/* 167 */     LocalBinding remoteBinding = (LocalBinding)((Advisor)getContainer()).resolveAnnotation(LocalBinding.class);
/* 168 */     if (remoteBinding != null) {
/* 169 */       handle.jndiName = remoteBinding.jndiBinding();
/*     */     }
/* 171 */     return handle;
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 177 */     super.readExternal(in);
/* 178 */     this.vmid = ((VMID)in.readObject());
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 184 */     super.writeExternal(out);
/* 185 */     out.writeObject(this.vmid);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.StatefulLocalProxyFactory
 * JD-Core Version:    0.6.0
 */