/*     */ package org.jboss.ejb3.stateless;
/*     */ 
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.Arrays;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.ejb.LocalHome;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.JBossProxy;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.ejb3.annotation.LocalBinding;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.Util;
/*     */ 
/*     */ public class StatelessLocalProxyFactory extends BaseStatelessProxyFactory
/*     */ {
/*  48 */   private static final Logger log = Logger.getLogger(StatelessLocalProxyFactory.class);
/*     */ 
/*     */   public StatelessLocalProxyFactory(SessionContainer container, LocalBinding binding)
/*     */   {
/*  52 */     super(container, binding.jndiBinding());
/*     */   }
/*     */ 
/*     */   protected Class<?>[] getInterfaces()
/*     */   {
/*  57 */     EJBContainer statelessContainer = (EJBContainer)getContainer();
/*  58 */     LocalHome localHome = (LocalHome)statelessContainer.resolveAnnotation(LocalHome.class);
/*     */ 
/*  60 */     boolean bindTogether = false;
/*     */ 
/*  62 */     if ((localHome != null) && (bindHomeAndBusinessTogether(statelessContainer))) {
/*  63 */       bindTogether = true;
/*     */     }
/*     */ 
/*  66 */     Set localInterfaces = new HashSet();
/*  67 */     localInterfaces.addAll(Arrays.asList(ProxyFactoryHelper.getLocalAndBusinessLocalInterfaces(getContainer())));
/*     */ 
/*  70 */     ensureEjb21ViewComplete(localHome == null ? null : localHome.value(), ProxyFactoryHelper.getLocalInterfaces(getContainer()));
/*     */ 
/*  74 */     if (localInterfaces.size() > 0)
/*     */     {
/*  77 */       localInterfaces.add(JBossProxy.class);
/*     */ 
/*  80 */       if (bindTogether)
/*     */       {
/*  82 */         localInterfaces.add(localHome.value());
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/*  88 */       log.warn("[EJBTHREE-933] NPE when deploying web service beans");
/*     */     }
/*     */ 
/*  92 */     return (Class[])localInterfaces.toArray(new Class[0]);
/*     */   }
/*     */ 
/*     */   protected boolean bindHomeAndBusinessTogether(EJBContainer container)
/*     */   {
/*  98 */     return ProxyFactoryHelper.getLocalHomeJndiName(container).equals(this.jndiName);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 104 */     super.start();
/* 105 */     EJBContainer statelessContainer = (EJBContainer)getContainer();
/* 106 */     LocalHome localHome = (LocalHome)statelessContainer.resolveAnnotation(LocalHome.class);
/* 107 */     if ((localHome != null) && (!bindHomeAndBusinessTogether(statelessContainer)))
/*     */     {
/* 109 */       Class[] interfaces = { localHome.value() };
/* 110 */       Object homeProxy = Proxy.newProxyInstance(getContainer().getBeanClass().getClassLoader(), interfaces, new StatelessLocalProxy(getContainer()));
/*     */ 
/* 112 */       Util.rebind(getContainer().getInitialContext(), ProxyFactoryHelper.getLocalHomeJndiName(getContainer()), homeProxy);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/* 119 */     super.stop();
/* 120 */     EJBContainer statelessContainer = (EJBContainer)getContainer();
/* 121 */     LocalHome localHome = (LocalHome)statelessContainer.resolveAnnotation(LocalHome.class);
/* 122 */     if ((localHome != null) && (!bindHomeAndBusinessTogether(statelessContainer)))
/*     */     {
/* 124 */       Util.unbind(getContainer().getInitialContext(), ProxyFactoryHelper.getLocalHomeJndiName(getContainer()));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object createProxy()
/*     */   {
/* 154 */     return constructProxy(new StatelessLocalProxy(getContainer()));
/*     */   }
/*     */ 
/*     */   protected StatelessHandleImpl getHandle()
/*     */   {
/* 159 */     StatelessHandleImpl handle = new StatelessHandleImpl();
/* 160 */     LocalBinding remoteBinding = (LocalBinding)((Advisor)getContainer()).resolveAnnotation(LocalBinding.class);
/* 161 */     if (remoteBinding != null) {
/* 162 */       handle.jndiName = remoteBinding.jndiBinding();
/*     */     }
/* 164 */     return handle;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateless.StatelessLocalProxyFactory
 * JD-Core Version:    0.6.0
 */