/*     */ package org.jboss.ejb3.stateless;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.aspects.asynch.AsynchMixin;
/*     */ import org.jboss.aspects.asynch.AsynchProvider;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.ProxyUtils;
/*     */ import org.jboss.ejb3.session.BaseSessionRemoteProxy;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class StatelessRemoteProxy extends BaseSessionRemoteProxy
/*     */ {
/*     */   private static final long serialVersionUID = 2583299153931800023L;
/*  50 */   private static final Logger log = Logger.getLogger(StatelessRemoteProxy.class);
/*     */   protected InvokerLocator uri;
/*     */   AsynchProvider provider;
/*     */ 
/*     */   public StatelessRemoteProxy(Container container, Interceptor[] interceptors, InvokerLocator uri)
/*     */   {
/*  57 */     super(container, interceptors);
/*  58 */     this.uri = uri;
/*     */   }
/*     */ 
/*     */   public StatelessRemoteProxy(AsynchProvider provider, String containerId, String containerGuid, Interceptor[] interceptors, InvokerLocator uri)
/*     */   {
/*  63 */     super(containerId, containerGuid, interceptors);
/*  64 */     this.uri = uri;
/*  65 */     this.provider = provider;
/*     */   }
/*     */ 
/*     */   protected StatelessRemoteProxy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  77 */     if (method.getDeclaringClass() == AsynchProvider.class)
/*     */     {
/*  79 */       return this.provider.getFuture();
/*     */     }
/*     */ 
/*  82 */     long hash = MethodHashing.calculateHash(method);
/*  83 */     Object ret = ProxyUtils.handleCallLocally(hash, proxy, this, method, args);
/*  84 */     if (ret != null)
/*     */     {
/*  86 */       return ret;
/*     */     }
/*     */ 
/*  89 */     ret = handleEjb21CallLocally(method, args);
/*  90 */     if (ret != null)
/*     */     {
/*  92 */       return ret;
/*     */     }
/*     */ 
/*  95 */     MethodInvocation sri = new MethodInvocation(this.interceptors, hash, method, method, null);
/*  96 */     sri.setArguments(args);
/*  97 */     sri.setInstanceResolver(this.metadata);
/*  98 */     sri.getMetaData().addMetaData("DISPATCHER", "OID", this.containerId, PayloadKey.AS_IS);
/*  99 */     sri.getMetaData().addMetaData("REMOTING", "INVOKER_LOCATOR", this.uri, PayloadKey.AS_IS);
/* 100 */     sri.getMetaData().addMetaData("REMOTING", "SUBSYSTEM", "AOP", PayloadKey.AS_IS);
/* 101 */     sri.getMetaData().addMetaData("IS_LOCAL", "GUID", this.containerGuid, PayloadKey.AS_IS);
/*     */ 
/* 104 */     if (this.provider != null)
/*     */     {
/* 106 */       sri.getMetaData().addMetaData("ASYNCH", "INVOKE_ASYNCH", "YES", PayloadKey.AS_IS);
/*     */     }
/* 108 */     return sri.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object getAsynchronousProxy(Object proxy)
/*     */   {
/* 113 */     Class[] infs = proxy.getClass().getInterfaces();
/* 114 */     if (!ProxyUtils.isAsynchronous(infs))
/*     */     {
/* 116 */       Class[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
/* 117 */       AsynchMixin mixin = new AsynchMixin();
/* 118 */       Interceptor[] newInterceptors = ProxyUtils.addAsynchProxyInterceptor(mixin, this.interceptors);
/* 119 */       StatelessRemoteProxy handler = new StatelessRemoteProxy(mixin, this.containerId, this.containerGuid, newInterceptors, this.uri);
/* 120 */       return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, handler);
/*     */     }
/*     */ 
/* 124 */     return proxy;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 129 */     return this.containerId.toString();
/*     */   }
/*     */ 
/*     */   private Object handleEjb21CallLocally(Method method, Object[] args)
/*     */   {
/* 134 */     if (method.equals(ProxyUtils.GET_HOME_HANDLE))
/*     */     {
/* 136 */       return this.homeHandle;
/* 137 */     }if (method.equals(ProxyUtils.GET_EJB_METADATA))
/*     */     {
/* 139 */       return this.ejbMetaData;
/* 140 */     }if (method.equals(ProxyUtils.GET_HANDLE))
/*     */     {
/* 142 */       return this.handle;
/*     */     }
/*     */ 
/* 145 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateless.StatelessRemoteProxy
 * JD-Core Version:    0.6.0
 */