/*     */ package org.jboss.ejb3.timerservice.quartz;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import java.util.Date;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.Timer;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.Ejb3Registry;
/*     */ import org.jboss.ejb3.timerservice.TimedObjectInvoker;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.quartz.JobDataMap;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.SchedulerException;
/*     */ import org.quartz.SimpleTrigger;
/*     */ import org.quartz.Trigger;
/*     */ 
/*     */ public class TimerServiceImpl
/*     */   implements TimerService
/*     */ {
/*     */   private static final Logger log;
/*     */   private Scheduler scheduler;
/*     */   private Container container;
/*     */   private ObjectName objectName;
/*     */   private String groupName;
/*  59 */   private long jobNum = 0L;
/*  60 */   private long triggerNum = 0L;
/*     */ 
/*     */   protected TimerServiceImpl(Scheduler scheduler, Container container, TimedObjectInvoker invoker) {
/*  63 */     assert (scheduler != null);
/*  64 */     assert (this.objectName != null);
/*  65 */     assert (container != null);
/*  66 */     assert (invoker != null);
/*     */ 
/*  68 */     this.scheduler = scheduler;
/*  69 */     this.container = container;
/*  70 */     this.objectName = container.getObjectName();
/*  71 */     this.groupName = this.objectName.getCanonicalName();
/*     */   }
/*     */ 
/*     */   protected Timer createTimer(Trigger trigger, Serializable info)
/*     */   {
/*     */     try {
/*  77 */       String name = "myJob" + this.jobNum;
/*  78 */       this.jobNum += 1L;
/*     */ 
/*  80 */       Class jobClass = QuartzTimerJob.class;
/*     */ 
/*  82 */       Timer timer = new TimerImpl(this.scheduler, trigger, info);
/*     */ 
/*  84 */       PersistentTimer persistentTimer = new PersistentTimer(trigger, Ejb3Registry.guid(this.container), info);
/*     */ 
/*  86 */       JobDetail jobDetail = new JobDetail(name, this.groupName, jobClass);
/*  87 */       jobDetail.getJobDataMap().put("timer", persistentTimer);
/*     */ 
/*  89 */       this.scheduler.scheduleJob(jobDetail, trigger);
/*     */ 
/*  91 */       return timer;
/*     */     }
/*     */     catch (SchedulerException e)
/*     */     {
/*  95 */       log.error("createTimer failed", e);
/*  96 */     }throw new EJBException(e.getMessage());
/*     */   }
/*     */ 
/*     */   public Timer createTimer(long duration, Serializable info)
/*     */     throws IllegalArgumentException, IllegalStateException, EJBException
/*     */   {
/* 114 */     if (duration < 0L) throw new IllegalArgumentException("duration must not be negative");
/*     */ 
/* 117 */     Date expiration = new Date(System.currentTimeMillis() + duration);
/* 118 */     return createTimer(expiration, info);
/*     */   }
/*     */ 
/*     */   public Timer createTimer(long initialDuration, long intervalDuration, Serializable info)
/*     */     throws IllegalArgumentException, IllegalStateException, EJBException
/*     */   {
/* 136 */     if (initialDuration < 0L) throw new IllegalArgumentException("initialDuration must not be negative");
/* 137 */     if (intervalDuration < 0L) throw new IllegalArgumentException("intervalDuration must not be negative");
/*     */ 
/* 140 */     Date initialExpiration = new Date(System.currentTimeMillis() + initialDuration);
/*     */ 
/* 142 */     return createTimer(initialExpiration, intervalDuration, info);
/*     */   }
/*     */ 
/*     */   public Timer createTimer(Date expiration, Serializable info)
/*     */     throws IllegalArgumentException, IllegalStateException, EJBException
/*     */   {
/* 158 */     if (expiration == null) throw new IllegalArgumentException("expiration must not be null");
/* 159 */     if (expiration.getTime() < 0L) throw new IllegalArgumentException("expiration.time must not be negative");
/*     */ 
/* 162 */     String triggerName = "myTrigger" + this.triggerNum;
/* 163 */     this.triggerNum += 1L;
/*     */ 
/* 165 */     Trigger trigger = new SimpleTrigger(triggerName, this.groupName, expiration);
/*     */ 
/* 167 */     return createTimer(trigger, info);
/*     */   }
/*     */ 
/*     */   public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info)
/*     */     throws IllegalArgumentException, IllegalStateException, EJBException
/*     */   {
/* 184 */     if (initialExpiration == null) throw new IllegalArgumentException("initialExpiration must not be null");
/* 185 */     if (initialExpiration.getTime() < 0L) throw new IllegalArgumentException("initialExpiration.time must not be negative");
/* 186 */     if (intervalDuration < 0L) throw new IllegalArgumentException("intervalDuration must not be negative");
/*     */ 
/* 189 */     String triggerName = "myTrigger" + this.triggerNum;
/* 190 */     this.triggerNum += 1L;
/* 191 */     Date endTime = null;
/*     */ 
/* 193 */     Trigger trigger = new SimpleTrigger(triggerName, this.groupName, initialExpiration, endTime, SimpleTrigger.REPEAT_INDEFINITELY, intervalDuration);
/*     */ 
/* 195 */     return createTimer(trigger, info);
/*     */   }
/*     */ 
/*     */   protected Scheduler getScheduler()
/*     */   {
/* 200 */     return this.scheduler;
/*     */   }
/*     */ 
/*     */   public Collection getTimers()
/*     */     throws IllegalStateException, EJBException
/*     */   {
/* 212 */     throw new RuntimeException("NYI");
/*     */   }
/*     */ 
/*     */   protected void shutdown()
/*     */   {
/* 217 */     log.debug("shutting down " + this);
/*     */     try
/*     */     {
/* 220 */       String[] triggerNames = this.scheduler.getTriggerNames(this.groupName);
/* 221 */       for (String triggerName : triggerNames)
/* 222 */         this.scheduler.unscheduleJob(triggerName, this.groupName);
/* 223 */       String[] jobNames = this.scheduler.getJobNames(this.groupName);
/* 224 */       for (String jobName : jobNames)
/* 225 */         this.scheduler.deleteJob(jobName, this.groupName);
/*     */     }
/*     */     catch (SchedulerException e)
/*     */     {
/* 229 */       log.error("shutdown failed", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 236 */     return "Timer Service " + this.objectName;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  53 */     log = Logger.getLogger(TimerServiceImpl.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.timerservice.quartz.TimerServiceImpl
 * JD-Core Version:    0.6.0
 */