/*     */ package org.jboss.ejb3.tx;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import javax.transaction.HeuristicMixedException;
/*     */ import javax.transaction.HeuristicRollbackException;
/*     */ import javax.transaction.NotSupportedException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import javax.transaction.UserTransaction;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class UserTransactionImpl
/*     */   implements UserTransaction, Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = 2403204397187452430L;
/*  47 */   protected static Logger log = Logger.getLogger(UserTransactionImpl.class);
/*     */   private TransactionManager tm;
/*     */ 
/*     */   public UserTransactionImpl()
/*     */   {
/*  57 */     if (log.isDebugEnabled())
/*  58 */       log.debug("new UserTx: " + this);
/*  59 */     this.tm = TxUtil.getTransactionManager();
/*     */   }
/*     */ 
/*     */   public void begin()
/*     */     throws NotSupportedException, SystemException
/*     */   {
/*  66 */     this.tm.begin();
/*     */ 
/*  68 */     Transaction tx = this.tm.getTransaction();
/*  69 */     if (log.isDebugEnabled())
/*  70 */       log.debug("UserTx begin: " + tx);
/*     */   }
/*     */ 
/*     */   public void commit()
/*     */     throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException
/*     */   {
/*  78 */     Transaction tx = this.tm.getTransaction();
/*  79 */     if (log.isDebugEnabled()) {
/*  80 */       log.debug("UserTx commit: " + tx);
/*     */     }
/*  82 */     this.tm.commit();
/*     */   }
/*     */ 
/*     */   public void rollback()
/*     */     throws IllegalStateException, SecurityException, SystemException
/*     */   {
/*  88 */     Transaction tx = this.tm.getTransaction();
/*  89 */     if (log.isDebugEnabled())
/*  90 */       log.debug("UserTx rollback: " + tx);
/*  91 */     this.tm.rollback();
/*     */   }
/*     */ 
/*     */   public void setRollbackOnly()
/*     */     throws IllegalStateException, SystemException
/*     */   {
/*  97 */     Transaction tx = this.tm.getTransaction();
/*  98 */     if (log.isDebugEnabled()) {
/*  99 */       log.debug("UserTx setRollbackOnly: " + tx);
/*     */     }
/* 101 */     this.tm.setRollbackOnly();
/*     */   }
/*     */ 
/*     */   public int getStatus()
/*     */     throws SystemException
/*     */   {
/* 107 */     return this.tm.getStatus();
/*     */   }
/*     */ 
/*     */   public void setTransactionTimeout(int seconds)
/*     */     throws SystemException
/*     */   {
/* 117 */     this.tm.setTransactionTimeout(seconds);
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/* 127 */     this.tm = TxUtil.getTransactionManager();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.tx.UserTransactionImpl
 * JD-Core Version:    0.6.0
 */