/*     */ package org.jboss.ha.framework.interfaces;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ 
/*     */ public class FamilyClusterInfoImpl
/*     */   implements FamilyClusterInfo
/*     */ {
/*  44 */   private String familyName = null;
/*  45 */   private ArrayList targets = null;
/*  46 */   private long currentViewId = 0L;
/*  47 */   private boolean isViewMembersInSyncWithViewId = false;
/*     */ 
/*  49 */   private int cursor = 999999999;
/*  50 */   private Object arbitraryObject = null;
/*     */ 
/*     */   protected FamilyClusterInfoImpl(String familyName, List targets, long viewId)
/*     */   {
/*  58 */     this.familyName = familyName;
/*  59 */     this.targets = cloneList(targets);
/*  60 */     this.currentViewId = viewId;
/*     */ 
/*  62 */     this.isViewMembersInSyncWithViewId = false;
/*     */   }
/*     */ 
/*     */   public String getFamilyName()
/*     */   {
/*  69 */     return this.familyName;
/*     */   }
/*     */ 
/*     */   public synchronized List getTargets()
/*     */   {
/*  78 */     return Collections.unmodifiableList(this.targets);
/*     */   }
/*  80 */   public long getCurrentViewId() { return this.currentViewId; } 
/*  81 */   public int getCursor() { return this.cursor; } 
/*  82 */   public int setCursor(int cursor) { return this.cursor = cursor; } 
/*  83 */   public Object getObject() { return this.arbitraryObject; } 
/*  84 */   public Object setObject(Object whatever) { this.arbitraryObject = whatever; return this.arbitraryObject; }
/*     */ 
/*     */   public List removeDeadTarget(Object target)
/*     */   {
/*  88 */     synchronized (this)
/*     */     {
/*  90 */       ArrayList tmp = (ArrayList)this.targets.clone();
/*  91 */       tmp.remove(target);
/*  92 */       this.targets = tmp;
/*  93 */       this.isViewMembersInSyncWithViewId = false;
/*  94 */       return Collections.unmodifiableList(this.targets);
/*     */     }
/*     */   }
/*     */ 
/*     */   public List updateClusterInfo(List targets, long viewId)
/*     */   {
/* 100 */     synchronized (this)
/*     */     {
/* 102 */       this.targets = cloneList(targets);
/* 103 */       this.currentViewId = viewId;
/* 104 */       this.isViewMembersInSyncWithViewId = true;
/* 105 */       return Collections.unmodifiableList(this.targets);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean currentMembershipInSyncWithViewId()
/*     */   {
/* 111 */     return this.isViewMembersInSyncWithViewId;
/*     */   }
/*     */ 
/*     */   public void resetView()
/*     */   {
/* 116 */     synchronized (this)
/*     */     {
/* 118 */       this.currentViewId = -1L;
/* 119 */       this.isViewMembersInSyncWithViewId = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 127 */     return this.familyName.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 132 */     if ((o instanceof FamilyClusterInfoImpl))
/*     */     {
/* 134 */       FamilyClusterInfoImpl fr = (FamilyClusterInfoImpl)o;
/* 135 */       return fr.familyName == this.familyName;
/*     */     }
/*     */ 
/* 138 */     return false;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 143 */     StringBuffer tmp = new StringBuffer(super.toString());
/* 144 */     tmp.append("{familyName=");
/* 145 */     tmp.append(this.familyName);
/* 146 */     tmp.append(",targets=");
/* 147 */     tmp.append(this.targets);
/* 148 */     tmp.append(",currentViewId=");
/* 149 */     tmp.append(this.currentViewId);
/* 150 */     tmp.append(",isViewMembersInSyncWithViewId=");
/* 151 */     tmp.append(this.isViewMembersInSyncWithViewId);
/* 152 */     tmp.append(",cursor=");
/* 153 */     tmp.append(this.cursor);
/* 154 */     tmp.append(",arbitraryObject=");
/* 155 */     tmp.append(this.arbitraryObject);
/* 156 */     tmp.append("}");
/* 157 */     return tmp.toString();
/*     */   }
/*     */ 
/*     */   private static ArrayList cloneList(List toClone)
/*     */   {
/* 169 */     if ((toClone instanceof ArrayList))
/*     */     {
/* 171 */       synchronized (toClone)
/*     */       {
/* 173 */         return (ArrayList)((ArrayList)toClone).clone();
/*     */       }
/*     */     }
/*     */ 
/* 177 */     ArrayList clone = new ArrayList(toClone.size());
/* 178 */     synchronized (toClone)
/*     */     {
/* 180 */       clone.addAll(toClone);
/*     */     }
/* 182 */     return (ArrayList)clone;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ha.framework.interfaces.FamilyClusterInfoImpl
 * JD-Core Version:    0.6.0
 */