/*     */ package org.jboss.iiop;
/*     */ 
/*     */ import B;
/*     */ import java.util.Collections;
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.classloading.spi.RealClassLoader;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.proxy.compiler.IIOPStubCompiler;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ import org.jboss.web.WebClassLoader;
/*     */ 
/*     */ public class WebCL extends WebClassLoader
/*     */ {
/*  45 */   static Logger logger = Logger.getLogger(WebCL.class);
/*     */ 
/*  48 */   private Map loadedStubMap = Collections.synchronizedMap(new WeakHashMap());
/*     */ 
/*     */   public WebCL(ObjectName container, RealClassLoader parent)
/*     */   {
/*  52 */     super(container, parent);
/*  53 */     logger.debug("Constructed WebCL " + toString());
/*  54 */     logger.debug("           parent " + parent.toString());
/*     */ 
/*  57 */     this.standard = true;
/*     */   }
/*     */ 
/*     */   public String getKey()
/*     */   {
/*  63 */     String className = getClass().getName();
/*  64 */     int dot = className.lastIndexOf('.');
/*  65 */     if (dot >= 0)
/*  66 */       className = className.substring(dot + 1);
/*  67 */     String jndiName = getContainer().getKeyProperty("jndiName");
/*  68 */     String key = className + '[' + jndiName + ']';
/*  69 */     return key;
/*     */   }
/*     */ 
/*     */   public byte[] getBytes(Class clz)
/*     */   {
/*  74 */     byte[] code = (byte[])(byte[])this.loadedStubMap.get(clz);
/*  75 */     return code == null ? null : (byte[])(byte[])code.clone();
/*     */   }
/*     */ 
/*     */   protected Class findClass(String name)
/*     */     throws ClassNotFoundException
/*     */   {
/*  81 */     if (logger.isTraceEnabled()) {
/*  82 */       logger.trace("findClass(" + name + ") called");
/*     */     }
/*  84 */     if (name.endsWith("_Stub")) {
/*  85 */       int start = name.lastIndexOf('.') + 1;
/*  86 */       if (name.charAt(start) == '_') {
/*  87 */         String pkg = name.substring(0, start);
/*  88 */         String interfaceName = pkg + name.substring(start + 1, name.length() - 5);
/*     */ 
/*  97 */         if (interfaceName.startsWith("org.omg.stub.com.sun.")) {
/*  98 */           interfaceName = interfaceName.substring(13);
/*     */         }
/* 100 */         Class intf = super.loadClass(interfaceName);
/* 101 */         if (logger.isTraceEnabled()) {
/* 102 */           logger.trace("loaded class " + interfaceName);
/*     */         }
/*     */         try
/*     */         {
/* 106 */           byte[] code = IIOPStubCompiler.compile(intf, name);
/*     */ 
/* 109 */           if (logger.isTraceEnabled()) {
/* 110 */             logger.trace("compiled stub class for " + interfaceName);
/*     */           }
/*     */ 
/* 113 */           Class clz = defineClass(name, code, 0, code.length);
/* 114 */           if (logger.isTraceEnabled()) {
/* 115 */             logger.trace("defined stub class for " + interfaceName);
/*     */           }
/*     */ 
/* 118 */           resolveClass(clz);
/*     */           try {
/* 120 */             clz.newInstance();
/*     */           }
/*     */           catch (Throwable t)
/*     */           {
/* 124 */             throw new NestedRuntimeException(t);
/*     */           }
/* 126 */           if (logger.isTraceEnabled()) {
/* 127 */             logger.trace("resolved stub class for " + interfaceName);
/*     */           }
/*     */ 
/* 130 */           this.loadedStubMap.put(clz, code);
/* 131 */           return clz;
/*     */         }
/*     */         catch (RuntimeException e) {
/* 134 */           logger.error("failed finding class " + name, e);
/*     */ 
/* 136 */           return super.findClass(name);
/*     */         }
/*     */       }
/*     */ 
/* 140 */       return super.findClass(name);
/*     */     }
/*     */ 
/* 144 */     return super.findClass(name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.WebCL
 * JD-Core Version:    0.6.0
 */