/*    */ package org.jboss.iiop.csiv2;
/*    */ 
/*    */ import org.omg.CORBA.LocalObject;
/*    */ import org.omg.CORBA.Object;
/*    */ import org.omg.IOP.Codec;
/*    */ import org.omg.IOP.CodecFactory;
/*    */ import org.omg.IOP.Encoding;
/*    */ import org.omg.PortableInterceptor.ORBInitInfo;
/*    */ import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
/*    */ import org.omg.PortableInterceptor.ORBInitializer;
/*    */ 
/*    */ public class SASClientInitializer extends LocalObject
/*    */   implements ORBInitializer
/*    */ {
/*    */   public void pre_init(ORBInitInfo info)
/*    */   {
/*    */     try
/*    */     {
/* 65 */       SASCurrent sasCurrent = new SASCurrentImpl();
/* 66 */       info.register_initial_reference("SASCurrent", sasCurrent);
/*    */     }
/*    */     catch (InvalidName e)
/*    */     {
/* 74 */       throw new RuntimeException("Could not register initial reference for SASCurrent: " + e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void post_init(ORBInitInfo info)
/*    */   {
/*    */     try
/*    */     {
/* 86 */       Encoding encoding = new Encoding(0, 1, 0);
/*    */ 
/* 89 */       Codec codec = info.codec_factory().create_codec(encoding);
/*    */ 
/* 92 */       Object obj = info.resolve_initial_references("SASCurrent");
/* 93 */       SASCurrentImpl sasCurrentImpl = (SASCurrentImpl)obj;
/* 94 */       SASClientInterceptor clientInterceptor = new SASClientInterceptor(codec);
/*    */ 
/* 96 */       info.add_client_request_interceptor(clientInterceptor);
/*    */ 
/* 99 */       SASTargetInterceptor serverInterceptor = new SASTargetInterceptor(codec);
/*    */ 
/* 101 */       info.add_server_request_interceptor(serverInterceptor);
/*    */ 
/* 104 */       sasCurrentImpl.init(serverInterceptor);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 108 */       throw new RuntimeException("Unexpected " + e);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.csiv2.SASClientInitializer
 * JD-Core Version:    0.6.0
 */