/*     */ package org.jboss.iiop.csiv2;
/*     */ 
/*     */ import org.jboss.ejb.plugins.SecurityInterceptor.AuthenticationObserver;
/*     */ import org.jboss.system.Registry;
/*     */ import org.omg.CORBA.LocalObject;
/*     */ import org.omg.IOP.Codec;
/*     */ import org.omg.IOP.CodecFactory;
/*     */ import org.omg.IOP.Encoding;
/*     */ import org.omg.PortableInterceptor.ORBInitInfo;
/*     */ import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
/*     */ import org.omg.PortableInterceptor.ORBInitializer;
/*     */ 
/*     */ public class SASInitializer extends LocalObject
/*     */   implements ORBInitializer
/*     */ {
/*     */   public void pre_init(ORBInitInfo info)
/*     */   {
/*     */     try
/*     */     {
/*  68 */       SASCurrent sasCurrent = new SASCurrentImpl();
/*  69 */       info.register_initial_reference("SASCurrent", sasCurrent);
/*     */     }
/*     */     catch (InvalidName e)
/*     */     {
/*  73 */       throw new RuntimeException("Could not register initial reference for SASCurrent: " + e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void post_init(ORBInitInfo info)
/*     */   {
/*     */     try
/*     */     {
/*  83 */       Encoding encoding = new Encoding(0, 1, 0);
/*     */ 
/*  86 */       Codec codec = info.codec_factory().create_codec(encoding);
/*     */ 
/*  89 */       SASClientIdentityInterceptor clientInterceptor = new SASClientIdentityInterceptor(codec);
/*     */ 
/*  91 */       info.add_client_request_interceptor(clientInterceptor);
/*     */ 
/*  94 */       SASTargetInterceptor serverInterceptor = new SASTargetInterceptor(codec);
/*     */ 
/*  96 */       info.add_server_request_interceptor(serverInterceptor);
/*     */ 
/*  99 */       org.omg.CORBA.Object obj = info.resolve_initial_references("SASCurrent");
/*     */ 
/* 101 */       SASCurrentImpl sasCurrentImpl = (SASCurrentImpl)obj;
/* 102 */       sasCurrentImpl.init(serverInterceptor);
/*     */ 
/* 106 */       Registry.bind("SecurityInterceptor.AuthenticationObserver", new SecurityInterceptor.AuthenticationObserver(sasCurrentImpl)
/*     */       {
/*     */         public void authenticationFailed()
/*     */         {
/* 110 */           this.val$sasCurrentImpl.reject_incoming_context();
/*     */         }
/*     */       });
/*     */     }
/*     */     catch (Exception e) {
/* 116 */       throw new RuntimeException("Unexpected " + e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.csiv2.SASInitializer
 * JD-Core Version:    0.6.0
 */