/*     */ package org.jboss.iiop.jacorb;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.Socket;
/*     */ import javax.net.ssl.SSLServerSocket;
/*     */ import org.apache.avalon.framework.configuration.Configurable;
/*     */ import org.apache.avalon.framework.configuration.ConfigurationException;
/*     */ import org.jacorb.orb.ORB;
/*     */ import org.jacorb.orb.factory.ServerSocketFactory;
/*     */ import org.jboss.iiop.CorbaORBService;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SecurityDomain;
/*     */ import org.jboss.security.ssl.DomainServerSocketFactory;
/*     */ import org.jboss.system.Registry;
/*     */ 
/*     */ public class SSLServerSocketFactory
/*     */   implements ServerSocketFactory, Configurable
/*     */ {
/*  52 */   private static Logger log = Logger.getLogger(SSLServerSocketFactory.class);
/*     */ 
/*  56 */   private DomainServerSocketFactory domainFactory = null;
/*  57 */   private boolean require_mutual_auth = false;
/*  58 */   private boolean request_mutual_auth = false;
/*     */ 
/*     */   public SSLServerSocketFactory(ORB orb)
/*     */     throws IOException
/*     */   {
/*  65 */     log.info("Creating");
/*     */ 
/*  67 */     SecurityDomain securityDomain = (SecurityDomain)Registry.lookup(CorbaORBService.SSL_DOMAIN);
/*     */     try
/*     */     {
/*  72 */       this.domainFactory = new DomainServerSocketFactory(securityDomain);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*  76 */       log.warn("Could not create DomainServerSocketFactory: " + e);
/*  77 */       log.debug("Exception creating DomainServerSockedFactory: ", e);
/*  78 */       throw e;
/*     */     }
/*     */ 
/*  81 */     short serverSupportedOptions = Short.parseShort(orb.getConfiguration().getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
/*     */ 
/*  85 */     short serverRequiredOptions = Short.parseShort(orb.getConfiguration().getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
/*     */ 
/*  91 */     if ((serverSupportedOptions & 0x40) != 0)
/*     */     {
/*  95 */       this.request_mutual_auth = true;
/*     */     }
/*  97 */     if ((serverRequiredOptions & 0x40) != 0)
/*     */     {
/* 101 */       this.require_mutual_auth = true;
/* 102 */       this.request_mutual_auth = false;
/*     */     }
/* 104 */     if (this.request_mutual_auth)
/* 105 */       log.info("Will create SSL sockets that support client authentication");
/* 106 */     else if (this.require_mutual_auth)
/* 107 */       log.info("Will create SSL sockets that require client authentication");
/* 108 */     log.info("Created");
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port)
/*     */     throws IOException
/*     */   {
/* 117 */     SSLServerSocket s = (SSLServerSocket)this.domainFactory.createServerSocket(port);
/*     */ 
/* 120 */     if (this.request_mutual_auth)
/* 121 */       s.setWantClientAuth(this.request_mutual_auth);
/* 122 */     else if (this.require_mutual_auth) {
/* 123 */       s.setNeedClientAuth(this.require_mutual_auth);
/*     */     }
/* 125 */     return s;
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port, int backlog)
/*     */     throws IOException
/*     */   {
/* 131 */     SSLServerSocket s = (SSLServerSocket)this.domainFactory.createServerSocket(port, backlog);
/*     */ 
/* 134 */     if (this.request_mutual_auth)
/* 135 */       s.setWantClientAuth(this.request_mutual_auth);
/* 136 */     else if (this.require_mutual_auth) {
/* 137 */       s.setNeedClientAuth(this.require_mutual_auth);
/*     */     }
/* 139 */     return s;
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress)
/*     */     throws IOException
/*     */   {
/* 147 */     SSLServerSocket s = (SSLServerSocket)this.domainFactory.createServerSocket(port, backlog, ifAddress);
/*     */ 
/* 151 */     if (this.request_mutual_auth)
/* 152 */       s.setWantClientAuth(this.request_mutual_auth);
/* 153 */     else if (this.require_mutual_auth) {
/* 154 */       s.setNeedClientAuth(this.require_mutual_auth);
/*     */     }
/* 156 */     return s;
/*     */   }
/*     */ 
/*     */   public void switchToClientMode(Socket socket)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void configure(org.apache.avalon.framework.configuration.Configuration configuration)
/*     */     throws ConfigurationException
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.jacorb.SSLServerSocketFactory
 * JD-Core Version:    0.6.0
 */