/*    */ package org.jboss.iiop.rmi;
/*    */ 
/*    */ import org.omg.CORBA.Any;
/*    */ 
/*    */ public class ConstantAnalysis extends AbstractAnalysis
/*    */ {
/*    */   private Class type;
/*    */   private Object value;
/*    */ 
/*    */   ConstantAnalysis(String javaName, Class type, Object value)
/*    */   {
/* 49 */     super(javaName);
/*    */ 
/* 51 */     if ((type == Void.TYPE) || ((!type.isPrimitive()) && (type != String.class)))
/*    */     {
/* 53 */       throw new IllegalArgumentException("Bad type for constant: " + type.getName());
/*    */     }
/*    */ 
/* 56 */     this.type = type;
/* 57 */     this.value = value;
/*    */   }
/*    */ 
/*    */   public Class getType()
/*    */   {
/* 67 */     return this.type;
/*    */   }
/*    */ 
/*    */   public Object getValue()
/*    */   {
/* 75 */     return this.value;
/*    */   }
/*    */ 
/*    */   public void insertValue(Any any)
/*    */   {
/* 83 */     if (this.type == String.class)
/* 84 */       any.insert_wstring((String)this.value);
/*    */     else
/* 86 */       Util.insertAnyPrimitive(any, this.value);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.ConstantAnalysis
 * JD-Core Version:    0.6.0
 */