/*    */ package org.jboss.iiop.rmi;
/*    */ 
/*    */ import org.jboss.logging.Logger;
/*    */ import org.omg.CORBA.ParameterMode;
/*    */ 
/*    */ public class ParameterAnalysis extends AbstractAnalysis
/*    */ {
/* 43 */   private static final Logger logger = Logger.getLogger(ParameterAnalysis.class);
/*    */   private Class cls;
/*    */   private String typeIDLName;
/*    */ 
/*    */   ParameterAnalysis(String javaName, Class cls)
/*    */     throws RMIIIOPViolationException
/*    */   {
/* 53 */     super(javaName);
/*    */ 
/* 55 */     this.cls = cls;
/*    */ 
/* 57 */     this.typeIDLName = Util.getTypeIDLName(cls);
/* 58 */     logger.debug("ParameterAnalysis(): cls=[" + cls.getName() + "] typeIDLName=[" + this.typeIDLName + "].");
/*    */   }
/*    */ 
/*    */   public ParameterMode getMode()
/*    */   {
/* 70 */     return ParameterMode.PARAM_IN;
/*    */   }
/*    */ 
/*    */   public Class getCls()
/*    */   {
/* 78 */     return this.cls;
/*    */   }
/*    */ 
/*    */   public String getTypeIDLName()
/*    */   {
/* 86 */     logger.debug("ParameterAnalysis.getTypeIDLName(): cls=[" + this.cls.getName() + "] typeIDLName=[" + this.typeIDLName + "].");
/*    */ 
/* 88 */     return this.typeIDLName;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.ParameterAnalysis
 * JD-Core Version:    0.6.0
 */