/*     */ package org.jboss.iiop.rmi.ir;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.omg.CORBA.AliasDef;
/*     */ import org.omg.CORBA.Any;
/*     */ import org.omg.CORBA.BAD_INV_ORDER;
/*     */ import org.omg.CORBA.ConstantDef;
/*     */ import org.omg.CORBA.Contained;
/*     */ import org.omg.CORBA.ContainedHelper;
/*     */ import org.omg.CORBA.Container;
/*     */ import org.omg.CORBA.ContainerOperations;
/*     */ import org.omg.CORBA.DefinitionKind;
/*     */ import org.omg.CORBA.EnumDef;
/*     */ import org.omg.CORBA.ExceptionDef;
/*     */ import org.omg.CORBA.IDLType;
/*     */ import org.omg.CORBA.Initializer;
/*     */ import org.omg.CORBA.InterfaceDef;
/*     */ import org.omg.CORBA.ModuleDef;
/*     */ import org.omg.CORBA.NativeDef;
/*     */ import org.omg.CORBA.StructDef;
/*     */ import org.omg.CORBA.StructMember;
/*     */ import org.omg.CORBA.UnionDef;
/*     */ import org.omg.CORBA.UnionMember;
/*     */ import org.omg.CORBA.ValueBoxDef;
/*     */ import org.omg.CORBA.ValueDef;
/*     */ 
/*     */ class ContainerImplDelegate
/*     */   implements ContainerOperations
/*     */ {
/*  67 */   private static final Logger logger = Logger.getLogger(ContainerImplDelegate.class);
/*     */ 
/* 367 */   private ArrayList cont = new ArrayList();
/*     */ 
/* 372 */   private Map contMap = new HashMap();
/*     */   private LocalContainer delegateFor;
/*     */ 
/*     */   ContainerImplDelegate(LocalContainer delegateFor)
/*     */   {
/*  77 */     this.delegateFor = delegateFor;
/*     */   }
/*     */ 
/*     */   public LocalContained _lookup(String search_name)
/*     */   {
/*  86 */     logger.debug("ContainerImplDelegate._lookup(\"" + search_name + "\") entered.");
/*     */ 
/*  88 */     if (search_name.startsWith("::")) {
/*  89 */       return this.delegateFor.getRepository()._lookup(search_name.substring(2));
/*     */     }
/*  91 */     int idx = search_name.indexOf("::");
/*  92 */     if (idx > 0) {
/*  93 */       String first = search_name.substring(0, idx);
/*  94 */       logger.debug("ContainerImplDelegate._lookup(\"" + search_name + "\") looking for \"" + first + "\".");
/*     */ 
/*  96 */       Object o = this.contMap.get(first);
/*     */ 
/*  98 */       if ((o == null) || (!(o instanceof LocalContainer))) {
/*  99 */         return null;
/*     */       }
/* 101 */       LocalContainer next = (LocalContainer)o;
/* 102 */       String rest = search_name.substring(idx + 2);
/*     */ 
/* 104 */       return next._lookup(rest);
/*     */     }
/*     */ 
/* 107 */     return (LocalContained)this.contMap.get(search_name);
/*     */   }
/*     */ 
/*     */   public LocalContained[] _contents(DefinitionKind limit_type, boolean exclude_inherited)
/*     */   {
/* 113 */     int target = limit_type.value();
/*     */     Collection found;
/*     */     Collection found;
/* 116 */     if (target == 1) {
/* 117 */       found = this.cont;
/*     */     } else {
/* 119 */       found = new ArrayList();
/* 120 */       for (int i = 0; i < this.cont.size(); i++) {
/* 121 */         LocalContained val = (LocalContained)this.cont.get(i);
/*     */ 
/* 123 */         if ((target != val.def_kind().value()) || (
/* 124 */           (exclude_inherited) && (val.defined_in() != this.delegateFor))) continue;
/* 125 */         found.add(val);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 130 */     LocalContained[] res = new LocalContained[found.size()];
/* 131 */     res = (LocalContained[])(LocalContained[])found.toArray(res);
/*     */ 
/* 133 */     return res;
/*     */   }
/*     */ 
/*     */   public LocalContained[] _lookup_name(String search_name, int levels_to_search, DefinitionKind limit_type, boolean exclude_inherited)
/*     */   {
/* 141 */     if (levels_to_search == 0) {
/* 142 */       return null;
/*     */     }
/* 144 */     if (levels_to_search == -1) {
/* 145 */       levels_to_search++;
/*     */     }
/* 147 */     Collection found = new ArrayList();
/* 148 */     LocalContained[] here = _contents(limit_type, exclude_inherited);
/*     */ 
/* 150 */     for (int i = 0; i < here.length; i++) {
/* 151 */       if (here[i].name().equals(search_name))
/* 152 */         found.add(here[i]);
/*     */     }
/* 154 */     if (levels_to_search >= 0)
/*     */     {
/* 156 */       for (int i = 0; i < here.length; i++) {
/* 157 */         if ((here[i] instanceof Container)) {
/* 158 */           LocalContainer container = (LocalContainer)here[i];
/*     */ 
/* 161 */           LocalContained[] c = container._lookup_name(search_name, levels_to_search - 1, limit_type, exclude_inherited);
/*     */ 
/* 163 */           if (c != null) {
/* 164 */             for (int j = 0; j < c.length; j++) {
/* 165 */               found.add(c[j]);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 172 */     LocalContained[] res = new LocalContained[found.size()];
/* 173 */     res = (LocalContained[])(LocalContained[])found.toArray(res);
/*     */ 
/* 175 */     return res;
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/* 180 */     for (int i = 0; i < this.cont.size(); i++)
/* 181 */       ((LocalContained)this.cont.get(i)).shutdown();
/*     */   }
/*     */ 
/*     */   public Contained lookup(String search_name)
/*     */   {
/* 188 */     LocalContained c = _lookup(search_name);
/*     */ 
/* 190 */     if (c == null) {
/* 191 */       return null;
/*     */     }
/* 193 */     return ContainedHelper.narrow(c.getReference());
/*     */   }
/*     */ 
/*     */   public Contained[] contents(DefinitionKind limit_type, boolean exclude_inherited)
/*     */   {
/* 199 */     LocalContained[] c = _contents(limit_type, exclude_inherited);
/* 200 */     Contained[] res = new Contained[c.length];
/*     */ 
/* 202 */     for (int i = 0; i < c.length; i++) {
/* 203 */       res[i] = ContainedHelper.narrow(c[i].getReference());
/*     */     }
/* 205 */     return res;
/*     */   }
/*     */ 
/*     */   public Contained[] lookup_name(String search_name, int levels_to_search, DefinitionKind limit_type, boolean exclude_inherited)
/*     */   {
/* 212 */     LocalContained[] c = _lookup_name(search_name, levels_to_search, limit_type, exclude_inherited);
/*     */ 
/* 214 */     Contained[] res = new Contained[c.length];
/*     */ 
/* 216 */     for (int i = 0; i < c.length; i++) {
/* 217 */       res[i] = ContainedHelper.narrow(c[i].getReference());
/*     */     }
/* 219 */     return res;
/*     */   }
/*     */ 
/*     */   public org.omg.CORBA.ContainerPackage.Description[] describe_contents(DefinitionKind limit_type, boolean exclude_inherited, int max_returned_objs)
/*     */   {
/* 226 */     Contained[] c = contents(limit_type, exclude_inherited);
/*     */     int returnSize;
/*     */     int returnSize;
/* 229 */     if ((max_returned_objs != -1) && (c.length > max_returned_objs))
/* 230 */       returnSize = max_returned_objs;
/*     */     else {
/* 232 */       returnSize = c.length;
/*     */     }
/* 234 */     org.omg.CORBA.ContainerPackage.Description[] ret = new org.omg.CORBA.ContainerPackage.Description[returnSize];
/*     */ 
/* 236 */     for (int i = 0; i < returnSize; i++) {
/* 237 */       org.omg.CORBA.ContainedPackage.Description d = c[i].describe();
/*     */ 
/* 239 */       ret[i] = new org.omg.CORBA.ContainerPackage.Description(c[i], d.kind, d.value);
/*     */     }
/*     */ 
/* 242 */     return ret;
/*     */   }
/*     */ 
/*     */   public ModuleDef create_module(String id, String name, String version)
/*     */   {
/* 247 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public ConstantDef create_constant(String id, String name, String version, IDLType type, Any value)
/*     */   {
/* 253 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public StructDef create_struct(String id, String name, String version, StructMember[] members)
/*     */   {
/* 259 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public UnionDef create_union(String id, String name, String version, IDLType discriminator_type, UnionMember[] members)
/*     */   {
/* 266 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public EnumDef create_enum(String id, String name, String version, String[] members)
/*     */   {
/* 272 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public AliasDef create_alias(String id, String name, String version, IDLType original_type)
/*     */   {
/* 278 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public InterfaceDef create_interface(String id, String name, String version, InterfaceDef[] base_interfaces, boolean is_abstract)
/*     */   {
/* 285 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public ValueDef create_value(String id, String name, String version, boolean is_custom, boolean is_abstract, ValueDef base_value, boolean is_truncatable, ValueDef[] abstract_base_values, InterfaceDef[] supported_interfaces, Initializer[] initializers)
/*     */   {
/* 295 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public ValueBoxDef create_value_box(String id, String name, String version, IDLType original_type_def)
/*     */   {
/* 301 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public ExceptionDef create_exception(String id, String name, String version, StructMember[] members)
/*     */   {
/* 307 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public NativeDef create_native(String id, String name, String version)
/*     */   {
/* 312 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public DefinitionKind def_kind()
/*     */   {
/* 320 */     throw new RuntimeException("Should not be called.");
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 325 */     throw new RuntimeException("Should not be called.");
/*     */   }
/*     */ 
/*     */   void add(String name, LocalContained contained)
/*     */     throws IRConstructionException
/*     */   {
/* 334 */     if (contained.getRepository() != this.delegateFor.getRepository())
/* 335 */       throw new IRConstructionException("Wrong repository");
/* 336 */     if (this.contMap.get(name) != null)
/* 337 */       throw new IRConstructionException("Duplicate name: " + name);
/* 338 */     this.cont.add(contained);
/* 339 */     this.contMap.put(name, contained);
/* 340 */     logger.debug("ContainerDelegateImpl.add() added \"" + name + "\".");
/*     */   }
/*     */ 
/*     */   void allDone()
/*     */     throws IRConstructionException
/*     */   {
/* 349 */     logger.debug("ContainerDelegateImpl.allDone() entered ");
/* 350 */     for (int i = 0; i < this.cont.size(); i++) {
/* 351 */       LocalContained item = (LocalContained)this.cont.get(i);
/*     */ 
/* 353 */       logger.debug("Container[" + item.id() + "].allDone() calling [" + item.id() + "].allDone()");
/*     */ 
/* 355 */       item.allDone();
/*     */     }
/* 357 */     logger.debug("ContainerDelegateImpl.allDone() done ");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.ir.ContainerImplDelegate
 * JD-Core Version:    0.6.0
 */