/*     */ package org.jboss.iiop.rmi.ir;
/*     */ 
/*     */ import B;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.omg.CORBA.ArrayDef;
/*     */ import org.omg.CORBA.BAD_INV_ORDER;
/*     */ import org.omg.CORBA.Contained;
/*     */ import org.omg.CORBA.ContainedHelper;
/*     */ import org.omg.CORBA.DefinitionKind;
/*     */ import org.omg.CORBA.FixedDef;
/*     */ import org.omg.CORBA.IDLType;
/*     */ import org.omg.CORBA.IRObject;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CORBA.PrimitiveDef;
/*     */ import org.omg.CORBA.PrimitiveKind;
/*     */ import org.omg.CORBA.Repository;
/*     */ import org.omg.CORBA.RepositoryHelper;
/*     */ import org.omg.CORBA.RepositoryOperations;
/*     */ import org.omg.CORBA.RepositoryPOATie;
/*     */ import org.omg.CORBA.SequenceDef;
/*     */ import org.omg.CORBA.StringDef;
/*     */ import org.omg.CORBA.TypeCode;
/*     */ import org.omg.CORBA.UserException;
/*     */ import org.omg.CORBA.WstringDef;
/*     */ import org.omg.PortableServer.POA;
/*     */ 
/*     */ class RepositoryImpl extends ContainerImpl
/*     */   implements RepositoryOperations, LocalContainer
/*     */ {
/*  64 */   private static final Logger logger = Logger.getLogger(RepositoryImpl.class);
/*     */ 
/* 186 */   ORB orb = null;
/*     */ 
/* 191 */   POA poa = null;
/*     */ 
/* 196 */   private byte[] oid = null;
/*     */ 
/* 201 */   private String oidPrefix = null;
/*     */ 
/* 206 */   private String anonOidPrefix = null;
/*     */ 
/* 211 */   Map sequenceMap = new HashMap();
/*     */ 
/* 216 */   Map sequenceIdMap = new HashMap();
/*     */ 
/* 297 */   private Repository ref = null;
/*     */ 
/* 302 */   private long nextPOAId = 1L;
/*     */ 
/*     */   public RepositoryImpl(ORB orb, POA poa, String name)
/*     */   {
/*  71 */     super(DefinitionKind.dk_Repository, null);
/*     */ 
/*  73 */     this.orb = orb;
/*  74 */     this.poa = poa;
/*     */     try {
/*  76 */       this.oid = name.getBytes("UTF-8");
/*     */     } catch (UnsupportedEncodingException ex) {
/*  78 */       throw new RuntimeException("UTF-8 encoding not supported.");
/*     */     }
/*  80 */     this.oidPrefix = (name + ":");
/*  81 */     this.anonOidPrefix = (this.oidPrefix + "anon");
/*     */ 
/*  83 */     this.repository = this;
/*     */   }
/*     */ 
/*     */   public IRObject getReference()
/*     */   {
/*  92 */     if (this.ref == null) {
/*  93 */       this.ref = RepositoryHelper.narrow(servantToReference(new RepositoryPOATie(this)));
/*     */     }
/*     */ 
/*  96 */     return this.ref;
/*     */   }
/*     */ 
/*     */   public void allDone()
/*     */     throws IRConstructionException
/*     */   {
/* 102 */     super.allDone();
/*     */ 
/* 105 */     Iterator iter = this.sequenceMap.values().iterator();
/* 106 */     while (iter.hasNext())
/* 107 */       ((SequenceDefImpl)iter.next()).allDone();
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/* 113 */     for (long i = 1L; i < this.nextPOAId; i += 1L) {
/*     */       try {
/* 115 */         getPOA().deactivate_object(getAnonymousObjectId(i));
/*     */       } catch (UserException ex) {
/* 117 */         logger.warn("Could not deactivate anonymous IR object", ex);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 122 */     super.shutdown();
/*     */   }
/*     */ 
/*     */   public Contained lookup_id(String search_id)
/*     */   {
/* 129 */     logger.debug("RepositoryImpl.lookup_id(\"" + search_id + "\") entered.");
/* 130 */     LocalContained c = _lookup_id(search_id);
/*     */ 
/* 132 */     if (c == null) {
/* 133 */       return null;
/*     */     }
/* 135 */     return ContainedHelper.narrow(c.getReference());
/*     */   }
/*     */ 
/*     */   public TypeCode get_canonical_typecode(TypeCode tc)
/*     */   {
/* 140 */     logger.debug("RepositoryImpl.get_canonical_typecode() entered.");
/*     */ 
/* 142 */     return null;
/*     */   }
/*     */ 
/*     */   public PrimitiveDef get_primitive(PrimitiveKind kind)
/*     */   {
/* 147 */     logger.debug("RepositoryImpl.get_primitive() entered.");
/*     */ 
/* 149 */     return null;
/*     */   }
/*     */ 
/*     */   public StringDef create_string(int bound)
/*     */   {
/* 154 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public WstringDef create_wstring(int bound)
/*     */   {
/* 159 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public SequenceDef create_sequence(int bound, IDLType element_type)
/*     */   {
/* 164 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public ArrayDef create_array(int length, IDLType element_type)
/*     */   {
/* 169 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public FixedDef create_fixed(short digits, short scale)
/*     */   {
/* 174 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   LocalContained _lookup_id(String search_id)
/*     */   {
/* 221 */     logger.debug("RepositoryImpl._lookup_id(\"" + search_id + "\") entered.");
/*     */ 
/* 224 */     if (search_id.startsWith("RMI:[")) {
/* 225 */       return (ValueBoxDefImpl)this.sequenceIdMap.get(search_id);
/*     */     }
/*     */ 
/* 228 */     String name = scopedName(search_id);
/* 229 */     logger.debug("RepositoryImpl._lookup_id(): scopedName=\"" + scopedName(search_id) + "\"");
/*     */ 
/* 234 */     LocalContained ret = name == null ? null : _lookup(name);
/* 235 */     logger.debug("RepositoryImpl._lookup_id(): returning " + (ret == null ? "null" : "NOT null"));
/*     */ 
/* 237 */     return ret;
/*     */   }
/*     */ 
/*     */   SequenceDefImpl getSequenceImpl(TypeCode typeCode)
/*     */   {
/* 242 */     return (SequenceDefImpl)this.sequenceMap.get(typeCode);
/*     */   }
/*     */ 
/*     */   void putSequenceImpl(String id, TypeCode typeCode, SequenceDefImpl sequence, ValueBoxDefImpl valueBox)
/*     */   {
/* 248 */     this.sequenceIdMap.put(id, valueBox);
/* 249 */     this.sequenceMap.put(typeCode, sequence);
/*     */   }
/*     */ 
/*     */   String getObjectIdPrefix()
/*     */   {
/* 254 */     return this.oidPrefix;
/*     */   }
/*     */ 
/*     */   protected byte[] getObjectId()
/*     */   {
/* 264 */     return (byte[])(byte[])this.oid.clone();
/*     */   }
/*     */ 
/*     */   protected byte[] getAnonymousObjectId(long n)
/*     */   {
/* 272 */     String s = this.anonOidPrefix + Long.toString(n);
/*     */     try {
/* 274 */       return s.getBytes("UTF-8"); } catch (UnsupportedEncodingException ex) {
/*     */     }
/* 276 */     throw new RuntimeException("UTF-8 encoding not supported.");
/*     */   }
/*     */ 
/*     */   protected byte[] getNextObjectId()
/*     */   {
/* 288 */     return getAnonymousObjectId(this.nextPOAId++);
/*     */   }
/*     */ 
/*     */   private String scopedName(String id)
/*     */   {
/* 310 */     if (id == null) {
/* 311 */       return null;
/*     */     }
/* 313 */     if (id.startsWith("IDL:"))
/*     */     {
/* 317 */       if (("IDL:omg.org/CORBA/Object:1.0".equals(id)) || ("IDL:omg.org/CORBA/ValueBase:1.0".equals(id)))
/*     */       {
/* 319 */         return null;
/*     */       }
/*     */ 
/* 322 */       int idx2 = id.indexOf(':', 4);
/* 323 */       if (idx2 == -1)
/* 324 */         return null;
/* 325 */       String base = id.substring(4, id.indexOf(':', 4));
/*     */ 
/* 328 */       if (base.startsWith("omg.org"))
/* 329 */         base = "org/omg" + base.substring(7);
/* 330 */       if (base.startsWith("w3c.org")) {
/* 331 */         base = "org/w3c" + base.substring(7);
/*     */       }
/*     */ 
/* 334 */       StringBuffer b = new StringBuffer();
/* 335 */       for (int i = 0; i < base.length(); i++) {
/* 336 */         char c = base.charAt(i);
/*     */ 
/* 338 */         if (c != '/')
/* 339 */           b.append(c);
/*     */         else {
/* 341 */           b.append("::");
/*     */         }
/*     */       }
/* 344 */       return b.toString();
/* 345 */     }if (id.startsWith("RMI:"))
/*     */     {
/* 349 */       int idx2 = id.indexOf(':', 4);
/* 350 */       if (idx2 == -1)
/* 351 */         return null;
/* 352 */       String base = id.substring(4, id.indexOf(':', 4));
/*     */ 
/* 355 */       StringBuffer b = new StringBuffer();
/* 356 */       for (int i = 0; i < base.length(); i++) {
/* 357 */         char c = base.charAt(i);
/*     */ 
/* 359 */         if (c != '.')
/* 360 */           b.append(c);
/*     */         else {
/* 362 */           b.append("::");
/*     */         }
/*     */       }
/* 365 */       return b.toString();
/*     */     }
/* 367 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.ir.RepositoryImpl
 * JD-Core Version:    0.6.0
 */