/*    */ package org.jboss.injection;
/*    */ 
/*    */ import java.lang.reflect.Field;
/*    */ import java.util.ArrayList;
/*    */ import javax.management.MBeanServer;
/*    */ import javax.management.MBeanServerFactory;
/*    */ import javax.management.ObjectName;
/*    */ import org.jboss.ejb3.BeanContext;
/*    */ import org.jboss.mx.util.MBeanProxyExt;
/*    */ 
/*    */ public class DependsFieldInjector
/*    */   implements Injector
/*    */ {
/*    */   Field field;
/*    */   ObjectName on;
/*    */ 
/*    */   public DependsFieldInjector(Field field, ObjectName on)
/*    */   {
/* 42 */     this.field = field;
/* 43 */     this.on = on;
/* 44 */     field.setAccessible(true);
/*    */   }
/*    */ 
/*    */   public void inject(BeanContext ctx)
/*    */   {
/* 49 */     Object instance = ctx.getInstance();
/* 50 */     inject(instance);
/*    */   }
/*    */ 
/*    */   public void inject(Object instance)
/*    */   {
/* 55 */     Class clazz = this.field.getType();
/* 56 */     Object value = null;
/*    */ 
/* 58 */     if (clazz == ObjectName.class)
/*    */     {
/* 60 */       value = this.on;
/*    */     }
/*    */     else
/*    */     {
/* 64 */       MBeanServer server = (MBeanServer)MBeanServerFactory.findMBeanServer(null).get(0);
/* 65 */       value = MBeanProxyExt.create(clazz, this.on, server);
/*    */     }
/*    */ 
/*    */     try
/*    */     {
/* 70 */       this.field.set(instance, value);
/*    */     }
/*    */     catch (IllegalAccessException e)
/*    */     {
/* 74 */       throw new RuntimeException(e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public Class getInjectionClass()
/*    */   {
/* 80 */     return this.field.getType();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.DependsFieldInjector
 * JD-Core Version:    0.6.0
 */