/*    */ package org.jboss.injection;
/*    */ 
/*    */ import java.lang.reflect.AccessibleObject;
/*    */ import java.lang.reflect.Field;
/*    */ import java.lang.reflect.Method;
/*    */ import java.util.Map;
/*    */ import javax.ejb.EJB;
/*    */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*    */ 
/*    */ public class EJBInjectionHandler<X extends RemoteEnvironment> extends AbstractHandler<X>
/*    */ {
/*    */   protected String getEncName(EJB ref, Field field)
/*    */   {
/* 43 */     String encName = ref.name();
/* 44 */     if ((encName == null) || (encName.equals("")))
/*    */     {
/* 46 */       encName = InjectionUtil.getEncName(field);
/*    */     }
/*    */     else
/*    */     {
/* 50 */       encName = "env/" + encName;
/*    */     }
/* 52 */     return encName;
/*    */   }
/*    */ 
/*    */   protected String getEncName(EJB ref, Method method)
/*    */   {
/* 57 */     String encName = ref.name();
/* 58 */     if ((encName == null) || (encName.equals("")))
/*    */     {
/* 60 */       encName = InjectionUtil.getEncName(method);
/*    */     }
/*    */     else
/*    */     {
/* 64 */       encName = "env/" + encName;
/*    */     }
/* 66 */     return encName;
/*    */   }
/*    */ 
/*    */   public void handleClassAnnotations(Class<?> clazz, InjectionContainer container)
/*    */   {
/*    */   }
/*    */ 
/*    */   public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*    */   {
/* 76 */     EJB ref = (EJB)container.getAnnotation(EJB.class, field);
/* 77 */     if (ref == null) {
/* 78 */       return;
/*    */     }
/* 80 */     String encName = getEncName(ref, field);
/* 81 */     injectors.put(field, new JndiFieldInjector(field, encName, container.getEnc()));
/*    */   }
/*    */ 
/*    */   public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*    */   {
/* 86 */     EJB ref = (EJB)container.getAnnotation(EJB.class, method);
/* 87 */     if (ref == null) {
/* 88 */       return;
/*    */     }
/* 90 */     String encName = getEncName(ref, method);
/* 91 */     injectors.put(method, new JndiMethodInjector(method, encName, container.getEnc()));
/*    */   }
/*    */ 
/*    */   public void loadXml(X xml, InjectionContainer container)
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.EJBInjectionHandler
 * JD-Core Version:    0.6.0
 */