/*    */ package org.jboss.injection;
/*    */ 
/*    */ import java.lang.reflect.InvocationTargetException;
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.ejb3.BeanContext;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class EntityManagerFactoryMethodInjector
/*    */   implements Injector, PojoInjector
/*    */ {
/* 37 */   private static final Logger log = Logger.getLogger(EntityManagerFactoryMethodInjector.class);
/*    */   private Method setMethod;
/*    */   private Object factory;
/*    */ 
/*    */   public EntityManagerFactoryMethodInjector(Method setMethod, Object factory)
/*    */   {
/* 43 */     this.setMethod = setMethod;
/* 44 */     setMethod.setAccessible(true);
/* 45 */     this.factory = factory;
/*    */   }
/*    */ 
/*    */   public void inject(BeanContext ctx)
/*    */   {
/* 50 */     inject(ctx, ctx.getInstance());
/*    */   }
/*    */ 
/*    */   public void inject(BeanContext ctx, Object instance)
/*    */   {
/* 55 */     inject(instance);
/*    */   }
/*    */ 
/*    */   public void inject(Object instance)
/*    */   {
/*    */     try
/*    */     {
/* 62 */       Object[] args = { this.factory };
/* 63 */       this.setMethod.invoke(instance, args);
/*    */     }
/*    */     catch (IllegalAccessException e)
/*    */     {
/* 67 */       throw new RuntimeException(e);
/*    */     }
/*    */     catch (IllegalArgumentException e)
/*    */     {
/* 71 */       throw new RuntimeException("Failed in setting EntityManager on setter method: " + this.setMethod.toString());
/*    */     }
/*    */     catch (InvocationTargetException e)
/*    */     {
/* 75 */       throw new RuntimeException(e.getCause());
/*    */     }
/*    */   }
/*    */ 
/*    */   public Class getInjectionClass()
/*    */   {
/* 81 */     return this.setMethod.getParameterTypes()[0];
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.EntityManagerFactoryMethodInjector
 * JD-Core Version:    0.6.0
 */