/*     */ package org.jboss.injection;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.Util;
/*     */ 
/*     */ public class EnvEntryEncInjector
/*     */   implements EncInjector
/*     */ {
/*  35 */   private static final Logger log = Logger.getLogger(EnvEntryEncInjector.class);
/*     */   private String name;
/*     */   private String entryType;
/*     */   private String value;
/*     */ 
/*     */   public EnvEntryEncInjector(String encName, String entryType, String value)
/*     */   {
/*  44 */     this.name = encName;
/*  45 */     this.entryType = entryType;
/*  46 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public void inject(InjectionContainer container)
/*     */   {
/*     */     try
/*     */     {
/*  53 */       Util.rebind(container.getEnc(), this.name, getEnvEntryValue());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  59 */       throw new RuntimeException("Invalid <env-entry> name: " + this.name, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Object getEnvEntryValue()
/*     */     throws ClassNotFoundException
/*     */   {
/*  66 */     Class type = Thread.currentThread().getContextClassLoader().loadClass(this.entryType);
/*  67 */     if (type == String.class)
/*     */     {
/*  69 */       return this.value;
/*     */     }
/*  71 */     if (type == Integer.class)
/*     */     {
/*  73 */       return new Integer(this.value);
/*     */     }
/*  75 */     if (type == Long.class)
/*     */     {
/*  77 */       return new Long(this.value);
/*     */     }
/*  79 */     if (type == Double.class)
/*     */     {
/*  81 */       return new Double(this.value);
/*     */     }
/*  83 */     if (type == Float.class)
/*     */     {
/*  85 */       return new Float(this.value);
/*     */     }
/*  87 */     if (type == Byte.class)
/*     */     {
/*  89 */       return new Byte(this.value);
/*     */     }
/*  91 */     if (type == Character.class)
/*     */     {
/*  93 */       String input = this.value;
/*  94 */       if ((input == null) || (input.length() == 0))
/*     */       {
/*  96 */         return new Character('\000');
/*     */       }
/*     */ 
/* 100 */       if (input.length() > 1)
/*     */       {
/* 102 */         log.warn("Warning character env-entry is too long: binding=" + this.name + " value=" + input);
/*     */       }
/* 104 */       return new Character(input.charAt(0));
/*     */     }
/*     */ 
/* 107 */     if (type == Short.class)
/*     */     {
/* 109 */       return new Short(this.value);
/*     */     }
/* 111 */     if (type == Boolean.class)
/*     */     {
/* 113 */       return new Boolean(this.value);
/*     */     }
/*     */ 
/* 117 */     return this.value;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.EnvEntryEncInjector
 * JD-Core Version:    0.6.0
 */