/*     */ package org.jboss.injection;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.injection.lang.reflect.BeanProperty;
/*     */ import org.jboss.injection.lang.reflect.BeanPropertyFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*     */ import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
/*     */ 
/*     */ public class InjectionUtil
/*     */ {
/*  54 */   private static final Logger log = Logger.getLogger(InjectionUtil.class);
/*     */ 
/*     */   public static void collapseXmlMethodInjectors(Set<String> visitedMethods, Class clazz, Map<String, Map<AccessibleObject, Injector>> xmlDefinedInjectors, Map<AccessibleObject, Injector> classInjectors)
/*     */   {
/*  69 */     if ((clazz == null) || (clazz.equals(Object.class)))
/*     */     {
/*  71 */       return;
/*     */     }
/*  73 */     Map xmlInjectors = (Map)xmlDefinedInjectors.get(clazz.getName());
/*  74 */     if (xmlInjectors != null)
/*     */     {
/*  76 */       Method[] methods = clazz.getDeclaredMethods();
/*  77 */       for (Method method : methods)
/*     */       {
/*  79 */         if (method.getParameterTypes().length != 1)
/*     */           continue;
/*  81 */         if (Modifier.isPrivate(method.getModifiers()))
/*     */           continue;
/*  83 */         if (visitedMethods.contains(method.getName()))
/*     */         {
/*  85 */           xmlInjectors.remove(method);
/*     */         }
/*     */         else {
/*  88 */           visitedMethods.add(method.getName());
/*     */         }
/*     */       }
/*  91 */       classInjectors.putAll(xmlInjectors);
/*     */     }
/*     */ 
/*  94 */     collapseXmlMethodInjectors(visitedMethods, clazz.getSuperclass(), xmlDefinedInjectors, classInjectors);
/*     */   }
/*     */ 
/*     */   public static void createInjectors(List<Injector> injectors, ClassLoader classLoader, InjectorFactory<?> factory, Collection<ResourceInjectionTargetMetaData> injectionTargets)
/*     */   {
/* 107 */     for (ResourceInjectionTargetMetaData injectionTarget : injectionTargets)
/*     */     {
/* 109 */       AccessibleObject ao = findInjectionTarget(classLoader, injectionTarget);
/* 110 */       BeanProperty property = BeanPropertyFactory.create(ao);
/* 111 */       injectors.add(factory.create(property));
/*     */     }
/*     */   }
/*     */ 
/*     */   public static <X extends RemoteEnvironment> void processMethodAnnotations(InjectionContainer container, Collection<InjectionHandler<X>> handlers, Set<String> visitedMethods, Class<?> clazz, Map<AccessibleObject, Injector> classInjectors)
/*     */   {
/* 117 */     if ((clazz == null) || (clazz.equals(Object.class)))
/*     */     {
/* 119 */       return;
/*     */     }
/* 121 */     Method[] methods = clazz.getDeclaredMethods();
/*     */     Method method;
/* 122 */     for (method : methods)
/*     */     {
/* 124 */       if (method.getParameterTypes().length != 1)
/*     */         continue;
/* 126 */       if (!Modifier.isPrivate(method.getModifiers()))
/*     */       {
/* 128 */         if (visitedMethods.contains(method.getName()))
/*     */         {
/*     */           continue;
/*     */         }
/* 132 */         visitedMethods.add(method.getName());
/*     */       }
/*     */ 
/* 135 */       if (handlers == null)
/*     */         continue;
/* 137 */       for (InjectionHandler handler : handlers)
/*     */       {
/* 139 */         handler.handleMethodAnnotations(method, container, classInjectors);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 144 */     processMethodAnnotations(container, handlers, visitedMethods, clazz.getSuperclass(), classInjectors);
/*     */   }
/*     */ 
/*     */   public static <X extends RemoteEnvironment> void processFieldAnnotations(InjectionContainer container, Collection<InjectionHandler<X>> handlers, Class<?> clazz, Map<AccessibleObject, Injector> classInjectors)
/*     */   {
/* 149 */     if ((clazz == null) || (clazz.equals(Object.class)))
/*     */     {
/* 151 */       return;
/*     */     }
/*     */ 
/* 154 */     if (handlers != null)
/*     */     {
/* 156 */       Field[] fields = clazz.getDeclaredFields();
/*     */       Field field;
/* 157 */       for (field : fields)
/*     */       {
/* 159 */         log.trace("process field annotation for " + field.toGenericString());
/* 160 */         for (InjectionHandler handler : handlers)
/*     */         {
/* 162 */           handler.handleFieldAnnotations(field, container, classInjectors);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 168 */     processFieldAnnotations(container, handlers, clazz.getSuperclass(), classInjectors);
/*     */   }
/*     */ 
/*     */   public static <X extends RemoteEnvironment> void processClassAnnotations(InjectionContainer container, Collection<InjectionHandler<X>> handlers, Class<?> clazz)
/*     */   {
/* 173 */     if ((clazz == null) || (clazz.equals(Object.class)))
/*     */     {
/* 175 */       return;
/*     */     }
/*     */ 
/* 178 */     if (handlers != null)
/*     */     {
/* 180 */       for (InjectionHandler handler : handlers)
/*     */       {
/* 182 */         handler.handleClassAnnotations(clazz, container);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 187 */     processClassAnnotations(container, handlers, clazz.getSuperclass());
/*     */   }
/*     */ 
/*     */   public static <X extends RemoteEnvironment> Map<AccessibleObject, Injector> processAnnotations(InjectionContainer container, Collection<InjectionHandler<X>> handlers, Class<?> clazz)
/*     */   {
/* 192 */     Map classInjectors = new HashMap();
/* 193 */     HashSet visitedMethods = new HashSet();
/* 194 */     collapseXmlMethodInjectors(visitedMethods, clazz, container.getEncInjections(), classInjectors);
/*     */ 
/* 196 */     processClassAnnotations(container, handlers, clazz);
/* 197 */     visitedMethods = new HashSet();
/* 198 */     processMethodAnnotations(container, handlers, visitedMethods, clazz, classInjectors);
/* 199 */     processFieldAnnotations(container, handlers, clazz, classInjectors);
/* 200 */     return classInjectors;
/*     */   }
/*     */ 
/*     */   public static AccessibleObject findInjectionTarget(ClassLoader loader, ResourceInjectionTargetMetaData target)
/*     */   {
/* 205 */     Class clazz = null;
/*     */     try
/*     */     {
/* 208 */       clazz = loader.loadClass(target.getInjectionTargetClass());
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 212 */       throw new RuntimeException("<injection-target> class: " + target.getInjectionTargetClass() + " was not found in deployment");
/*     */     }
/*     */ 
/* 215 */     for (Field field : clazz.getDeclaredFields())
/*     */     {
/* 217 */       if (target.getInjectionTargetName().equals(field.getName())) return field;
/*     */     }
/*     */ 
/* 220 */     for (Method method : clazz.getDeclaredMethods())
/*     */     {
/* 222 */       if (method.getName().equals(target.getInjectionTargetName())) return method;
/*     */     }
/*     */ 
/* 225 */     throw new RuntimeException("<injection-target> could not be found: " + target.getInjectionTargetClass() + "." + target.getInjectionTargetName());
/*     */   }
/*     */ 
/*     */   public static String getEncName(Class type)
/*     */   {
/* 231 */     return "env/" + type.getName();
/*     */   }
/*     */ 
/*     */   public static String getEncName(Method method)
/*     */   {
/* 236 */     String encName = method.getName().substring(3);
/* 237 */     if (encName.length() > 1)
/*     */     {
/* 239 */       encName = encName.substring(0, 1).toLowerCase() + encName.substring(1);
/*     */     }
/*     */     else
/*     */     {
/* 243 */       encName = encName.toLowerCase();
/*     */     }
/*     */ 
/* 246 */     encName = getEncName(method.getDeclaringClass()) + "/" + encName;
/* 247 */     return encName;
/*     */   }
/*     */ 
/*     */   public static String getEncName(Field field)
/*     */   {
/* 252 */     return getEncName(field.getDeclaringClass()) + "/" + field.getName();
/*     */   }
/*     */ 
/*     */   public static Object getAnnotation(Class<? extends Annotation> annotation, EJBContainer container, Class<?> annotatedClass, boolean isContainer)
/*     */   {
/* 257 */     if (isContainer)
/*     */     {
/* 259 */       return container.resolveAnnotation(annotation);
/*     */     }
/*     */ 
/* 263 */     return annotatedClass.getAnnotation(annotation);
/*     */   }
/*     */ 
/*     */   public static Object getAnnotation(Class<? extends Annotation> annotation, EJBContainer container, Method method, boolean isContainer)
/*     */   {
/* 269 */     if (isContainer)
/*     */     {
/* 271 */       return container.resolveAnnotation(method, annotation);
/*     */     }
/*     */ 
/* 275 */     return method.getAnnotation(annotation);
/*     */   }
/*     */ 
/*     */   public static Object getAnnotation(Class<? extends Annotation> annotation, EJBContainer container, Field field, boolean isContainer)
/*     */   {
/* 281 */     if (isContainer)
/*     */     {
/* 283 */       return container.resolveAnnotation(field, annotation);
/*     */     }
/*     */ 
/* 287 */     return field.getAnnotation(annotation);
/*     */   }
/*     */ 
/*     */   public static Class<?> injectionTarget(String encName, ResourceInjectionMetaData ref, InjectionContainer container, Map<String, Map<AccessibleObject, Injector>> classInjectors)
/*     */   {
/* 293 */     Class injectionType = null;
/*     */ 
/* 295 */     if (ref.getInjectionTargets() == null) {
/* 296 */       return injectionType;
/*     */     }
/* 298 */     for (ResourceInjectionTargetMetaData injectionTarget : ref.getInjectionTargets())
/*     */     {
/* 301 */       AccessibleObject ao = findInjectionTarget(container.getClassloader(), injectionTarget);
/* 302 */       Map injectors = (Map)classInjectors.get(injectionTarget.getInjectionTargetClass());
/* 303 */       if (injectors == null)
/*     */       {
/* 305 */         injectors = new HashMap();
/* 306 */         classInjectors.put(injectionTarget.getInjectionTargetClass(), injectors);
/*     */       }
/*     */       Class type;
/* 309 */       if ((ao instanceof Field))
/*     */       {
/* 311 */         Class type = ((Field)ao).getType();
/* 312 */         injectors.put(ao, new JndiFieldInjector((Field)ao, encName, container.getEnc()));
/*     */       }
/*     */       else
/*     */       {
/* 316 */         type = ((Method)ao).getParameterTypes()[0];
/* 317 */         injectors.put(ao, new JndiMethodInjector((Method)ao, encName, container.getEnc()));
/*     */       }
/* 319 */       if (injectionType == null) {
/* 320 */         injectionType = type;
/*     */       }
/* 323 */       else if (!injectionType.equals(type)) {
/* 324 */         throw new IllegalStateException("Found multiple injection targets with different types");
/*     */       }
/*     */     }
/*     */ 
/* 328 */     return injectionType;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.InjectionUtil
 * JD-Core Version:    0.6.0
 */