/*    */ package org.jboss.injection;
/*    */ 
/*    */ import java.lang.reflect.Proxy;
/*    */ import java.util.List;
/*    */ import javax.naming.NameNotFoundException;
/*    */ import javax.naming.NamingException;
/*    */ import javax.persistence.EntityManager;
/*    */ import javax.persistence.PersistenceContextType;
/*    */ import org.hibernate.engine.SessionImplementor;
/*    */ import org.hibernate.event.EventSource;
/*    */ import org.hibernate.jdbc.JDBCContext.Context;
/*    */ import org.jboss.ejb3.entity.ExtendedEntityManager;
/*    */ import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
/*    */ import org.jboss.ejb3.entity.TransactionScopedEntityManager;
/*    */ import org.jboss.ejb3.entity.hibernate.ExtendedSessionInvocationHandler;
/*    */ import org.jboss.ejb3.entity.hibernate.TransactionScopedSessionInvocationHandler;
/*    */ import org.jboss.ejb3.stateful.StatefulContainer;
/*    */ import org.jboss.naming.Util;
/*    */ 
/*    */ public class PcEncInjector
/*    */   implements EncInjector
/*    */ {
/* 48 */   private static final Class[] SESS_PROXY_INTERFACES = { org.hibernate.classic.Session.class, SessionImplementor.class, JDBCContext.Context.class, EventSource.class };
/*    */   private String encName;
/*    */   private String unitName;
/*    */   private PersistenceContextType type;
/*    */   private Class injectionType;
/*    */   private String error;
/*    */ 
/*    */   public PcEncInjector(String encName, String unitName, PersistenceContextType type, Class injectionType, String error)
/*    */   {
/* 63 */     this.encName = encName;
/* 64 */     this.unitName = unitName;
/* 65 */     this.type = type;
/* 66 */     this.injectionType = injectionType;
/* 67 */     this.error = error;
/*    */   }
/*    */ 
/*    */   public void inject(InjectionContainer container)
/*    */   {
/* 72 */     String error1 = this.error;
/* 73 */     ManagedEntityManagerFactory factory = null;
/*    */     try
/*    */     {
/* 76 */       factory = PersistenceUnitHandler.getManagedEntityManagerFactory(container, this.unitName);
/*    */     }
/*    */     catch (NameNotFoundException e)
/*    */     {
/* 81 */       error1 = error1 + " " + e.getMessage();
/*    */     }
/* 83 */     if (factory == null)
/*    */     {
/* 85 */       throw new RuntimeException(error1);
/*    */     }
/* 87 */     if (this.type == PersistenceContextType.EXTENDED)
/*    */     {
/* 89 */       if (!(container instanceof StatefulContainer))
/* 90 */         throw new RuntimeException("It is illegal to inject an EXTENDED PC into something other than a SFSB");
/* 91 */       container.getInjectors().add(0, new ExtendedPersistenceContextInjector(factory));
/*    */       Object extendedPc;
/*    */       Object extendedPc;
/* 93 */       if ((this.injectionType == null) || (this.injectionType.getName().equals(EntityManager.class.getName())))
/*    */       {
/* 96 */         extendedPc = new ExtendedEntityManager(factory.getKernelName());
/*    */       }
/*    */       else
/*    */       {
/* 100 */         ExtendedSessionInvocationHandler handler = new ExtendedSessionInvocationHandler(factory.getKernelName());
/* 101 */         extendedPc = Proxy.newProxyInstance(org.hibernate.Session.class.getClassLoader(), SESS_PROXY_INTERFACES, handler);
/*    */       }
/*    */ 
/*    */       try
/*    */       {
/* 109 */         Util.rebind(container.getEnc(), this.encName, extendedPc);
/*    */       }
/*    */       catch (NamingException e)
/*    */       {
/* 113 */         throw new RuntimeException(error1, e);
/*    */       }
/*    */     }
/*    */     else
/*    */     {
/*    */       Object entityManager;
/*    */       Object entityManager;
/* 119 */       if ((this.injectionType == null) || (this.injectionType.getName().equals(EntityManager.class.getName())))
/*    */       {
/* 122 */         entityManager = new TransactionScopedEntityManager(factory);
/*    */       }
/*    */       else
/*    */       {
/* 126 */         TransactionScopedSessionInvocationHandler handler = new TransactionScopedSessionInvocationHandler(factory);
/* 127 */         entityManager = Proxy.newProxyInstance(org.hibernate.Session.class.getClassLoader(), SESS_PROXY_INTERFACES, handler);
/*    */       }
/*    */ 
/*    */       try
/*    */       {
/* 135 */         Util.rebind(container.getEnc(), this.encName, entityManager);
/*    */       }
/*    */       catch (NamingException e)
/*    */       {
/* 139 */         throw new RuntimeException(error1, e);
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.PcEncInjector
 * JD-Core Version:    0.6.0
 */