/*    */ package org.jboss.injection;
/*    */ 
/*    */ import javax.naming.NameNotFoundException;
/*    */ import org.jboss.naming.Util;
/*    */ 
/*    */ public class PuEncInjector
/*    */   implements EncInjector
/*    */ {
/*    */   private String encName;
/*    */   private Class injectionType;
/*    */   private String unitName;
/*    */   private String error;
/*    */ 
/*    */   public PuEncInjector(String encName, Class injectionType, String unitName, String error)
/*    */   {
/* 43 */     this.encName = encName;
/* 44 */     this.injectionType = injectionType;
/* 45 */     this.error = error;
/* 46 */     this.unitName = unitName;
/*    */   }
/*    */ 
/*    */   public void inject(InjectionContainer container)
/*    */   {
/* 51 */     Object factory = null;
/*    */     try
/*    */     {
/* 54 */       factory = PersistenceUnitHandler.getFactory(this.injectionType, this.unitName, container);
/*    */     }
/*    */     catch (NameNotFoundException e)
/*    */     {
/* 58 */       throw new RuntimeException(e);
/*    */     }
/* 60 */     if (factory == null)
/*    */     {
/* 62 */       throw new RuntimeException("Failed to locate " + this.error + " of unit name: " + this.unitName + " for " + container.getIdentifier());
/*    */     }
/*    */ 
/*    */     try
/*    */     {
/* 67 */       Util.rebind(container.getEnc(), this.encName, factory);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 71 */       throw new RuntimeException("Failed to bind " + this.error + " of unit name: " + this.unitName + " ref-name" + this.encName + " for container " + container.getIdentifier(), e);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.PuEncInjector
 * JD-Core Version:    0.6.0
 */