/*    */ package org.jboss.injection.lang.reflect;
/*    */ 
/*    */ import java.lang.reflect.Field;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class FieldBeanProperty extends AbstractAccessibleObjectBeanProperty<Field>
/*    */ {
/* 36 */   private static final Logger log = Logger.getLogger(FieldBeanProperty.class);
/*    */ 
/*    */   public FieldBeanProperty(Field field)
/*    */   {
/* 43 */     super(field);
/*    */   }
/*    */ 
/*    */   public Class<?> getDeclaringClass()
/*    */   {
/* 48 */     return getField().getDeclaringClass();
/*    */   }
/*    */ 
/*    */   protected Field getField()
/*    */   {
/* 53 */     return (Field)getAccessibleObject();
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 58 */     return getField().getName();
/*    */   }
/*    */ 
/*    */   public Class<?> getType()
/*    */   {
/* 63 */     return getField().getType();
/*    */   }
/*    */ 
/*    */   public void set(Object instance, Object value)
/*    */   {
/* 71 */     Field field = getField();
/*    */     try
/*    */     {
/* 74 */       field.set(instance, value);
/*    */     }
/*    */     catch (IllegalAccessException e)
/*    */     {
/* 78 */       log.fatal("illegal access on field " + field, e);
/* 79 */       throw new RuntimeException(e);
/*    */     }
/*    */     catch (IllegalArgumentException e)
/*    */     {
/* 83 */       String msg = "failed to set value " + value + " on field " + field;
/* 84 */       log.error(msg, e);
/* 85 */       throw new IllegalArgumentException(msg);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.lang.reflect.FieldBeanProperty
 * JD-Core Version:    0.6.0
 */