/*    */ package org.jboss.injection.lang.reflect;
/*    */ 
/*    */ import java.lang.reflect.InvocationTargetException;
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class MethodBeanProperty extends AbstractAccessibleObjectBeanProperty<Method>
/*    */ {
/* 37 */   private final Logger log = Logger.getLogger(MethodBeanProperty.class);
/*    */ 
/* 39 */   private String name = null;
/*    */ 
/*    */   public MethodBeanProperty(Method method)
/*    */   {
/* 46 */     super(method);
/*    */ 
/* 48 */     assert (method.getReturnType() == Void.TYPE);
/* 49 */     assert (method.getParameterTypes().length == 1);
/* 50 */     assert (method.getName().startsWith("set"));
/*    */   }
/*    */ 
/*    */   public Class<?> getDeclaringClass()
/*    */   {
/* 55 */     return getMethod().getDeclaringClass();
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 60 */     if (this.name == null)
/*    */     {
/* 62 */       String name = getMethod().getName().substring(3);
/* 63 */       if (name.length() > 1)
/*    */       {
/* 65 */         name = name.substring(0, 1).toLowerCase() + name.substring(1);
/*    */       }
/*    */       else
/*    */       {
/* 69 */         name = name.toLowerCase();
/*    */       }
/* 71 */       this.name = name;
/*    */     }
/* 73 */     return this.name;
/*    */   }
/*    */ 
/*    */   protected Method getMethod()
/*    */   {
/* 78 */     return (Method)getAccessibleObject();
/*    */   }
/*    */ 
/*    */   public Class<?> getType()
/*    */   {
/* 83 */     return getMethod().getParameterTypes()[0];
/*    */   }
/*    */ 
/*    */   public void set(Object instance, Object value)
/*    */   {
/* 91 */     Method method = getMethod();
/* 92 */     Object[] args = { value };
/*    */     try
/*    */     {
/* 95 */       method.invoke(instance, args);
/*    */     }
/*    */     catch (IllegalAccessException e)
/*    */     {
/* 99 */       this.log.fatal("illegal access on method " + method, e);
/* 100 */       throw new RuntimeException(e);
/*    */     }
/*    */     catch (IllegalArgumentException e)
/*    */     {
/* 104 */       String msg = "failed to set value " + value + " with setter " + method;
/* 105 */       this.log.error(msg, e);
/* 106 */       throw new IllegalArgumentException(msg);
/*    */     }
/*    */     catch (InvocationTargetException e)
/*    */     {
/* 110 */       Throwable cause = e.getCause();
/* 111 */       if ((cause instanceof Error))
/* 112 */         throw ((Error)cause);
/* 113 */       if ((cause instanceof RuntimeException))
/* 114 */         throw ((RuntimeException)cause);
/* 115 */       throw new RuntimeException(cause);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.lang.reflect.MethodBeanProperty
 * JD-Core Version:    0.6.0
 */