/*     */ package org.jboss.invocation;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class InvocationStatistics
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -8031193044335393420L;
/*     */   private Map methodStats;
/*  46 */   public long concurrentCalls = 0L;
/*  47 */   public long maxConcurrentCalls = 0L;
/*  48 */   public long lastResetTime = System.currentTimeMillis();
/*     */ 
/*     */   public InvocationStatistics()
/*     */   {
/*  72 */     this.methodStats = new ConcurrentReaderHashMap();
/*     */   }
/*     */ 
/*     */   public void updateStats(Method m, long elapsed)
/*     */   {
/*  83 */     TimeStatistic stat = (TimeStatistic)this.methodStats.get(m);
/*  84 */     if (stat == null)
/*     */     {
/*  86 */       stat = new TimeStatistic();
/*  87 */       this.methodStats.put(m, stat);
/*     */     }
/*  89 */     stat.count += 1L;
/*  90 */     stat.totalTime += elapsed;
/*  91 */     if (stat.minTime > elapsed)
/*  92 */       stat.minTime = elapsed;
/*  93 */     if (stat.maxTime < elapsed)
/*  94 */       stat.maxTime = elapsed;
/*     */   }
/*     */ 
/*     */   public synchronized void callIn()
/*     */   {
/*  99 */     this.concurrentCalls += 1L;
/* 100 */     if (this.concurrentCalls > this.maxConcurrentCalls)
/* 101 */       this.maxConcurrentCalls = this.concurrentCalls;
/*     */   }
/*     */ 
/*     */   public synchronized void callOut()
/*     */   {
/* 106 */     this.concurrentCalls -= 1L;
/*     */   }
/*     */ 
/*     */   public void resetStats()
/*     */   {
/* 114 */     synchronized (this.methodStats)
/*     */     {
/* 116 */       Iterator iter = this.methodStats.values().iterator();
/* 117 */       while (iter.hasNext())
/*     */       {
/* 119 */         TimeStatistic stat = (TimeStatistic)iter.next();
/* 120 */         stat.reset();
/*     */       }
/*     */     }
/* 123 */     this.maxConcurrentCalls = 0L;
/* 124 */     this.lastResetTime = System.currentTimeMillis();
/*     */   }
/*     */ 
/*     */   public Map getStats()
/*     */   {
/* 133 */     return this.methodStats;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 146 */     StringBuffer tmp = new StringBuffer("<InvocationStatistics concurrentCalls='");
/* 147 */     tmp.append(this.concurrentCalls);
/* 148 */     tmp.append("' >\n");
/*     */ 
/* 150 */     HashMap copy = new HashMap(this.methodStats);
/* 151 */     Iterator iter = copy.entrySet().iterator();
/* 152 */     while (iter.hasNext())
/*     */     {
/* 154 */       Map.Entry entry = (Map.Entry)iter.next();
/* 155 */       TimeStatistic stat = (TimeStatistic)entry.getValue();
/* 156 */       if (stat != null)
/*     */       {
/* 158 */         tmp.append("<method name='");
/* 159 */         tmp.append(entry.getKey());
/* 160 */         tmp.append("' count='");
/* 161 */         tmp.append(stat.count);
/* 162 */         tmp.append("' minTime='");
/* 163 */         tmp.append(stat.minTime);
/* 164 */         tmp.append("' maxTime='");
/* 165 */         tmp.append(stat.maxTime);
/* 166 */         tmp.append("' totalTime='");
/* 167 */         tmp.append(stat.totalTime);
/* 168 */         tmp.append("' />\n");
/*     */       }
/*     */     }
/* 171 */     tmp.append("</InvocationStatistics>");
/* 172 */     return tmp.toString();
/*     */   }
/*     */ 
/*     */   public class TimeStatistic
/*     */     implements Serializable
/*     */   {
/*     */     private static final long serialVersionUID = -8689933338506854386L;
/*     */     public volatile long count;
/*  57 */     public volatile long minTime = 9223372036854775807L;
/*     */     public volatile long maxTime;
/*     */     public volatile long totalTime;
/*     */ 
/*     */     public TimeStatistic()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void reset()
/*     */     {
/*  63 */       this.count = 0L;
/*  64 */       this.minTime = 9223372036854775807L;
/*  65 */       this.maxTime = 0L;
/*  66 */       this.totalTime = 0L;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.InvocationStatistics
 * JD-Core Version:    0.6.0
 */