/*     */ package org.jboss.invocation;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.util.Arrays;
/*     */ 
/*     */ public class MarshalledValue
/*     */   implements Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = -1527598981234110311L;
/*     */   private byte[] serializedForm;
/*     */   private int hashCode;
/*     */ 
/*     */   public MarshalledValue()
/*     */   {
/*     */   }
/*     */ 
/*     */   public MarshalledValue(Object obj)
/*     */     throws IOException
/*     */   {
/*  69 */     ByteArrayOutputStream baos = new ByteArrayOutputStream();
/*  70 */     MarshalledValueOutputStream mvos = new MarshalledValueOutputStream(baos);
/*  71 */     mvos.writeObject(obj);
/*  72 */     mvos.flush();
/*  73 */     this.serializedForm = baos.toByteArray();
/*  74 */     mvos.close();
/*     */ 
/*  76 */     int hash = 0;
/*  77 */     for (int i = 0; i < this.serializedForm.length; i++)
/*     */     {
/*  79 */       hash = 31 * hash + this.serializedForm[i];
/*     */     }
/*     */ 
/*  82 */     this.hashCode = hash;
/*     */   }
/*     */ 
/*     */   public Object get() throws IOException, ClassNotFoundException
/*     */   {
/*  87 */     if (this.serializedForm == null) {
/*  88 */       return null;
/*     */     }
/*  90 */     ByteArrayInputStream bais = new ByteArrayInputStream(this.serializedForm);
/*  91 */     MarshalledValueInputStream mvis = new MarshalledValueInputStream(bais);
/*  92 */     Object retValue = mvis.readObject();
/*  93 */     mvis.close();
/*  94 */     return retValue;
/*     */   }
/*     */ 
/*     */   public byte[] toByteArray()
/*     */   {
/*  99 */     return this.serializedForm;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 104 */     int size = this.serializedForm != null ? this.serializedForm.length : 0;
/* 105 */     return size;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 115 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 120 */     if (this == obj) {
/* 121 */       return true;
/*     */     }
/* 123 */     boolean equals = false;
/* 124 */     if ((obj instanceof MarshalledValue))
/*     */     {
/* 126 */       MarshalledValue mv = (MarshalledValue)obj;
/* 127 */       if (this.serializedForm == mv.serializedForm)
/*     */       {
/* 129 */         equals = true;
/*     */       }
/*     */       else
/*     */       {
/* 133 */         equals = Arrays.equals(this.serializedForm, mv.serializedForm);
/*     */       }
/*     */     }
/* 136 */     return equals;
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 154 */     int length = in.readInt();
/* 155 */     this.serializedForm = null;
/* 156 */     if (length > 0)
/*     */     {
/* 158 */       this.serializedForm = new byte[length];
/* 159 */       in.readFully(this.serializedForm);
/*     */     }
/* 161 */     this.hashCode = in.readInt();
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 182 */     int length = this.serializedForm != null ? this.serializedForm.length : 0;
/* 183 */     out.writeInt(length);
/* 184 */     if (length > 0)
/*     */     {
/* 186 */       out.write(this.serializedForm);
/*     */     }
/* 188 */     out.writeInt(this.hashCode);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.MarshalledValue
 * JD-Core Version:    0.6.0
 */