/*    */ package org.jboss.invocation.http.interfaces;
/*    */ 
/*    */ import java.io.Externalizable;
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.invocation.Invocation;
/*    */ import org.jboss.invocation.InvocationContext;
/*    */ import org.jboss.proxy.Interceptor;
/*    */ 
/*    */ public class ClientMethodInterceptor extends Interceptor
/*    */   implements Externalizable
/*    */ {
/*    */   private static final long serialVersionUID = 3511654206312502958L;
/*    */ 
/*    */   public Object invoke(Invocation mi)
/*    */     throws Throwable
/*    */   {
/* 49 */     Method m = mi.getMethod();
/* 50 */     String methodName = m.getName();
/* 51 */     HttpInvokerProxy proxy = (HttpInvokerProxy)mi.getInvocationContext().getInvoker();
/*    */ 
/* 53 */     if (methodName.equals("toString"))
/*    */     {
/* 55 */       return toString(proxy);
/*    */     }
/* 57 */     if (methodName.equals("equals"))
/*    */     {
/* 59 */       Object[] args = mi.getArguments();
/* 60 */       String thisString = toString(proxy);
/* 61 */       String argsString = args[0] == null ? "" : args[0].toString();
/* 62 */       return new Boolean(thisString.equals(argsString));
/*    */     }
/* 64 */     if (methodName.equals("hashCode"))
/*    */     {
/* 66 */       return (Integer)mi.getObjectName();
/*    */     }
/*    */ 
/* 69 */     return getNext().invoke(mi);
/*    */   }
/*    */ 
/*    */   private String toString(HttpInvokerProxy proxy)
/*    */   {
/* 74 */     StringBuffer tmp = new StringBuffer(proxy.toString());
/* 75 */     tmp.append('{');
/* 76 */     tmp.append("externalURLValue=" + proxy.getExternalURLValue());
/* 77 */     tmp.append(",externalURL=" + proxy.getExternalURL());
/* 78 */     tmp.append('}');
/* 79 */     return tmp.toString();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.http.interfaces.ClientMethodInterceptor
 * JD-Core Version:    0.6.0
 */