/*     */ package org.jboss.invocation.jrmp.server;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.InetAddress;
/*     */ import java.net.UnknownHostException;
/*     */ import java.rmi.MarshalledObject;
/*     */ import java.rmi.server.RMIClientSocketFactory;
/*     */ import java.rmi.server.RMIServerSocketFactory;
/*     */ import java.rmi.server.RemoteServer;
/*     */ import java.rmi.server.RemoteStub;
/*     */ import java.rmi.server.UnicastRemoteObject;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import javax.management.MBeanRegistration;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import javax.naming.NameParser;
/*     */ import javax.naming.NamingException;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.Invoker;
/*     */ import org.jboss.invocation.MarshalledInvocation;
/*     */ import org.jboss.invocation.MarshalledValueInputStream;
/*     */ import org.jboss.invocation.jrmp.interfaces.JRMPInvokerProxy;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.JMXExceptionDecoder;
/*     */ import org.jboss.net.sockets.DefaultSocketFactory;
/*     */ import org.jboss.security.SecurityDomain;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.tm.TransactionPropagationContextUtil;
/*     */ 
/*     */ public class JRMPInvoker extends RemoteServer
/*     */   implements Invoker, JRMPInvokerMBean, MBeanRegistration
/*     */ {
/*     */   static final long serialVersionUID = 3110972460891691492L;
/*     */   public static final int ANONYMOUS_PORT = 0;
/*     */   protected Logger log;
/*     */   protected ServiceMBeanSupport support;
/*  96 */   protected int rmiPort = 0;
/*     */   protected RMIClientSocketFactory clientSocketFactory;
/*     */   protected RMIServerSocketFactory serverSocketFactory;
/*     */   protected String clientSocketFactoryName;
/*     */   protected String serverSocketFactoryName;
/*     */   protected String serverAddress;
/*     */   protected String sslDomain;
/*     */   protected RemoteStub invokerStub;
/* 131 */   protected int backlog = 200;
/*     */ 
/* 135 */   protected boolean enableClassCaching = false;
/*     */ 
/* 139 */   private MBeanServerAction serverAction = new MBeanServerAction();
/*     */ 
/*     */   public JRMPInvoker()
/*     */   {
/* 143 */     JRMPInvoker delegate = this;
/*     */ 
/* 146 */     this.support = new ServiceMBeanSupport(getClass(), delegate)
/*     */     {
/*     */       protected void startService() throws Exception
/*     */       {
/* 150 */         this.val$delegate.startService();
/*     */       }
/*     */ 
/*     */       protected void stopService() throws Exception {
/* 154 */         this.val$delegate.stopService();
/*     */       }
/*     */ 
/*     */       protected void destroyService() throws Exception {
/* 158 */         this.val$delegate.destroyService();
/*     */       }
/*     */     };
/* 163 */     this.log = this.support.getLog();
/*     */   }
/*     */ 
/*     */   public int getBacklog()
/*     */   {
/* 171 */     return this.backlog;
/*     */   }
/*     */ 
/*     */   public void setBacklog(int back)
/*     */   {
/* 179 */     this.backlog = back;
/*     */   }
/*     */ 
/*     */   public boolean getEnableClassCaching()
/*     */   {
/* 187 */     return this.enableClassCaching;
/*     */   }
/*     */ 
/*     */   public void setEnableClassCaching(boolean flag)
/*     */   {
/* 195 */     this.enableClassCaching = flag;
/* 196 */     MarshalledValueInputStream.useClassCache(this.enableClassCaching);
/*     */   }
/*     */ 
/*     */   public String getServerHostName()
/*     */   {
/*     */     try
/*     */     {
/* 206 */       return InetAddress.getLocalHost().getHostName();
/*     */     }
/*     */     catch (Exception ignored) {
/*     */     }
/* 210 */     return null;
/*     */   }
/*     */ 
/*     */   public void setRMIObjectPort(int rmiPort)
/*     */   {
/* 219 */     this.rmiPort = rmiPort;
/*     */   }
/*     */ 
/*     */   public int getRMIObjectPort()
/*     */   {
/* 227 */     return this.rmiPort;
/*     */   }
/*     */ 
/*     */   public void setRMIClientSocketFactory(String name)
/*     */   {
/* 235 */     this.clientSocketFactoryName = name;
/*     */   }
/*     */ 
/*     */   public String getRMIClientSocketFactory()
/*     */   {
/* 243 */     return this.clientSocketFactoryName;
/*     */   }
/*     */ 
/*     */   public void setRMIClientSocketFactoryBean(RMIClientSocketFactory bean)
/*     */   {
/* 251 */     this.clientSocketFactory = bean;
/*     */   }
/*     */ 
/*     */   public RMIClientSocketFactory getRMIClientSocketFactoryBean()
/*     */   {
/* 259 */     return this.clientSocketFactory;
/*     */   }
/*     */ 
/*     */   public void setRMIServerSocketFactory(String name)
/*     */   {
/* 267 */     this.serverSocketFactoryName = name;
/*     */   }
/*     */ 
/*     */   public String getRMIServerSocketFactory()
/*     */   {
/* 275 */     return this.serverSocketFactoryName;
/*     */   }
/*     */ 
/*     */   public void setRMIServerSocketFactoryBean(RMIServerSocketFactory bean)
/*     */   {
/* 283 */     this.serverSocketFactory = bean;
/*     */   }
/*     */ 
/*     */   public RMIServerSocketFactory getRMIServerSocketFactoryBean()
/*     */   {
/* 291 */     return this.serverSocketFactory;
/*     */   }
/*     */ 
/*     */   public void setServerAddress(String address)
/*     */   {
/* 299 */     this.serverAddress = address;
/*     */   }
/*     */ 
/*     */   public String getServerAddress()
/*     */   {
/* 307 */     return this.serverAddress;
/*     */   }
/*     */ 
/*     */   public void setSecurityDomain(String domainName)
/*     */   {
/* 315 */     this.sslDomain = domainName;
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 323 */     return this.sslDomain;
/*     */   }
/*     */ 
/*     */   public Serializable getStub()
/*     */   {
/* 328 */     return this.invokerStub;
/*     */   }
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/* 333 */     loadCustomSocketFactories();
/*     */ 
/* 335 */     this.log.debug("RMI Port='" + (this.rmiPort == 0 ? "Anonymous" : Integer.toString(this.rmiPort)) + "'");
/*     */ 
/* 339 */     this.log.debug("Client SocketFactory='" + (this.clientSocketFactory == null ? "Default" : this.clientSocketFactory.toString()) + "'");
/*     */ 
/* 343 */     this.log.debug("Server SocketFactory='" + (this.serverSocketFactory == null ? "Default" : this.serverSocketFactory.toString()) + "'");
/*     */ 
/* 347 */     this.log.debug("Server SocketAddr='" + (this.serverAddress == null ? "Default" : this.serverAddress) + "'");
/*     */ 
/* 350 */     this.log.debug("SecurityDomain='" + (this.sslDomain == null ? "Default" : this.sslDomain) + "'");
/*     */ 
/* 354 */     InitialContext ctx = new InitialContext();
/*     */ 
/* 358 */     TransactionPropagationContextUtil.getTPCImporter();
/*     */ 
/* 363 */     Invoker delegateInvoker = createDelegateInvoker();
/*     */ 
/* 366 */     Registry.bind(this.support.getServiceName(), delegateInvoker);
/*     */ 
/* 369 */     exportCI();
/*     */ 
/* 371 */     this.log.debug("Bound JRMP invoker for JMX node");
/*     */ 
/* 373 */     ctx.close();
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 378 */     InitialContext ctx = new InitialContext();
/*     */     try
/*     */     {
/* 382 */       unexportCI();
/*     */     }
/*     */     finally
/*     */     {
/* 386 */       ctx.close();
/*     */     }
/* 388 */     this.clientSocketFactory = null;
/* 389 */     this.serverSocketFactory = null;
/* 390 */     this.invokerStub = null;
/*     */   }
/*     */ 
/*     */   protected void destroyService()
/*     */     throws Exception
/*     */   {
/* 396 */     Registry.unbind(this.support.getServiceName());
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Exception
/*     */   {
/* 405 */     ClassLoader oldCl = JRMPInvoker.TCLAction.UTIL.getContextClassLoader();
/* 406 */     ObjectName mbean = null;
/*     */     try
/*     */     {
/* 410 */       MarshalledInvocation mi = (MarshalledInvocation)invocation;
/* 411 */       invocation.setTransaction(importTPC(mi.getTransactionPropagationContext()));
/*     */ 
/* 413 */       mbean = (ObjectName)Registry.lookup(invocation.getObjectName());
/*     */ 
/* 416 */       Object obj = this.serverAction.invoke(mbean, "invoke", new Object[] { invocation }, Invocation.INVOKE_SIGNATURE);
/*     */ 
/* 420 */       localMarshalledObject = new MarshalledObject(obj);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       MarshalledObject localMarshalledObject;
/* 424 */       Throwable th = JMXExceptionDecoder.decode(e);
/* 425 */       if (this.log.isTraceEnabled()) {
/* 426 */         this.log.trace("Failed to invoke on mbean: " + mbean, th);
/*     */       }
/* 428 */       if ((th instanceof Exception)) {
/* 429 */         e = (Exception)th;
/*     */       }
/* 431 */       throw e;
/*     */     }
/*     */     finally
/*     */     {
/* 435 */       JRMPInvoker.TCLAction.UTIL.setContextClassLoader(oldCl);
/* 436 */       Thread.interrupted();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Invoker createDelegateInvoker()
/*     */   {
/* 442 */     return new JRMPInvokerProxy(this);
/*     */   }
/*     */ 
/*     */   protected void exportCI() throws Exception
/*     */   {
/* 447 */     this.invokerStub = ((RemoteStub)UnicastRemoteObject.exportObject(this, this.rmiPort, this.clientSocketFactory, this.serverSocketFactory));
/*     */   }
/*     */ 
/*     */   protected void unexportCI()
/*     */     throws Exception
/*     */   {
/* 453 */     UnicastRemoteObject.unexportObject(this, true);
/*     */   }
/*     */ 
/*     */   protected void rebind(Context ctx, String name, Object val)
/*     */     throws NamingException
/*     */   {
/* 462 */     Name n = ctx.getNameParser("").parse(name);
/* 463 */     while (n.size() > 1)
/*     */     {
/* 465 */       String ctxName = n.get(0);
/*     */       try
/*     */       {
/* 468 */         ctx = (Context)ctx.lookup(ctxName);
/*     */       }
/*     */       catch (NameNotFoundException e)
/*     */       {
/* 472 */         ctx = ctx.createSubcontext(ctxName);
/*     */       }
/* 474 */       n = n.getSuffix(1);
/*     */     }
/*     */ 
/* 477 */     ctx.rebind(n.get(0), val);
/*     */   }
/*     */ 
/*     */   protected void loadCustomSocketFactories()
/*     */   {
/* 487 */     ClassLoader loader = JRMPInvoker.TCLAction.UTIL.getContextClassLoader();
/*     */ 
/* 489 */     if (this.clientSocketFactory == null)
/*     */     {
/*     */       try
/*     */       {
/* 493 */         if (this.clientSocketFactoryName != null)
/*     */         {
/* 495 */           Class csfClass = loader.loadClass(this.clientSocketFactoryName);
/* 496 */           this.clientSocketFactory = ((RMIClientSocketFactory)csfClass.newInstance());
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 501 */         this.log.error("Failed to load client socket factory", e);
/* 502 */         this.clientSocketFactory = null;
/*     */       }
/*     */     }
/*     */ 
/* 506 */     if (this.serverSocketFactory == null)
/*     */     {
/*     */       try
/*     */       {
/* 510 */         if (this.serverSocketFactoryName != null)
/*     */         {
/* 512 */           Class ssfClass = loader.loadClass(this.serverSocketFactoryName);
/* 513 */           this.serverSocketFactory = ((RMIServerSocketFactory)ssfClass.newInstance());
/* 514 */           if (this.serverAddress != null)
/*     */           {
/*     */             try
/*     */             {
/* 519 */               Class[] parameterTypes = { String.class };
/* 520 */               Method m = ssfClass.getMethod("setBindAddress", parameterTypes);
/* 521 */               Object[] args = { this.serverAddress };
/* 522 */               m.invoke(this.serverSocketFactory, args);
/*     */             }
/*     */             catch (NoSuchMethodException e)
/*     */             {
/* 526 */               this.log.warn("Socket factory does not support setBindAddress(String)");
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 531 */               this.log.warn("Failed to setBindAddress=" + this.serverAddress + " on socket factory", e);
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/* 538 */           if (this.sslDomain != null)
/*     */           {
/*     */             try
/*     */             {
/* 542 */               InitialContext ctx = new InitialContext();
/* 543 */               SecurityDomain domain = (SecurityDomain)ctx.lookup(this.sslDomain);
/* 544 */               Class[] parameterTypes = { SecurityDomain.class };
/* 545 */               Method m = ssfClass.getMethod("setSecurityDomain", parameterTypes);
/* 546 */               Object[] args = { domain };
/* 547 */               m.invoke(this.serverSocketFactory, args);
/*     */             }
/*     */             catch (NoSuchMethodException e)
/*     */             {
/* 551 */               this.log.error("Socket factory does not support setSecurityDomain(SecurityDomain)");
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 555 */               this.log.error("Failed to setSecurityDomain=" + this.sslDomain + " on socket factory", e);
/*     */             }
/*     */           }
/*     */ 
/*     */         }
/* 560 */         else if (this.serverAddress != null)
/*     */         {
/* 562 */           DefaultSocketFactory defaultFactory = new DefaultSocketFactory(this.backlog);
/* 563 */           this.serverSocketFactory = defaultFactory;
/*     */           try
/*     */           {
/* 566 */             defaultFactory.setBindAddress(this.serverAddress);
/*     */           }
/*     */           catch (UnknownHostException e)
/*     */           {
/* 570 */             this.log.error("Failed to setBindAddress=" + this.serverAddress + " on socket factory", e);
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 576 */         this.log.error("operation failed", e);
/* 577 */         this.serverSocketFactory = null;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Transaction importTPC(Object tpc)
/*     */   {
/* 590 */     if (tpc != null)
/* 591 */       return TransactionPropagationContextUtil.importTPC(tpc);
/* 592 */     return null;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 601 */     return this.support.getName();
/*     */   }
/*     */ 
/*     */   public MBeanServer getServer()
/*     */   {
/* 606 */     return this.support.getServer();
/*     */   }
/*     */ 
/*     */   public int getState()
/*     */   {
/* 611 */     return this.support.getState();
/*     */   }
/*     */ 
/*     */   public String getStateString()
/*     */   {
/* 616 */     return this.support.getStateString();
/*     */   }
/*     */ 
/*     */   public void create() throws Exception
/*     */   {
/* 621 */     this.support.create();
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 626 */     this.support.start();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 631 */     this.support.stop();
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 636 */     this.support.destroy();
/*     */   }
/*     */ 
/*     */   public void jbossInternalLifecycle(String method) throws Exception
/*     */   {
/* 641 */     this.support.jbossInternalLifecycle(method);
/*     */   }
/*     */ 
/*     */   public ObjectName preRegister(MBeanServer server, ObjectName name)
/*     */     throws Exception
/*     */   {
/* 647 */     return this.support.preRegister(server, name);
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean registrationDone)
/*     */   {
/* 652 */     this.support.postRegister(registrationDone);
/*     */   }
/*     */ 
/*     */   public void preDeregister() throws Exception
/*     */   {
/* 657 */     this.support.preDeregister();
/*     */   }
/*     */ 
/*     */   public void postDeregister()
/*     */   {
/* 662 */     this.support.postDeregister();
/*     */   }
/*     */ 
/*     */   class MBeanServerAction
/*     */     implements PrivilegedExceptionAction
/*     */   {
/*     */     private ObjectName target;
/*     */     String method;
/*     */     Object[] args;
/*     */     String[] sig;
/*     */ 
/*     */     MBeanServerAction()
/*     */     {
/*     */     }
/*     */ 
/*     */     MBeanServerAction(ObjectName target, String method, Object[] args, String[] sig)
/*     */     {
/* 795 */       this.target = target;
/* 796 */       this.method = method;
/* 797 */       this.args = args;
/* 798 */       this.sig = sig;
/*     */     }
/*     */ 
/*     */     public Object run() throws Exception
/*     */     {
/* 803 */       Object rtnValue = JRMPInvoker.this.support.getServer().invoke(this.target, this.method, this.args, this.sig);
/* 804 */       return rtnValue;
/*     */     }
/*     */ 
/*     */     Object invoke(ObjectName target, String method, Object[] args, String[] sig)
/*     */       throws Exception
/*     */     {
/* 810 */       SecurityManager sm = System.getSecurityManager();
/* 811 */       Object rtnValue = null;
/* 812 */       if (sm == null)
/*     */       {
/* 815 */         rtnValue = JRMPInvoker.this.support.getServer().invoke(target, method, args, sig);
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/* 822 */           MBeanServerAction action = new MBeanServerAction(JRMPInvoker.this, target, method, args, sig);
/* 823 */           rtnValue = AccessController.doPrivileged(action);
/*     */         }
/*     */         catch (PrivilegedActionException e)
/*     */         {
/* 827 */           Exception ex = e.getException();
/* 828 */           throw ex;
/*     */         }
/*     */       }
/* 831 */       return rtnValue;
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface TCLAction
/*     */   {
/* 695 */     public static final TCLAction NON_PRIVILEGED = new TCLAction()
/*     */     {
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 699 */         return Thread.currentThread().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 704 */         return thread.getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 709 */         Thread.currentThread().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 714 */         thread.setContextClassLoader(cl);
/*     */       }
/* 695 */     };
/*     */ 
/* 718 */     public static final TCLAction PRIVILEGED = new TCLAction()
/*     */     {
/* 720 */       private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 724 */           return Thread.currentThread().getContextClassLoader();
/*     */         }
/* 720 */       };
/*     */ 
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 730 */         return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 735 */         return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(thread)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 739 */             return this.val$thread.getContextClassLoader();
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl) {
/* 746 */         AccessController.doPrivileged(new PrivilegedAction(cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 750 */             Thread.currentThread().setContextClassLoader(this.val$cl);
/* 751 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl) {
/* 758 */         AccessController.doPrivileged(new PrivilegedAction(thread, cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 762 */             this.val$thread.setContextClassLoader(this.val$cl);
/* 763 */             return null;
/*     */           }
/*     */         });
/*     */       }
/* 718 */     };
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader();
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader(Thread paramThread);
/*     */ 
/*     */     public abstract void setContextClassLoader(ClassLoader paramClassLoader);
/*     */ 
/*     */     public abstract void setContextClassLoader(Thread paramThread, ClassLoader paramClassLoader);
/*     */ 
/*     */     public static class UTIL
/*     */     {
/*     */       static JRMPInvoker.TCLAction getTCLAction()
/*     */       {
/* 671 */         return System.getSecurityManager() == null ? JRMPInvoker.TCLAction.NON_PRIVILEGED : JRMPInvoker.TCLAction.PRIVILEGED;
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader()
/*     */       {
/* 676 */         return getTCLAction().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 681 */         return getTCLAction().getContextClassLoader(thread);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 686 */         getTCLAction().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 691 */         getTCLAction().setContextClassLoader(thread, cl);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.jrmp.server.JRMPInvoker
 * JD-Core Version:    0.6.0
 */