/*     */ package org.jboss.invocation.pooled.interfaces;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.Collections;
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ 
/*     */ public class OptimizedObjectInputStream extends ObjectInputStream
/*     */ {
/*     */   private static Map classCache;
/*     */   private static ConcurrentReaderHashMap objectStreamClassCache;
/*  53 */   private static Method lookupStreamClass = null;
/*     */ 
/*     */   public static void useClassCache(boolean flag)
/*     */   {
/*  76 */     if (flag == true)
/*     */     {
/*  78 */       classCache = Collections.synchronizedMap(new WeakHashMap());
/*  79 */       objectStreamClassCache = new ConcurrentReaderHashMap();
/*     */     }
/*     */     else
/*     */     {
/*  83 */       classCache = null;
/*  84 */       objectStreamClassCache = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void flushClassCache()
/*     */   {
/*  93 */     classCache.clear();
/*  94 */     objectStreamClassCache.clear();
/*     */   }
/*     */ 
/*     */   private static Class forName(String className) throws ClassNotFoundException
/*     */   {
/*  99 */     Class clazz = null;
/*     */ 
/* 101 */     if (classCache != null)
/*     */     {
/* 104 */       ConcurrentHashMap subCache = (ConcurrentHashMap)classCache.get(Thread.currentThread().getContextClassLoader());
/* 105 */       if (subCache == null)
/*     */       {
/* 107 */         classCache.put(Thread.currentThread().getContextClassLoader(), new ConcurrentHashMap());
/* 108 */         subCache = (ConcurrentHashMap)classCache.get(Thread.currentThread().getContextClassLoader());
/*     */       }
/*     */ 
/* 111 */       WeakReference ref = (WeakReference)subCache.get(className);
/* 112 */       if (ref != null)
/*     */       {
/* 114 */         clazz = (Class)ref.get();
/*     */       }
/* 116 */       if (clazz == null)
/*     */       {
/* 118 */         if (ref != null) subCache.remove(className);
/* 119 */         ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */         try
/*     */         {
/* 122 */           clazz = loader.loadClass(className);
/*     */         }
/*     */         catch (ClassNotFoundException e)
/*     */         {
/* 130 */           clazz = Class.forName(className, false, loader);
/*     */         }
/* 132 */         subCache.put(className, new WeakReference(clazz));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 137 */       clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
/*     */     }
/* 139 */     return clazz;
/*     */   }
/*     */ 
/*     */   public OptimizedObjectInputStream(InputStream is)
/*     */     throws IOException
/*     */   {
/* 147 */     super(is);
/*     */   }
/*     */ 
/*     */   protected static ObjectStreamClass lookup(Class clazz)
/*     */   {
/* 152 */     Object[] args = { clazz, Boolean.TRUE };
/*     */     try
/*     */     {
/* 155 */       return (ObjectStreamClass)lookupStreamClass.invoke(null, args);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 159 */       ex.printStackTrace();
/*     */     }
/* 161 */     return null;
/*     */   }
/*     */ 
/*     */   protected ObjectStreamClass readClassDescriptor()
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 167 */     if (CompatibilityVersion.pooledInvokerLegacy)
/*     */     {
/* 169 */       String className = readUTF();
/* 170 */       ObjectStreamClass osc = null;
/* 171 */       if (objectStreamClassCache != null)
/*     */       {
/* 173 */         osc = (ObjectStreamClass)objectStreamClassCache.get(className);
/*     */       }
/* 175 */       if (osc == null)
/*     */       {
/* 177 */         Class clazz = forName(className);
/* 178 */         osc = ObjectStreamClass.lookup(clazz);
/* 179 */         if (osc == null) osc = lookup(clazz);
/* 180 */         if (osc == null) throw new IOException("Unable to readClassDescriptor for class " + className);
/* 181 */         if (objectStreamClassCache != null) objectStreamClassCache.put(className, osc);
/*     */       }
/* 183 */       return osc;
/*     */     }
/*     */ 
/* 187 */     return super.readClassDescriptor();
/*     */   }
/*     */ 
/*     */   protected Class resolveClass(ObjectStreamClass v)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 199 */     String className = v.getName();
/* 200 */     return forName(className);
/*     */   }
/*     */ 
/*     */   protected Class resolveProxyClass(String[] interfaces)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 207 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 208 */     Class[] ifaceClasses = new Class[interfaces.length];
/* 209 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 211 */       String className = interfaces[i];
/* 212 */       Class iface = forName(className);
/* 213 */       ifaceClasses[i] = iface;
/*     */     }
/*     */ 
/* 216 */     return Proxy.getProxyClass(loader, ifaceClasses);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  57 */     useClassCache(true);
/*     */     try
/*     */     {
/*  60 */       lookupStreamClass = ObjectStreamClass.class.getDeclaredMethod("lookup", new Class[] { Class.class, Boolean.TYPE });
/*  61 */       lookupStreamClass.setAccessible(true);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  65 */       ex.printStackTrace();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.pooled.interfaces.OptimizedObjectInputStream
 * JD-Core Version:    0.6.0
 */