/*    */ package org.jboss.invocation.pooled.interfaces;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectOutputStream;
/*    */ import java.io.ObjectStreamClass;
/*    */ import java.io.OutputStream;
/*    */ import java.rmi.Remote;
/*    */ import java.rmi.server.RemoteObject;
/*    */ import java.rmi.server.RemoteStub;
/*    */ 
/*    */ public class OptimizedObjectOutputStream extends ObjectOutputStream
/*    */ {
/*    */   public OptimizedObjectOutputStream(OutputStream os)
/*    */     throws IOException
/*    */   {
/* 53 */     super(os);
/* 54 */     enableReplaceObject(true);
/*    */   }
/*    */ 
/*    */   protected void writeClassDescriptor(ObjectStreamClass classdesc)
/*    */     throws IOException
/*    */   {
/* 65 */     if (CompatibilityVersion.pooledInvokerLegacy)
/*    */     {
/* 67 */       writeUTF(classdesc.getName());
/*    */     }
/*    */     else
/*    */     {
/* 71 */       super.writeClassDescriptor(classdesc);
/*    */     }
/*    */   }
/*    */ 
/*    */   protected Object replaceObject(Object obj)
/*    */     throws IOException
/*    */   {
/* 80 */     if (((obj instanceof Remote)) && (!(obj instanceof RemoteStub)))
/*    */     {
/* 82 */       Remote remote = (Remote)obj;
/*    */       try
/*    */       {
/* 85 */         obj = RemoteObject.toStub(remote);
/*    */       }
/*    */       catch (IOException ignore)
/*    */       {
/*    */       }
/*    */     }
/*    */ 
/* 92 */     return obj;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.pooled.interfaces.OptimizedObjectOutputStream
 * JD-Core Version:    0.6.0
 */