/*     */ package org.jboss.invocation.pooled.interfaces;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutput;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.util.Arrays;
/*     */ 
/*     */ public class PooledMarshalledValue
/*     */   implements Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = -1265347772036749711L;
/*     */   private byte[] serializedForm;
/*     */   private int hashCode;
/*     */ 
/*     */   public PooledMarshalledValue()
/*     */   {
/*     */   }
/*     */ 
/*     */   public PooledMarshalledValue(Object obj)
/*     */     throws IOException
/*     */   {
/*  70 */     ByteArrayOutputStream baos = new ByteArrayOutputStream();
/*  71 */     ObjectOutputStream mvos = new OptimizedObjectOutputStream(baos);
/*  72 */     mvos.writeObject(obj);
/*  73 */     mvos.flush();
/*  74 */     this.serializedForm = baos.toByteArray();
/*  75 */     mvos.close();
/*     */ 
/*  77 */     int hash = 0;
/*  78 */     for (int i = 0; i < this.serializedForm.length; i++)
/*     */     {
/*  80 */       hash = 31 * hash + this.serializedForm[i];
/*     */     }
/*     */ 
/*  83 */     this.hashCode = hash;
/*     */   }
/*     */ 
/*     */   public Object get() throws IOException, ClassNotFoundException
/*     */   {
/*  88 */     if (this.serializedForm == null) {
/*  89 */       return null;
/*     */     }
/*  91 */     ByteArrayInputStream bais = new ByteArrayInputStream(this.serializedForm);
/*  92 */     ObjectInputStream mvis = new OptimizedObjectInputStream(bais);
/*  93 */     Object retValue = mvis.readObject();
/*  94 */     mvis.close();
/*  95 */     return retValue;
/*     */   }
/*     */ 
/*     */   public byte[] toByteArray()
/*     */   {
/* 100 */     return this.serializedForm;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 105 */     int size = this.serializedForm != null ? this.serializedForm.length : 0;
/* 106 */     return size;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 116 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 121 */     if (this == obj) {
/* 122 */       return true;
/*     */     }
/* 124 */     boolean equals = false;
/* 125 */     if ((obj instanceof PooledMarshalledValue))
/*     */     {
/* 127 */       PooledMarshalledValue mv = (PooledMarshalledValue)obj;
/* 128 */       if (this.serializedForm == mv.serializedForm)
/*     */       {
/* 130 */         equals = true;
/*     */       }
/*     */       else
/*     */       {
/* 134 */         equals = Arrays.equals(this.serializedForm, mv.serializedForm);
/*     */       }
/*     */     }
/* 137 */     return equals;
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 155 */     int length = in.readInt();
/* 156 */     this.serializedForm = null;
/* 157 */     if (length > 0)
/*     */     {
/* 159 */       this.serializedForm = new byte[length];
/* 160 */       in.readFully(this.serializedForm);
/*     */     }
/* 162 */     this.hashCode = in.readInt();
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 183 */     int length = this.serializedForm != null ? this.serializedForm.length : 0;
/* 184 */     out.writeInt(length);
/* 185 */     if (length > 0)
/*     */     {
/* 187 */       out.write(this.serializedForm);
/*     */     }
/* 189 */     out.writeInt(this.hashCode);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.pooled.interfaces.PooledMarshalledValue
 * JD-Core Version:    0.6.0
 */