/*     */ package org.jboss.invocation.pooled.server;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.BufferedOutputStream;
/*     */ import java.io.InterruptedIOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.net.InetAddress;
/*     */ import java.net.Socket;
/*     */ import java.util.LinkedList;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.pooled.interfaces.OptimizedObjectInputStream;
/*     */ import org.jboss.invocation.pooled.interfaces.OptimizedObjectOutputStream;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ServerThread extends Thread
/*     */ {
/*  57 */   private static final Logger log = Logger.getLogger(ServerThread.class);
/*     */   protected ObjectInputStream in;
/*     */   protected ObjectOutputStream out;
/*     */   protected Socket socket;
/*     */   protected PooledInvoker invoker;
/*     */   protected LRUPool clientpool;
/*     */   protected LinkedList threadpool;
/*  65 */   protected volatile boolean running = true;
/*  66 */   protected volatile boolean handlingResponse = true;
/*  67 */   protected volatile boolean shutdown = false;
/*     */   protected boolean trace;
/*  69 */   protected static int id = 0;
/*     */ 
/*     */   public static synchronized int nextID()
/*     */   {
/*  73 */     int nextID = id++;
/*  74 */     return nextID;
/*     */   }
/*     */ 
/*     */   public ServerThread(Socket socket, PooledInvoker invoker, LRUPool clientpool, LinkedList threadpool, int timeout)
/*     */     throws Exception
/*     */   {
/*  80 */     super("PooledInvokerThread-" + socket.getInetAddress().getHostAddress() + "-" + nextID());
/*  81 */     this.socket = socket;
/*  82 */     this.invoker = invoker;
/*  83 */     this.clientpool = clientpool;
/*  84 */     this.threadpool = threadpool;
/*  85 */     this.trace = log.isTraceEnabled();
/*  86 */     socket.setSoTimeout(timeout);
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/*  91 */     this.shutdown = true;
/*  92 */     this.running = false;
/*     */ 
/* 101 */     if (!this.handlingResponse)
/*     */     {
/*     */       try
/*     */       {
/* 105 */         interrupt();
/* 106 */         Thread.interrupted();
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void evict() {
/* 115 */     this.running = false;
/*     */ 
/* 127 */     if (!this.handlingResponse)
/*     */     {
/*     */       try
/*     */       {
/* 131 */         interrupt();
/* 132 */         Thread.interrupted();
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void wakeup(Socket socket, int timeout) throws Exception {
/* 141 */     this.socket = socket;
/* 142 */     String name = "PooledInvokerThread-" + socket.getInetAddress().getHostAddress() + "-" + nextID();
/* 143 */     super.setName(name);
/* 144 */     socket.setSoTimeout(timeout);
/* 145 */     this.running = true;
/* 146 */     this.handlingResponse = true;
/* 147 */     notify();
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*     */     try
/*     */     {
/*     */       while (true)
/*     */       {
/* 156 */         dorun();
/*     */ 
/* 158 */         if (this.shutdown)
/*     */         {
/* 161 */           synchronized (this.clientpool)
/*     */           {
/* 163 */             this.clientpool.remove(this);
/*     */           }
/* 165 */           return;
/*     */         }
/*     */ 
/* 170 */         synchronized (this)
/*     */         {
/* 173 */           synchronized (this.clientpool)
/*     */           {
/* 176 */             synchronized (this.threadpool)
/*     */             {
/* 179 */               this.clientpool.remove(this);
/*     */ 
/* 181 */               this.threadpool.add(this);
/* 182 */               Thread.interrupted();
/* 183 */               this.clientpool.notify();
/*     */             }
/*     */           }
/* 186 */           if (this.trace)
/* 187 */             log.trace("begin thread wait");
/* 188 */           wait();
/* 189 */           if (this.trace) {
/* 190 */             log.trace("WAKEUP in SERVER THREAD");
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/* 197 */       if (this.trace)
/* 198 */         log.trace("Exiting run on exception", ignored);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void acknowledge()
/*     */     throws Exception
/*     */   {
/* 207 */     byte ACK = this.in.readByte();
/*     */ 
/* 216 */     this.handlingResponse = true;
/*     */ 
/* 218 */     this.out.writeByte(ACK);
/* 219 */     this.out.flush();
/*     */   }
/*     */ 
/*     */   protected void processInvocation() throws Exception
/*     */   {
/* 224 */     this.handlingResponse = true;
/*     */ 
/* 226 */     Invocation invocation = (Invocation)this.in.readObject();
/* 227 */     this.in.readObject();
/* 228 */     Object response = null;
/*     */     try
/*     */     {
/* 232 */       boolean interrupted = Thread.interrupted();
/* 233 */       response = this.invoker.invoke(invocation);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 237 */       response = ex;
/*     */     }
/* 239 */     Thread.interrupted();
/* 240 */     this.out.writeObject(response);
/* 241 */     this.out.reset();
/*     */ 
/* 245 */     this.out.writeObject(Boolean.TRUE);
/* 246 */     this.out.flush();
/* 247 */     this.out.reset();
/* 248 */     this.handlingResponse = false;
/*     */   }
/*     */ 
/*     */   protected void dorun()
/*     */   {
/* 256 */     log.debug("beginning dorun");
/* 257 */     this.running = true;
/* 258 */     this.handlingResponse = true;
/*     */     try
/*     */     {
/* 261 */       BufferedOutputStream bos = new BufferedOutputStream(this.socket.getOutputStream());
/* 262 */       this.out = new OptimizedObjectOutputStream(bos);
/* 263 */       this.out.flush();
/* 264 */       BufferedInputStream bis = new BufferedInputStream(this.socket.getInputStream());
/* 265 */       this.in = new OptimizedObjectInputStream(bis);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 269 */       log.error("Failed to initialize", e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 275 */       processInvocation();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 279 */       this.running = false;
/* 280 */       if (this.trace) {
/* 281 */         log.trace("invocation failed", e);
/*     */       }
/*     */     }
/*     */ 
/* 285 */     while (this.running)
/*     */     {
/*     */       try
/*     */       {
/* 289 */         acknowledge();
/* 290 */         processInvocation();
/*     */       }
/*     */       catch (InterruptedIOException e)
/*     */       {
/* 294 */         log.debug("socket timed out", e);
/* 295 */         this.running = false;
/*     */       }
/*     */       catch (InterruptedException e)
/*     */       {
/* 299 */         log.debug("interrupted", e);
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 303 */         if (this.trace)
/* 304 */           log.debug("invocation failed", ex);
/* 305 */         this.running = false;
/*     */       }
/*     */ 
/* 308 */       Thread.interrupted();
/*     */     }
/*     */ 
/* 311 */     if (this.trace) {
/* 312 */       log.trace("finished loop");
/*     */     }
/*     */     try
/*     */     {
/* 316 */       if (this.in != null) this.in.close();
/* 317 */       if (this.out != null) this.out.close();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/*     */     try
/*     */     {
/* 324 */       this.socket.close();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 328 */       log.debug("Failed cleanup", ex);
/*     */     }
/* 330 */     this.socket = null;
/* 331 */     this.in = null;
/* 332 */     this.out = null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.pooled.server.ServerThread
 * JD-Core Version:    0.6.0
 */