/*     */ package org.jboss.invocation.unified.interfaces;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.io.StreamCorruptedException;
/*     */ import java.rmi.MarshalledObject;
/*     */ import java.rmi.RemoteException;
/*     */ import java.rmi.ServerException;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.Invoker;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class UnifiedInvokerProxy
/*     */   implements Invoker, Externalizable
/*     */ {
/*     */   static final long serialVersionUID = -1108158470271861548L;
/*     */   private transient Client client;
/*     */   private InvokerLocator locator;
/*  53 */   private boolean strictRMIException = false;
/*     */ 
/*  55 */   private String subsystem = "invoker";
/*     */ 
/*  57 */   protected final Logger log = Logger.getLogger(getClass());
/*     */   static final int VERSION_5_0 = 500;
/*     */   static final int CURRENT_VERSION = 500;
/*     */ 
/*     */   public UnifiedInvokerProxy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public UnifiedInvokerProxy(InvokerLocator locator)
/*     */   {
/*  70 */     init(locator);
/*     */   }
/*     */ 
/*     */   public UnifiedInvokerProxy(InvokerLocator locator, boolean isStrictRMIException)
/*     */   {
/*  75 */     this.strictRMIException = isStrictRMIException;
/*  76 */     init(locator);
/*     */   }
/*     */ 
/*     */   protected void init(InvokerLocator locator)
/*     */   {
/*  81 */     this.locator = locator;
/*     */     try
/*     */     {
/*  85 */       this.client = createClient(locator, getSubSystem());
/*  86 */       this.client.connect();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  90 */       this.log.fatal("Could not initialize UnifiedInvokerProxy.", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getSubSystem()
/*     */   {
/*  97 */     return this.subsystem;
/*     */   }
/*     */ 
/*     */   public void setSubSystem(String subsystem)
/*     */   {
/* 102 */     this.subsystem = subsystem;
/*     */   }
/*     */ 
/*     */   public boolean isStrictRMIException()
/*     */   {
/* 108 */     return this.strictRMIException;
/*     */   }
/*     */ 
/*     */   protected Client getClient()
/*     */   {
/* 113 */     return this.client;
/*     */   }
/*     */ 
/*     */   protected InvokerLocator getLocator()
/*     */   {
/* 118 */     return this.locator;
/*     */   }
/*     */ 
/*     */   protected void setLocator(InvokerLocator locator)
/*     */   {
/* 123 */     this.locator = locator;
/*     */   }
/*     */ 
/*     */   protected void setStrictRMIException(boolean strictRMIException)
/*     */   {
/* 128 */     this.strictRMIException = strictRMIException;
/*     */   }
/*     */ 
/*     */   public String getServerHostName()
/*     */     throws Exception
/*     */   {
/* 141 */     if (this.locator != null)
/*     */     {
/* 143 */       return this.locator.getHost();
/*     */     }
/*     */ 
/* 147 */     return null;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Exception
/*     */   {
/* 158 */     Object response = null;
/*     */     try
/*     */     {
/* 162 */       response = this.client.invoke(invocation, null);
/*     */ 
/* 164 */       if ((response instanceof Exception))
/*     */       {
/* 166 */         throw ((Exception)response);
/*     */       }
/* 168 */       if ((response instanceof MarshalledObject))
/*     */       {
/* 170 */         return ((MarshalledObject)response).get();
/*     */       }
/* 172 */       return response;
/*     */     }
/*     */     catch (RemoteException aex)
/*     */     {
/* 178 */       if (this.strictRMIException)
/*     */       {
/* 180 */         throw new ServerException(aex.getMessage(), aex);
/*     */       }
/*     */ 
/* 184 */       throw aex;
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 193 */       if ((throwable instanceof Exception))
/*     */       {
/* 195 */         throw ((Exception)throwable);
/*     */       }
/*     */     }
/* 197 */     throw new Exception(throwable);
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 207 */     out.writeInt(500);
/*     */ 
/* 209 */     out.writeUTF(this.locator.getOriginalURI());
/* 210 */     out.writeBoolean(this.strictRMIException);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 219 */     int version = in.readInt();
/*     */ 
/* 221 */     switch (version)
/*     */     {
/*     */     case 500:
/* 224 */       this.locator = new InvokerLocator(in.readUTF());
/* 225 */       this.strictRMIException = in.readBoolean();
/* 226 */       init(this.locator);
/* 227 */       break;
/*     */     default:
/* 229 */       throw new StreamCorruptedException("Unknown version seen: " + version);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Client createClient(InvokerLocator locator, String subSystem) throws Exception
/*     */   {
/* 235 */     return new Client(locator, subSystem);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.unified.interfaces.UnifiedInvokerProxy
 * JD-Core Version:    0.6.0
 */