/*     */ package org.jboss.javabean.plugins.xml;
/*     */ 
/*     */ import javax.xml.namespace.NamespaceContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementInterceptor;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingInitializer;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class JavaBeanSchemaInitializer
/*     */   implements SchemaBindingInitializer
/*     */ {
/*     */   private static final String JAVABEAN_NS = "urn:jboss:javabean:1.0";
/*  50 */   private static final QName javabeanTypeQName = new QName("urn:jboss:javabean:1.0", "javabeanType");
/*     */ 
/*  53 */   private static final QName propertyTypeQName = new QName("urn:jboss:javabean:1.0", "propertyType");
/*     */ 
/*  56 */   private static final QName propertyQName = new QName("urn:jboss:javabean:1.0", "property");
/*     */ 
/*     */   public SchemaBinding init(SchemaBinding schema)
/*     */   {
/*  66 */     schema.setReplacePropertyRefs(false);
/*     */ 
/*  69 */     TypeBinding beanType = schema.getType(javabeanTypeQName);
/*  70 */     beanType.setHandler(new DefaultElementHandler()
/*     */     {
/*     */       public Object startElement(Object parent, QName name, ElementBinding element)
/*     */       {
/*  75 */         return new Common.Holder();
/*     */       }
/*     */ 
/*     */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*     */       {
/*  80 */         Common.Holder holder = (Common.Holder)o;
/*  81 */         String className = null;
/*  82 */         for (int i = 0; i < attrs.getLength(); i++)
/*     */         {
/*  84 */           String localName = attrs.getLocalName(i);
/*  85 */           if ("class".equals(localName)) {
/*  86 */             className = attrs.getValue(i);
/*     */           }
/*     */         }
/*  89 */         if (className == null) {
/*  90 */           throw new IllegalArgumentException("No class attribute for " + elementName);
/*     */         }
/*     */         try
/*     */         {
/*  94 */           BeanInfo beanInfo = ConfigurationUtil.getBeanInfo(className);
/*  95 */           Object object = beanInfo.newInstance();
/*  96 */           holder.setValue(object);
/*     */         }
/*     */         catch (RuntimeException e)
/*     */         {
/* 100 */           throw e;
/*     */         }
/*     */         catch (Error e)
/*     */         {
/* 104 */           throw e;
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 108 */           throw new RuntimeException("Error instantiating class " + className, t);
/*     */         }
/*     */       }
/*     */ 
/*     */       public Object endElement(Object o, QName qName, ElementBinding element)
/*     */       {
/* 114 */         Common.Holder holder = (Common.Holder)o;
/* 115 */         return holder.getValue();
/*     */       }
/*     */     });
/* 120 */     beanType.pushInterceptor(propertyQName, new DefaultElementInterceptor()
/*     */     {
/*     */       public void add(Object parent, Object child, QName name)
/*     */       {
/* 124 */         Common.Holder holder = (Common.Holder)parent;
/* 125 */         Object parentValue = holder.getValue();
/*     */ 
/* 127 */         Common.Property prop = (Common.Property)child;
/* 128 */         String property = prop.getProperty();
/* 129 */         Object value = prop.getValue();
/*     */         try
/*     */         {
/* 132 */           BeanInfo info = ConfigurationUtil.getBeanInfo(parentValue.getClass());
/* 133 */           value = ConfigurationUtil.convertValue(parentValue, property, prop.getType(), value);
/* 134 */           info.setProperty(parentValue, property, value);
/*     */         }
/*     */         catch (RuntimeException e)
/*     */         {
/* 138 */           throw e;
/*     */         }
/*     */         catch (Error e)
/*     */         {
/* 142 */           throw e;
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 146 */           throw new RuntimeException("Error setting property " + property + " on object" + parentValue + " with value " + value, t);
/*     */         }
/*     */       }
/*     */     });
/* 152 */     TypeBinding propertyType = schema.getType(propertyTypeQName);
/* 153 */     propertyType.setHandler(new DefaultElementHandler()
/*     */     {
/*     */       public Object startElement(Object parent, QName name, ElementBinding element)
/*     */       {
/* 158 */         return new Common.Property();
/*     */       }
/*     */ 
/*     */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*     */       {
/* 163 */         Common.Property property = (Common.Property)o;
/* 164 */         for (int i = 0; i < attrs.getLength(); i++)
/*     */         {
/* 166 */           String localName = attrs.getLocalName(i);
/* 167 */           if ("name".equals(localName))
/* 168 */             property.setProperty(attrs.getValue(i));
/* 169 */           else if ("class".equals(localName))
/* 170 */             property.setType(attrs.getValue(i));
/*     */         }
/*     */       }
/*     */     });
/* 175 */     return schema;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  60 */     ConfigurationUtil.init();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.javabean.plugins.xml.JavaBeanSchemaInitializer
 * JD-Core Version:    0.6.0
 */