/*    */ package org.jboss.jms.client;
/*    */ 
/*    */ import org.jboss.jms.client.container.JmsClientAspectXMLLoader;
/*    */ import org.jboss.jms.delegate.ConnectionFactoryEndpoint;
/*    */ 
/*    */ public class ClientAOPStackLoader
/*    */ {
/*    */   private static ClientAOPStackLoader instance;
/*    */   private boolean loaded;
/*    */ 
/*    */   public static ClientAOPStackLoader getInstance()
/*    */   {
/* 28 */     synchronized (ClientAOPStackLoader.class)
/*    */     {
/* 30 */       if (instance == null)
/*    */       {
/* 32 */         instance = new ClientAOPStackLoader();
/*    */       }
/* 34 */       return instance;
/*    */     }
/*    */   }
/*    */ 
/*    */   private ClientAOPStackLoader()
/*    */   {
/* 48 */     this.loaded = false;
/*    */   }
/*    */ 
/*    */   public synchronized void load(ConnectionFactoryEndpoint delegate)
/*    */     throws Exception
/*    */   {
/* 62 */     if (this.loaded)
/*    */     {
/* 64 */       return;
/*    */     }
/*    */ 
/* 67 */     ClassLoader savedLoader = Thread.currentThread().getContextClassLoader();
/*    */     try
/*    */     {
/* 73 */       Thread.currentThread().setContextClassLoader(getClass().getClassLoader());
/*    */ 
/* 75 */       byte[] clientAOPStack = delegate.getClientAOPStack();
/*    */ 
/* 77 */       new JmsClientAspectXMLLoader().deployXML(clientAOPStack);
/*    */ 
/* 79 */       this.loaded = true;
/*    */     }
/*    */     finally
/*    */     {
/* 83 */       Thread.currentThread().setContextClassLoader(savedLoader);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.ClientAOPStackLoader
 * JD-Core Version:    0.6.0
 */