/*     */ package org.jboss.jms.client;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.jms.Connection;
/*     */ import javax.jms.ConnectionFactory;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.QueueConnection;
/*     */ import javax.jms.QueueConnectionFactory;
/*     */ import javax.jms.TopicConnection;
/*     */ import javax.jms.TopicConnectionFactory;
/*     */ import javax.jms.XAConnection;
/*     */ import javax.jms.XAConnectionFactory;
/*     */ import javax.jms.XAQueueConnection;
/*     */ import javax.jms.XAQueueConnectionFactory;
/*     */ import javax.jms.XATopicConnection;
/*     */ import javax.jms.XATopicConnectionFactory;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.Reference;
/*     */ import org.jboss.jms.delegate.ConnectionFactoryDelegate;
/*     */ import org.jboss.jms.delegate.CreateConnectionResult;
/*     */ import org.jboss.jms.referenceable.SerializableObjectRefAddr;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JBossConnectionFactory
/*     */   implements ConnectionFactory, QueueConnectionFactory, TopicConnectionFactory, XAConnectionFactory, XAQueueConnectionFactory, XATopicConnectionFactory, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -2810634789345348326L;
/*  63 */   private static final Logger log = Logger.getLogger(JBossConnectionFactory.class);
/*     */   protected ConnectionFactoryDelegate delegate;
/*     */ 
/*     */   public JBossConnectionFactory(ConnectionFactoryDelegate delegate)
/*     */   {
/*  75 */     this.delegate = delegate;
/*     */   }
/*     */ 
/*     */   public Connection createConnection()
/*     */     throws JMSException
/*     */   {
/*  82 */     return createConnection(null, null);
/*     */   }
/*     */ 
/*     */   public Connection createConnection(String username, String password) throws JMSException
/*     */   {
/*  87 */     return createConnectionInternal(username, password, false, 0);
/*     */   }
/*     */ 
/*     */   public QueueConnection createQueueConnection()
/*     */     throws JMSException
/*     */   {
/*  95 */     return createQueueConnection(null, null);
/*     */   }
/*     */ 
/*     */   public QueueConnection createQueueConnection(String username, String password)
/*     */     throws JMSException
/*     */   {
/* 101 */     return createConnectionInternal(username, password, false, 1);
/*     */   }
/*     */ 
/*     */   public TopicConnection createTopicConnection()
/*     */     throws JMSException
/*     */   {
/* 109 */     return createTopicConnection(null, null);
/*     */   }
/*     */ 
/*     */   public TopicConnection createTopicConnection(String username, String password)
/*     */     throws JMSException
/*     */   {
/* 115 */     return createConnectionInternal(username, password, false, 2);
/*     */   }
/*     */ 
/*     */   public XAConnection createXAConnection()
/*     */     throws JMSException
/*     */   {
/* 123 */     return createXAConnection(null, null);
/*     */   }
/*     */ 
/*     */   public XAConnection createXAConnection(String username, String password) throws JMSException
/*     */   {
/* 128 */     return createConnectionInternal(username, password, true, 0);
/*     */   }
/*     */ 
/*     */   public XAQueueConnection createXAQueueConnection()
/*     */     throws JMSException
/*     */   {
/* 136 */     return createXAQueueConnection(null, null);
/*     */   }
/*     */ 
/*     */   public XAQueueConnection createXAQueueConnection(String username, String password)
/*     */     throws JMSException
/*     */   {
/* 142 */     return createConnectionInternal(username, password, true, 1);
/*     */   }
/*     */ 
/*     */   public XATopicConnection createXATopicConnection()
/*     */     throws JMSException
/*     */   {
/* 150 */     return createXATopicConnection(null, null);
/*     */   }
/*     */ 
/*     */   public XATopicConnection createXATopicConnection(String username, String password)
/*     */     throws JMSException
/*     */   {
/* 156 */     return createConnectionInternal(username, password, true, 2);
/*     */   }
/*     */ 
/*     */   public Reference getReference()
/*     */     throws NamingException
/*     */   {
/* 164 */     return new Reference("org.jboss.jms.client.JBossConnectionFactory", new SerializableObjectRefAddr("JBM-CF", this), "org.jboss.jms.referenceable.ConnectionFactoryObjectFactory", null);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 174 */     return "JBossConnectionFactory->" + this.delegate;
/*     */   }
/*     */ 
/*     */   public ConnectionFactoryDelegate getDelegate()
/*     */   {
/* 179 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   protected JBossConnection createConnectionInternal(String username, String password, boolean isXA, int type)
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 192 */       ClientAOPStackLoader.getInstance().load(this.delegate);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 197 */       String msg = "Failed to download and/or install client side AOP stack";
/* 198 */       log.error("Failed to download and/or install client side AOP stack", e);
/* 199 */       throw new RuntimeException("Failed to download and/or install client side AOP stack", e);
/*     */     }
/*     */ 
/* 205 */     CreateConnectionResult res = this.delegate.createConnectionDelegate(username, password, -1);
/*     */ 
/* 207 */     return new JBossConnection(res.getDelegate(), type);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.JBossConnectionFactory
 * JD-Core Version:    0.6.0
 */