/*     */ package org.jboss.jms.client;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.jms.BytesMessage;
/*     */ import javax.jms.Destination;
/*     */ import javax.jms.IllegalStateException;
/*     */ import javax.jms.InvalidDestinationException;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.MapMessage;
/*     */ import javax.jms.Message;
/*     */ import javax.jms.MessageConsumer;
/*     */ import javax.jms.MessageListener;
/*     */ import javax.jms.MessageProducer;
/*     */ import javax.jms.ObjectMessage;
/*     */ import javax.jms.Queue;
/*     */ import javax.jms.QueueBrowser;
/*     */ import javax.jms.QueueReceiver;
/*     */ import javax.jms.QueueSender;
/*     */ import javax.jms.QueueSession;
/*     */ import javax.jms.Session;
/*     */ import javax.jms.StreamMessage;
/*     */ import javax.jms.TemporaryQueue;
/*     */ import javax.jms.TemporaryTopic;
/*     */ import javax.jms.TextMessage;
/*     */ import javax.jms.Topic;
/*     */ import javax.jms.TopicPublisher;
/*     */ import javax.jms.TopicSession;
/*     */ import javax.jms.TopicSubscriber;
/*     */ import javax.jms.XAQueueSession;
/*     */ import javax.jms.XASession;
/*     */ import javax.jms.XATopicSession;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import org.jboss.jms.client.delegate.DelegateSupport;
/*     */ import org.jboss.jms.client.state.SessionState;
/*     */ import org.jboss.jms.delegate.BrowserDelegate;
/*     */ import org.jboss.jms.delegate.ConsumerDelegate;
/*     */ import org.jboss.jms.delegate.ProducerDelegate;
/*     */ import org.jboss.jms.delegate.SessionDelegate;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ import org.jboss.jms.destination.JBossQueue;
/*     */ import org.jboss.jms.destination.JBossTemporaryQueue;
/*     */ import org.jboss.jms.destination.JBossTemporaryTopic;
/*     */ import org.jboss.jms.destination.JBossTopic;
/*     */ import org.jboss.jms.message.MessageProxy;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JBossSession
/*     */   implements Session, XASession, QueueSession, XAQueueSession, TopicSession, XATopicSession, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 2235942510476264909L;
/*     */   static final int TYPE_GENERIC_SESSION = 0;
/*     */   static final int TYPE_QUEUE_SESSION = 1;
/*     */   static final int TYPE_TOPIC_SESSION = 2;
/*  94 */   private static final Logger log = Logger.getLogger(JBossSession.class);
/*     */   protected SessionDelegate delegate;
/*     */   protected int sessionType;
/*     */ 
/*     */   public JBossSession(SessionDelegate sessionDelegate, int sessionType)
/*     */   {
/* 106 */     this.delegate = sessionDelegate;
/* 107 */     this.sessionType = sessionType;
/*     */   }
/*     */ 
/*     */   public BytesMessage createBytesMessage()
/*     */     throws JMSException
/*     */   {
/* 114 */     return this.delegate.createBytesMessage();
/*     */   }
/*     */ 
/*     */   public MapMessage createMapMessage() throws JMSException
/*     */   {
/* 119 */     return this.delegate.createMapMessage();
/*     */   }
/*     */ 
/*     */   public Message createMessage() throws JMSException
/*     */   {
/* 124 */     return this.delegate.createMessage();
/*     */   }
/*     */ 
/*     */   public ObjectMessage createObjectMessage() throws JMSException
/*     */   {
/* 129 */     return this.delegate.createObjectMessage();
/*     */   }
/*     */ 
/*     */   public ObjectMessage createObjectMessage(Serializable object) throws JMSException
/*     */   {
/* 134 */     return this.delegate.createObjectMessage(object);
/*     */   }
/*     */ 
/*     */   public StreamMessage createStreamMessage() throws JMSException
/*     */   {
/* 139 */     return this.delegate.createStreamMessage();
/*     */   }
/*     */ 
/*     */   public TextMessage createTextMessage() throws JMSException
/*     */   {
/* 144 */     return this.delegate.createTextMessage();
/*     */   }
/*     */ 
/*     */   public TextMessage createTextMessage(String text) throws JMSException
/*     */   {
/* 149 */     return this.delegate.createTextMessage(text);
/*     */   }
/*     */ 
/*     */   public boolean getTransacted() throws JMSException
/*     */   {
/* 154 */     return this.delegate.getTransacted();
/*     */   }
/*     */ 
/*     */   public int getAcknowledgeMode() throws JMSException
/*     */   {
/* 159 */     return this.delegate.getAcknowledgeMode();
/*     */   }
/*     */ 
/*     */   public void commit() throws JMSException
/*     */   {
/* 164 */     this.delegate.commit();
/*     */   }
/*     */ 
/*     */   public void rollback() throws JMSException
/*     */   {
/* 169 */     this.delegate.rollback();
/*     */   }
/*     */ 
/*     */   public void close() throws JMSException
/*     */   {
/* 174 */     this.delegate.closing(-1L);
/* 175 */     this.delegate.close();
/*     */   }
/*     */ 
/*     */   public void recover() throws JMSException
/*     */   {
/* 180 */     this.delegate.recover();
/*     */   }
/*     */ 
/*     */   public MessageListener getMessageListener() throws JMSException
/*     */   {
/* 185 */     if (log.isTraceEnabled()) log.trace("getMessageListener() called");
/* 186 */     return this.delegate.getMessageListener();
/*     */   }
/*     */ 
/*     */   public void setMessageListener(MessageListener listener) throws JMSException
/*     */   {
/* 191 */     if (log.isTraceEnabled()) log.trace("setMessageListener(" + listener + ") called");
/*     */ 
/* 193 */     this.delegate.setMessageListener(listener);
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/* 198 */     if (log.isTraceEnabled()) log.trace("run() called");
/* 199 */     this.delegate.run();
/*     */   }
/*     */ 
/*     */   public MessageProducer createProducer(Destination d) throws JMSException
/*     */   {
/* 204 */     if ((d != null) && (!(d instanceof JBossDestination)))
/*     */     {
/* 206 */       throw new InvalidDestinationException("Not a JBossDestination:" + d);
/*     */     }
/*     */ 
/* 209 */     ProducerDelegate producerDelegate = this.delegate.createProducerDelegate((JBossDestination)d);
/* 210 */     return new JBossMessageProducer(producerDelegate);
/*     */   }
/*     */ 
/*     */   public MessageConsumer createConsumer(Destination d) throws JMSException
/*     */   {
/* 215 */     return createConsumer(d, null, false);
/*     */   }
/*     */ 
/*     */   public MessageConsumer createConsumer(Destination d, String messageSelector) throws JMSException
/*     */   {
/* 220 */     return createConsumer(d, messageSelector, false);
/*     */   }
/*     */ 
/*     */   public MessageConsumer createConsumer(Destination d, String messageSelector, boolean noLocal)
/*     */     throws JMSException
/*     */   {
/* 226 */     if (d == null)
/*     */     {
/* 228 */       throw new InvalidDestinationException("Cannot create a consumer with a null destination");
/*     */     }
/* 230 */     if (!(d instanceof JBossDestination))
/*     */     {
/* 232 */       throw new InvalidDestinationException("Not a JBossDestination:" + d);
/*     */     }
/*     */ 
/* 235 */     log.trace("attempting to create consumer for destination:" + d + (messageSelector == null ? "" : new StringBuilder().append(", messageSelector: ").append(messageSelector).toString()) + (noLocal ? ", noLocal = true" : ""));
/*     */ 
/* 237 */     ConsumerDelegate cd = this.delegate.createConsumerDelegate((JBossDestination)d, messageSelector, noLocal, null, false, true);
/*     */ 
/* 240 */     return new JBossMessageConsumer(cd);
/*     */   }
/*     */ 
/*     */   public Queue createQueue(String queueName)
/*     */     throws JMSException
/*     */   {
/* 246 */     if (this.sessionType == 2)
/*     */     {
/* 248 */       throw new IllegalStateException("Cannot create a queue using a TopicSession");
/*     */     }
/* 250 */     return this.delegate.createQueue(queueName);
/*     */   }
/*     */ 
/*     */   public Topic createTopic(String topicName)
/*     */     throws JMSException
/*     */   {
/* 256 */     if (this.sessionType == 1)
/*     */     {
/* 258 */       throw new IllegalStateException("Cannot create a topic on a QueueSession");
/*     */     }
/* 260 */     return this.delegate.createTopic(topicName);
/*     */   }
/*     */ 
/*     */   public TopicSubscriber createDurableSubscriber(Topic topic, String name)
/*     */     throws JMSException
/*     */   {
/* 266 */     if (this.sessionType == 1)
/*     */     {
/* 268 */       throw new IllegalStateException("Cannot create a durable subscriber on a QueueSession");
/*     */     }
/* 270 */     if (topic == null)
/*     */     {
/* 272 */       throw new InvalidDestinationException("Cannot create a durable subscriber on a null topic");
/*     */     }
/* 274 */     if (!(topic instanceof JBossTopic))
/*     */     {
/* 276 */       throw new InvalidDestinationException("Not a JBossTopic:" + topic);
/*     */     }
/*     */ 
/* 279 */     ConsumerDelegate cd = this.delegate.createConsumerDelegate((JBossTopic)topic, null, false, name, false, true);
/*     */ 
/* 282 */     return new JBossMessageConsumer(cd);
/*     */   }
/*     */ 
/*     */   public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal)
/*     */     throws JMSException
/*     */   {
/* 292 */     if (this.sessionType == 1)
/*     */     {
/* 294 */       throw new IllegalStateException("Cannot create a durable subscriber on a QueueSession");
/*     */     }
/* 296 */     if (topic == null)
/*     */     {
/* 298 */       throw new InvalidDestinationException("Cannot create a durable subscriber on a null topic");
/*     */     }
/* 300 */     if (!(topic instanceof JBossTopic))
/*     */     {
/* 302 */       throw new InvalidDestinationException("Not a JBossTopic:" + topic);
/*     */     }
/* 304 */     if ("".equals(messageSelector))
/*     */     {
/* 306 */       messageSelector = null;
/*     */     }
/*     */ 
/* 309 */     ConsumerDelegate cd = this.delegate.createConsumerDelegate((JBossTopic)topic, messageSelector, noLocal, name, false, true);
/*     */ 
/* 312 */     return new JBossMessageConsumer(cd);
/*     */   }
/*     */ 
/*     */   public QueueBrowser createBrowser(Queue queue) throws JMSException
/*     */   {
/* 317 */     return createBrowser(queue, null);
/*     */   }
/*     */ 
/*     */   public QueueBrowser createBrowser(Queue queue, String messageSelector)
/*     */     throws JMSException
/*     */   {
/* 323 */     if (this.sessionType == 2)
/*     */     {
/* 325 */       throw new IllegalStateException("Cannot create a browser on a TopicSession");
/*     */     }
/* 327 */     if (queue == null)
/*     */     {
/* 329 */       throw new InvalidDestinationException("Cannot create a browser with a null queue");
/*     */     }
/* 331 */     if (!(queue instanceof JBossQueue))
/*     */     {
/* 333 */       throw new InvalidDestinationException("Not a JBossQueue:" + queue);
/*     */     }
/* 335 */     if ("".equals(messageSelector))
/*     */     {
/* 337 */       messageSelector = null;
/*     */     }
/*     */ 
/* 340 */     BrowserDelegate del = this.delegate.createBrowserDelegate((JBossQueue)queue, messageSelector);
/*     */ 
/* 343 */     return new JBossQueueBrowser(queue, messageSelector, del);
/*     */   }
/*     */ 
/*     */   public TemporaryQueue createTemporaryQueue()
/*     */     throws JMSException
/*     */   {
/* 349 */     if (this.sessionType == 2)
/*     */     {
/* 351 */       throw new IllegalStateException("Cannot create a temporary queue using a TopicSession");
/*     */     }
/* 353 */     JBossTemporaryQueue queue = new JBossTemporaryQueue(this.delegate);
/* 354 */     this.delegate.addTemporaryDestination(queue);
/* 355 */     return queue;
/*     */   }
/*     */ 
/*     */   public TemporaryTopic createTemporaryTopic()
/*     */     throws JMSException
/*     */   {
/* 361 */     if (this.sessionType == 1)
/*     */     {
/* 363 */       throw new IllegalStateException("Cannot create a temporary topic on a QueueSession");
/*     */     }
/* 365 */     JBossTemporaryTopic topic = new JBossTemporaryTopic(this.delegate);
/* 366 */     this.delegate.addTemporaryDestination(topic);
/* 367 */     return topic;
/*     */   }
/*     */ 
/*     */   public void unsubscribe(String name)
/*     */     throws JMSException
/*     */   {
/* 373 */     if (this.sessionType == 1)
/*     */     {
/* 375 */       throw new IllegalStateException("Cannot unsubscribe using a QueueSession");
/*     */     }
/* 377 */     this.delegate.unsubscribe(name);
/*     */   }
/*     */ 
/*     */   public Session getSession()
/*     */     throws JMSException
/*     */   {
/* 384 */     SessionState state = (SessionState)((DelegateSupport)this.delegate).getState();
/* 385 */     if (!state.isXA())
/*     */     {
/* 387 */       throw new IllegalStateException("Isn't an XASession");
/*     */     }
/*     */ 
/* 390 */     return this;
/*     */   }
/*     */ 
/*     */   public XAResource getXAResource()
/*     */   {
/* 395 */     return this.delegate.getXAResource();
/*     */   }
/*     */ 
/*     */   public QueueReceiver createReceiver(Queue queue, String messageSelector)
/*     */     throws JMSException
/*     */   {
/* 402 */     return (QueueReceiver)createConsumer(queue, messageSelector);
/*     */   }
/*     */ 
/*     */   public QueueReceiver createReceiver(Queue queue) throws JMSException
/*     */   {
/* 407 */     return (QueueReceiver)createConsumer(queue);
/*     */   }
/*     */ 
/*     */   public QueueSender createSender(Queue queue) throws JMSException
/*     */   {
/* 412 */     return (QueueSender)createProducer(queue);
/*     */   }
/*     */ 
/*     */   public QueueSession getQueueSession()
/*     */     throws JMSException
/*     */   {
/* 419 */     return (QueueSession)getSession();
/*     */   }
/*     */ 
/*     */   public TopicPublisher createPublisher(Topic topic)
/*     */     throws JMSException
/*     */   {
/* 426 */     return (TopicPublisher)createProducer(topic);
/*     */   }
/*     */ 
/*     */   public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal)
/*     */     throws JMSException
/*     */   {
/* 432 */     return (TopicSubscriber)createConsumer(topic, messageSelector, noLocal);
/*     */   }
/*     */ 
/*     */   public TopicSubscriber createSubscriber(Topic topic) throws JMSException
/*     */   {
/* 437 */     return (TopicSubscriber)createConsumer(topic);
/*     */   }
/*     */ 
/*     */   public TopicSession getTopicSession()
/*     */     throws JMSException
/*     */   {
/* 444 */     return (TopicSession)getSession();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 451 */     return "JBossSession->" + this.delegate;
/*     */   }
/*     */ 
/*     */   public SessionDelegate getDelegate()
/*     */   {
/* 456 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   void addAsfMessage(MessageProxy m, String consumerID, String queueName, int maxDeliveries, SessionDelegate connectionConsumerSession, boolean shouldAck)
/*     */   {
/* 468 */     this.delegate.addAsfMessage(m, consumerID, queueName, maxDeliveries, connectionConsumerSession, shouldAck);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.JBossSession
 * JD-Core Version:    0.6.0
 */