/*      */ package org.jboss.jms.client.container;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import javax.jms.IllegalStateException;
/*      */ import javax.jms.JMSException;
/*      */ import javax.jms.MessageListener;
/*      */ import org.jboss.jms.delegate.Cancel;
/*      */ import org.jboss.jms.delegate.ConsumerDelegate;
/*      */ import org.jboss.jms.delegate.DefaultCancel;
/*      */ import org.jboss.jms.delegate.DeliveryInfo;
/*      */ import org.jboss.jms.delegate.SessionDelegate;
/*      */ import org.jboss.jms.message.JBossMessage;
/*      */ import org.jboss.jms.message.MessageProxy;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.messaging.core.contract.Message;
/*      */ import org.jboss.messaging.util.Future;
/*      */ import org.jboss.messaging.util.prioritylinkedlist.BasicPriorityLinkedList;
/*      */ import org.jboss.messaging.util.prioritylinkedlist.PriorityLinkedList;
/*      */ 
/*      */ public class ClientConsumer
/*      */ {
/*   69 */   private static final Logger log = Logger.getLogger(ClientConsumer.class);
/*   70 */   private static boolean trace = log.isTraceEnabled();
/*      */   private static final int WAIT_TIMEOUT = 30000;
/*      */   private PriorityLinkedList buffer;
/*      */   private SessionDelegate sessionDelegate;
/*      */   private ConsumerDelegate consumerDelegate;
/*      */   private String consumerID;
/*      */   private boolean isConnectionConsumer;
/*      */   private volatile Thread receiverThread;
/*      */   private MessageListener listener;
/*      */   private int ackMode;
/*      */   private boolean closed;
/*      */   private Object mainLock;
/*      */   private int maxBufferSize;
/*      */   private int minBufferSize;
/*      */   private QueuedExecutor sessionExecutor;
/*      */   private boolean listenerRunning;
/*      */   private int maxDeliveries;
/*      */   private String queueName;
/*  212 */   private long lastDeliveryId = -1L;
/*  213 */   private volatile boolean serverSending = true;
/*      */   private boolean waitingForLastDelivery;
/*      */   private boolean shouldAck;
/*      */   private boolean handleFlowControl;
/*      */   private long redeliveryDelay;
/*      */   private volatile int currentToken;
/*      */ 
/*      */   private static boolean checkExpiredOrReachedMaxdeliveries(MessageProxy proxy, SessionDelegate del, int maxDeliveries, boolean shouldCancel)
/*      */   {
/*   77 */     Message msg = proxy.getMessage();
/*      */ 
/*   79 */     boolean expired = msg.isExpired();
/*      */ 
/*   81 */     boolean reachedMaxDeliveries = proxy.getDeliveryCount() == maxDeliveries;
/*      */ 
/*   83 */     if ((expired) || (reachedMaxDeliveries))
/*      */     {
/*   85 */       if (trace)
/*      */       {
/*   87 */         if (expired)
/*      */         {
/*   89 */           log.trace(proxy.getMessage() + " has expired, cancelling to server");
/*      */         }
/*      */         else
/*      */         {
/*   93 */           log.trace(proxy.getMessage() + " has reached maximum delivery number " + maxDeliveries + ", cancelling to server");
/*      */         }
/*      */       }
/*      */ 
/*   97 */       if (shouldCancel)
/*      */       {
/*   99 */         Cancel cancel = new DefaultCancel(proxy.getDeliveryId(), proxy.getDeliveryCount(), expired, reachedMaxDeliveries);
/*      */         try
/*      */         {
/*  103 */           del.cancelDelivery(cancel);
/*      */         }
/*      */         catch (JMSException e)
/*      */         {
/*  107 */           log.error("Failed to cancel delivery", e);
/*      */         }
/*      */       }
/*      */ 
/*  111 */       return true;
/*      */     }
/*      */ 
/*  115 */     return false;
/*      */   }
/*      */ 
/*      */   public static void callOnMessage(SessionDelegate sess, MessageListener listener, String consumerID, String queueName, boolean isConnectionConsumer, MessageProxy m, int ackMode, int maxDeliveries, SessionDelegate connectionConsumerSession, boolean shouldAck)
/*      */     throws JMSException
/*      */   {
/*  132 */     if (checkExpiredOrReachedMaxdeliveries(m, connectionConsumerSession != null ? connectionConsumerSession : sess, maxDeliveries, shouldAck))
/*      */     {
/*  135 */       return;
/*      */     }
/*      */ 
/*  138 */     DeliveryInfo deliveryInfo = new DeliveryInfo(m, consumerID, queueName, connectionConsumerSession, shouldAck);
/*      */ 
/*  141 */     m.incDeliveryCount();
/*      */ 
/*  145 */     if (!isConnectionConsumer)
/*      */     {
/*  150 */       sess.preDeliver(deliveryInfo);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  155 */       if (trace) log.trace("calling listener's onMessage(" + m + ")");
/*      */ 
/*  157 */       listener.onMessage(m);
/*      */ 
/*  159 */       if (trace) log.trace("listener's onMessage() finished");
/*      */     }
/*      */     catch (RuntimeException e)
/*      */     {
/*  163 */       long id = m.getMessage().getMessageID();
/*      */ 
/*  165 */       log.error("RuntimeException was thrown from onMessage, " + id + " will be redelivered", e);
/*      */ 
/*  169 */       if ((ackMode == 1) || (ackMode == 3))
/*      */       {
/*  171 */         sess.recover();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  177 */     if (!isConnectionConsumer)
/*      */     {
/*  179 */       if (trace) log.trace("Calling postDeliver");
/*      */ 
/*  181 */       sess.postDeliver();
/*      */ 
/*  183 */       if (trace) log.trace("Called postDeliver");
/*      */     }
/*      */   }
/*      */ 
/*      */   public ClientConsumer(boolean isCC, int ackMode, SessionDelegate sess, ConsumerDelegate cons, String consumerID, String queueName, int bufferSize, QueuedExecutor sessionExecutor, int maxDeliveries, boolean shouldAck, boolean handleFlowControl, long redeliveryDelay)
/*      */   {
/*  229 */     if (bufferSize < 1)
/*      */     {
/*  231 */       throw new IllegalArgumentException(this + " bufferSize must be > 0");
/*      */     }
/*      */ 
/*  234 */     this.maxBufferSize = bufferSize;
/*  235 */     this.minBufferSize = (bufferSize / 2);
/*  236 */     this.buffer = new BasicPriorityLinkedList(10);
/*  237 */     this.isConnectionConsumer = isCC;
/*  238 */     this.ackMode = ackMode;
/*  239 */     this.sessionDelegate = sess;
/*  240 */     this.consumerDelegate = cons;
/*  241 */     this.consumerID = consumerID;
/*  242 */     this.queueName = queueName;
/*  243 */     this.mainLock = new Object();
/*  244 */     this.sessionExecutor = sessionExecutor;
/*  245 */     this.maxDeliveries = maxDeliveries;
/*  246 */     this.shouldAck = shouldAck;
/*  247 */     this.handleFlowControl = handleFlowControl;
/*  248 */     this.redeliveryDelay = redeliveryDelay;
/*      */   }
/*      */ 
/*      */   public boolean isClosed()
/*      */   {
/*  256 */     return this.closed;
/*      */   }
/*      */ 
/*      */   public void handleMessage(Object message)
/*      */     throws Exception
/*      */   {
/*  271 */     this.sessionExecutor.execute(new HandleMessageRunnable(this.currentToken, message));
/*      */   }
/*      */ 
/*      */   public void setMessageListener(MessageListener listener) throws JMSException
/*      */   {
/*  276 */     synchronized (this.mainLock)
/*      */     {
/*  278 */       if (this.receiverThread != null)
/*      */       {
/*  281 */         throw new IllegalStateException("Consumer is currently in receive(..). Cannot set MessageListener");
/*      */       }
/*      */ 
/*  285 */       this.listener = listener;
/*      */ 
/*  287 */       if ((listener != null) && (!this.buffer.isEmpty()))
/*      */       {
/*  289 */         this.listenerRunning = true;
/*      */ 
/*  291 */         queueRunner(new ListenerRunner(null));
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void cancelBuffer() throws JMSException
/*      */   {
/*  298 */     if (trace) log.trace("Cancelling buffer: " + this.buffer.size());
/*      */ 
/*  300 */     synchronized (this.mainLock)
/*      */     {
/*  307 */       if ((this.shouldAck) && (!this.buffer.isEmpty()))
/*      */       {
/*  317 */         List cancels = new ArrayList();
/*      */ 
/*  319 */         for (Iterator i = this.buffer.iterator(); i.hasNext(); )
/*      */         {
/*  321 */           MessageProxy mp = (MessageProxy)i.next();
/*      */ 
/*  323 */           DefaultCancel cancel = new DefaultCancel(mp.getDeliveryId(), mp.getDeliveryCount(), false, false);
/*      */ 
/*  326 */           cancels.add(cancel);
/*      */         }
/*      */ 
/*  329 */         if (trace) log.trace("Calling cancelDeliveries");
/*  330 */         this.sessionDelegate.cancelDeliveries(cancels);
/*  331 */         if (trace) log.trace("Done call");
/*      */ 
/*  333 */         this.buffer.clear();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void close(long lastDeliveryId) throws JMSException
/*      */   {
/*  340 */     log.trace(this + " close");
/*      */ 
/*  343 */     waitForLastDelivery(lastDeliveryId);
/*      */ 
/*  346 */     if (this.listener != null)
/*      */     {
/*  348 */       setMessageListener(null);
/*      */     }
/*      */ 
/*  352 */     waitForOnMessageToComplete();
/*      */ 
/*  354 */     synchronized (this.mainLock)
/*      */     {
/*  356 */       if (this.closed)
/*      */       {
/*  358 */         return;
/*      */       }
/*      */ 
/*  361 */       this.closed = true;
/*      */ 
/*  363 */       if (this.receiverThread != null)
/*      */       {
/*  366 */         this.mainLock.notify();
/*      */       }
/*      */ 
/*  369 */       this.listener = null;
/*      */     }
/*      */ 
/*  372 */     if (trace) log.trace(this + " closed");
/*      */   }
/*      */ 
/*      */   public MessageProxy receive(long timeout)
/*      */     throws JMSException
/*      */   {
/*  385 */     MessageProxy m = null;
/*      */ 
/*  387 */     synchronized (this.mainLock)
/*      */     {
/*  389 */       if (trace) log.trace(this + " receiving, timeout = " + timeout);
/*      */ 
/*  391 */       if (this.closed)
/*      */       {
/*  394 */         if (trace) log.trace(this + " closed, returning null");
/*  395 */         return null;
/*      */       }
/*      */ 
/*  398 */       if (this.listener != null)
/*      */       {
/*  400 */         throw new JMSException("The consumer has a MessageListener set, cannot call receive(..)");
/*      */       }
/*      */ 
/*  404 */       this.receiverThread = Thread.currentThread();
/*      */ 
/*  406 */       long startTimestamp = System.currentTimeMillis();
/*      */       try
/*      */       {
/*      */         while (true)
/*      */         {
/*      */           Object localObject1;
/*  412 */           if (timeout == 0L)
/*      */           {
/*  414 */             if (trace) log.trace(this + ": receive, no timeout");
/*      */ 
/*  416 */             m = getMessage(0L);
/*      */ 
/*  418 */             if (m == null)
/*      */             {
/*  420 */               localObject1 = null;
/*      */ 
/*  507 */               this.receiverThread = null;
/*  508 */               return localObject1;
/*      */             }
/*      */           }
/*  423 */           else if (timeout == -1L)
/*      */           {
/*  426 */             if (trace) log.trace(this + ": receive, noWait");
/*      */ 
/*  428 */             m = getMessage(-1L);
/*      */ 
/*  430 */             if (m == null)
/*      */             {
/*  432 */               if (trace) log.trace(this + ": no message available");
/*  433 */               localObject1 = null;
/*      */ 
/*  507 */               this.receiverThread = null;
/*  508 */               return localObject1;
/*      */             }
/*      */           }
/*      */           else
/*      */           {
/*  438 */             if (trace) log.trace(this + ": receive, timeout " + timeout + " ms, blocking poll on queue");
/*      */ 
/*  440 */             m = getMessage(timeout);
/*      */ 
/*  442 */             if (m == null)
/*      */             {
/*  445 */               if (trace) log.trace(this + ": " + timeout + " ms timeout expired");
/*      */ 
/*  447 */               localObject1 = null;
/*      */ 
/*  507 */               this.receiverThread = null;
/*  508 */               return localObject1;
/*      */             }
/*      */           }
/*  451 */           if (trace) log.trace(this + " received " + m + " after being blocked on buffer");
/*      */ 
/*  453 */           boolean ignore = checkExpiredOrReachedMaxdeliveries(m, this.sessionDelegate, this.maxDeliveries, this.shouldAck);
/*      */ 
/*  456 */           if ((!this.isConnectionConsumer) && (!ignore))
/*      */           {
/*  458 */             DeliveryInfo info = new DeliveryInfo(m, this.consumerID, this.queueName, null, this.shouldAck);
/*      */ 
/*  460 */             this.sessionDelegate.preDeliver(info);
/*      */ 
/*  467 */             ignore = !this.sessionDelegate.postDeliver();
/*      */ 
/*  469 */             if (trace)
/*      */             {
/*  471 */               log.trace("Post deliver returned " + (!ignore));
/*      */             }
/*      */ 
/*  474 */             if (!ignore)
/*      */             {
/*  476 */               m.incDeliveryCount();
/*      */             }
/*      */           }
/*      */ 
/*  480 */           if (!ignore)
/*      */           {
/*  482 */             if (!trace) break; log.trace(this + ": message " + m + " is not expired, pushing it to the caller"); break;
/*      */           }
/*      */ 
/*  487 */           if (trace)
/*      */           {
/*  489 */             log.trace("Discarding message " + m);
/*      */           }
/*      */ 
/*  493 */           if (timeout != 0L)
/*      */           {
/*  495 */             timeout -= System.currentTimeMillis() - startTimestamp;
/*  496 */             if (timeout == 0L)
/*      */             {
/*  499 */               timeout = -1L;
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */       finally
/*      */       {
/*  507 */         this.receiverThread = null;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  513 */     if (this.handleFlowControl)
/*      */     {
/*  515 */       checkStart();
/*      */     }
/*      */ 
/*  518 */     if (trace) log.trace(this + " receive() returning " + m);
/*      */ 
/*  520 */     return m;
/*      */   }
/*      */ 
/*      */   public MessageListener getMessageListener()
/*      */   {
/*  525 */     return this.listener;
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/*  530 */     return "ClientConsumer[" + this.consumerID + "]";
/*      */   }
/*      */ 
/*      */   public String getConsumerId()
/*      */   {
/*  535 */     return this.consumerID;
/*      */   }
/*      */ 
/*      */   public void setConsumerId(String consumerId)
/*      */   {
/*  540 */     this.consumerID = consumerId;
/*      */   }
/*      */ 
/*      */   public void addToFrontOfBuffer(MessageProxy proxy) throws Exception
/*      */   {
/*  545 */     synchronized (this.mainLock)
/*      */     {
/*  547 */       this.buffer.addFirst(proxy, proxy.getJMSPriority());
/*      */ 
/*  549 */       messageAdded();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void synchronizeWith(ClientConsumer newHandler)
/*      */   {
/*  560 */     this.currentToken += 1;
/*      */ 
/*  562 */     this.consumerID = newHandler.consumerID;
/*      */ 
/*  568 */     this.buffer.clear();
/*      */ 
/*  571 */     this.serverSending = true;
/*      */   }
/*      */ 
/*      */   public long getRedeliveryDelay()
/*      */   {
/*  576 */     return this.redeliveryDelay;
/*      */   }
/*      */ 
/*      */   private void waitForLastDelivery(long id)
/*      */   {
/*  591 */     if (trace) log.trace("Waiting for last delivery id " + id);
/*      */ 
/*  593 */     if (id == -1L)
/*      */     {
/*  596 */       return;
/*      */     }
/*      */ 
/*  599 */     synchronized (this.mainLock)
/*      */     {
/*  601 */       this.waitingForLastDelivery = true;
/*      */       try
/*      */       {
/*  604 */         long wait = 30000L;
/*  605 */         while ((this.lastDeliveryId != id) && (wait > 0L))
/*      */         {
/*  607 */           long start = System.currentTimeMillis();
/*      */           try
/*      */           {
/*  610 */             this.mainLock.wait(wait);
/*      */           }
/*      */           catch (InterruptedException e)
/*      */           {
/*      */           }
/*  615 */           wait -= System.currentTimeMillis() - start;
/*      */         }
/*  617 */         if ((trace) && (this.lastDeliveryId == id))
/*      */         {
/*  619 */           log.trace("Got last delivery");
/*      */         }
/*      */ 
/*  622 */         if (this.lastDeliveryId != id)
/*      */         {
/*  624 */           log.warn("Timed out waiting for last delivery " + id + " got " + this.lastDeliveryId);
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/*  629 */         this.waitingForLastDelivery = false;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void checkStop()
/*      */   {
/*  636 */     int size = this.buffer.size();
/*      */ 
/*  638 */     if ((this.serverSending) && (size >= this.maxBufferSize))
/*      */     {
/*  643 */       sendChangeRateMessage(0.0F);
/*      */ 
/*  645 */       if (trace) log.trace("Sent changeRate 0 message");
/*      */ 
/*  647 */       this.serverSending = false;
/*      */     }
/*      */   }
/*      */ 
/*      */   private void checkStart()
/*      */   {
/*  653 */     int size = this.buffer.size();
/*      */ 
/*  655 */     if ((!this.serverSending) && (size <= this.minBufferSize))
/*      */     {
/*  659 */       sendChangeRateMessage(1.0F);
/*      */ 
/*  661 */       if (trace) log.trace("Sent changeRate 1.0 message");
/*      */ 
/*  663 */       this.serverSending = true;
/*      */     }
/*      */   }
/*      */ 
/*      */   private void sendChangeRateMessage(float newRate)
/*      */   {
/*      */     try
/*      */     {
/*  673 */       this.consumerDelegate.changeRate(newRate);
/*      */     }
/*      */     catch (JMSException e)
/*      */     {
/*  677 */       log.error("Failed to send changeRate message", e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void waitForOnMessageToComplete()
/*      */   {
/*  685 */     if (Thread.currentThread().equals(this.sessionExecutor.getThread()))
/*      */     {
/*  690 */       return;
/*      */     }
/*      */ 
/*  693 */     Future result = new Future();
/*      */     try
/*      */     {
/*  697 */       this.sessionExecutor.execute(new Closer(result));
/*      */ 
/*  699 */       if (trace) log.trace(this + " blocking wait for Closer execution");
/*  700 */       result.getResult();
/*  701 */       if (trace) log.trace(this + " got Closer result");
/*      */     }
/*      */     catch (InterruptedException e)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   private void queueRunner(ListenerRunner runner)
/*      */   {
/*      */     try
/*      */     {
/*  712 */       this.sessionExecutor.execute(runner);
/*      */     }
/*      */     catch (InterruptedException e)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   private void messageAdded()
/*      */   {
/*  721 */     boolean notified = false;
/*      */ 
/*  723 */     if (trace) log.trace("Receiver thread:" + this.receiverThread + " listener:" + this.listener + " listenerRunning:" + this.listenerRunning + " sessionExecutor:" + this.sessionExecutor);
/*      */ 
/*  727 */     if (this.receiverThread != null)
/*      */     {
/*  729 */       if (trace) log.trace(this + " notifying receiver/waiter thread");
/*      */ 
/*  731 */       this.mainLock.notifyAll();
/*      */ 
/*  733 */       notified = true;
/*      */     }
/*  735 */     else if (this.listener != null)
/*      */     {
/*  738 */       if (!this.listenerRunning)
/*      */       {
/*  740 */         this.listenerRunning = true;
/*      */ 
/*  742 */         if (trace) log.trace(this + " scheduled a new ListenerRunner");
/*      */ 
/*  744 */         queueRunner(new ListenerRunner(null));
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  751 */     if ((this.waitingForLastDelivery) && (!notified))
/*      */     {
/*  753 */       if (trace) log.trace("Notifying");
/*      */ 
/*  755 */       this.mainLock.notifyAll();
/*      */     }
/*      */   }
/*      */ 
/*      */   private long waitOnLock(Object lock, long waitTime) throws InterruptedException
/*      */   {
/*  761 */     long start = System.currentTimeMillis();
/*      */ 
/*  764 */     lock.wait(waitTime);
/*      */ 
/*  766 */     long waited = System.currentTimeMillis() - start;
/*      */ 
/*  768 */     if (waited < waitTime)
/*      */     {
/*  770 */       waitTime -= waited;
/*      */ 
/*  772 */       return waitTime;
/*      */     }
/*      */ 
/*  776 */     return 0L;
/*      */   }
/*      */ 
/*      */   private MessageProxy getMessage(long timeout)
/*      */   {
/*  782 */     if (timeout != -1L)
/*      */     {
/*      */       try
/*      */       {
/*  790 */         if (timeout == 0L)
/*      */         {
/*  793 */           while ((!this.closed) && (this.buffer.isEmpty()))
/*      */           {
/*  795 */             if (trace) log.trace(this + " waiting on main lock, no timeout");
/*      */ 
/*  797 */             this.mainLock.wait();
/*      */ 
/*  799 */             if (!trace) continue; log.trace(this + " done waiting on main lock");
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  805 */         long toWait = timeout;
/*      */ 
/*  807 */         while ((!this.closed) && (this.buffer.isEmpty()) && (toWait > 0L))
/*      */         {
/*  809 */           if (trace) log.trace(this + " waiting on main lock, timeout " + toWait + " ms");
/*      */ 
/*  811 */           toWait = waitOnLock(this.mainLock, toWait);
/*      */ 
/*  813 */           if (!trace) continue; log.trace(this + " done waiting on lock, buffer is " + (this.buffer.isEmpty() ? "" : "NOT ") + "empty");
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (InterruptedException e)
/*      */       {
/*  819 */         if (trace) log.trace("InterruptedException, " + this + ".getMessage() returning null");
/*  820 */         return null;
/*      */       }
/*      */     }
/*      */ 
/*  824 */     MessageProxy m = null;
/*      */ 
/*  826 */     if ((!this.closed) && (!this.buffer.isEmpty()))
/*      */     {
/*  828 */       m = (MessageProxy)this.buffer.removeFirst();
/*      */     }
/*      */ 
/*  831 */     return m;
/*      */   }
/*      */ 
/*      */   private class ListenerRunner
/*      */     implements Runnable
/*      */   {
/*      */     private ListenerRunner()
/*      */     {
/*      */     }
/*      */ 
/*      */     public void run()
/*      */     {
/*  929 */       MessageProxy mp = null;
/*      */ 
/*  931 */       MessageListener theListener = null;
/*      */ 
/*  933 */       synchronized (ClientConsumer.this.mainLock)
/*      */       {
/*  935 */         if ((ClientConsumer.this.listener == null) || (ClientConsumer.this.buffer.isEmpty()))
/*      */         {
/*  937 */           ClientConsumer.access$1402(ClientConsumer.this, false);
/*      */ 
/*  939 */           if (ClientConsumer.trace) ClientConsumer.log.trace("no listener or buffer is empty, returning");
/*      */ 
/*  941 */           return;
/*      */         }
/*      */ 
/*  944 */         theListener = ClientConsumer.this.listener;
/*      */ 
/*  948 */         mp = (MessageProxy)ClientConsumer.this.buffer.removeFirst();
/*      */       }
/*      */ 
/*  961 */       if (mp != null)
/*      */       {
/*      */         try
/*      */         {
/*  965 */           ClientConsumer.callOnMessage(ClientConsumer.this.sessionDelegate, theListener, ClientConsumer.this.consumerID, ClientConsumer.this.queueName, false, mp, ClientConsumer.this.ackMode, ClientConsumer.this.maxDeliveries, null, ClientConsumer.this.shouldAck);
/*      */ 
/*  968 */           if (ClientConsumer.trace) ClientConsumer.log.trace("Called callonMessage");
/*      */         }
/*      */         catch (Throwable t)
/*      */         {
/*  972 */           ClientConsumer.log.error("Failed to deliver message", t);
/*      */         }
/*      */       }
/*      */ 
/*  976 */       synchronized (ClientConsumer.this.mainLock)
/*      */       {
/*  978 */         if (!ClientConsumer.this.buffer.isEmpty())
/*      */         {
/*  982 */           if (ClientConsumer.trace) ClientConsumer.log.trace("More messages in buffer so queueing next onMessage to run");
/*      */ 
/*  984 */           ClientConsumer.this.queueRunner(this);
/*      */ 
/*  986 */           if (ClientConsumer.trace) ClientConsumer.log.trace("Queued next onMessage to run");
/*      */         }
/*      */         else
/*      */         {
/*  990 */           if (ClientConsumer.trace) ClientConsumer.log.trace("no more messages in buffer, marking listener as not running");
/*      */ 
/*  992 */           ClientConsumer.access$1402(ClientConsumer.this, false);
/*      */         }
/*      */       }
/*      */ 
/*  996 */       if (ClientConsumer.this.handleFlowControl)
/*      */       {
/*  998 */         ClientConsumer.this.checkStart();
/*      */       }
/*      */ 
/* 1001 */       if (ClientConsumer.trace) ClientConsumer.log.trace("Exiting run()");
/*      */     }
/*      */   }
/*      */ 
/*      */   private class HandleMessageRunnable
/*      */     implements Runnable
/*      */   {
/*      */     private int token;
/*      */     private Object message;
/*      */ 
/*      */     HandleMessageRunnable(int token, Object message)
/*      */     {
/*  867 */       this.token = token;
/*      */ 
/*  869 */       this.message = message;
/*      */     }
/*      */ 
/*      */     public void run()
/*      */     {
/*      */       try
/*      */       {
/*  876 */         MessageProxy proxy = (MessageProxy)this.message;
/*      */ 
/*  878 */         if (ClientConsumer.trace) ClientConsumer.log.trace(this + " receiving message " + proxy + " from the remoting layer");
/*      */ 
/*  880 */         synchronized (ClientConsumer.this.mainLock)
/*      */         {
/*  882 */           if (ClientConsumer.this.closed)
/*      */           {
/*  886 */             throw new IllegalStateException(this + " is closed, so ignoring message");
/*      */           }
/*      */ 
/*  889 */           if (this.token != ClientConsumer.this.currentToken)
/*      */           {
/*  892 */             ClientConsumer.log.trace("Ignoring message " + this.message);
/*  893 */             return;
/*      */           }
/*      */ 
/*  896 */           proxy.setSessionDelegate(ClientConsumer.this.sessionDelegate, ClientConsumer.this.isConnectionConsumer);
/*      */ 
/*  898 */           proxy.getMessage().doBeforeReceive();
/*      */ 
/*  901 */           ClientConsumer.this.buffer.addLast(proxy, proxy.getJMSPriority());
/*      */ 
/*  903 */           ClientConsumer.access$902(ClientConsumer.this, proxy.getDeliveryId());
/*      */ 
/*  905 */           if (ClientConsumer.trace) ClientConsumer.log.trace(this + " added message(s) to the buffer are now " + ClientConsumer.this.buffer.size() + " messages");
/*      */ 
/*  907 */           ClientConsumer.this.messageAdded();
/*      */ 
/*  909 */           if (ClientConsumer.this.handleFlowControl)
/*      */           {
/*  911 */             ClientConsumer.this.checkStop();
/*      */           }
/*      */         }
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  917 */         ClientConsumer.log.error("Failed to handle message", e);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private class Closer
/*      */     implements Runnable
/*      */   {
/*      */     Future result;
/*      */ 
/*      */     Closer(Future result)
/*      */     {
/*  846 */       this.result = result;
/*      */     }
/*      */ 
/*      */     public void run()
/*      */     {
/*  851 */       if (ClientConsumer.trace) ClientConsumer.log.trace("Closer starts running");
/*      */ 
/*  853 */       this.result.setResult(null);
/*      */ 
/*  855 */       if (ClientConsumer.trace) ClientConsumer.log.trace("Closer finished run");
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.container.ClientConsumer
 * JD-Core Version:    0.6.0
 */