/*    */ package org.jboss.jms.client.container;
/*    */ 
/*    */ import org.jboss.jms.client.FailoverCommandCenter;
/*    */ import org.jboss.jms.client.FailureDetector;
/*    */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.remoting.Client;
/*    */ 
/*    */ public class ConnectionFailureListener
/*    */   implements FailureDetector
/*    */ {
/* 29 */   private static final Logger log = Logger.getLogger(ConnectionFailureListener.class);
/*    */   private FailoverCommandCenter fcc;
/*    */   private JMSRemotingConnection remotingConnection;
/*    */ 
/*    */   ConnectionFailureListener(FailoverCommandCenter fcc, JMSRemotingConnection remotingConnection)
/*    */   {
/* 45 */     this.fcc = fcc;
/* 46 */     this.remotingConnection = remotingConnection;
/*    */   }
/*    */ 
/*    */   public boolean handleConnectionException(Throwable throwable, Client client)
/*    */   {
/*    */     try
/*    */     {
/* 60 */       log.trace(this + " is being notified of connection failure: " + throwable);
/*    */ 
/* 62 */       return this.fcc.failureDetected(throwable, this, this.remotingConnection);
/*    */     }
/*    */     catch (Throwable e)
/*    */     {
/* 66 */       log.error("Caught exception in handling failure", e);
/*    */     }
/* 68 */     return false;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 76 */     return "ConnectionFailureListener[" + this.fcc + "]";
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.container.ConnectionFailureListener
 * JD-Core Version:    0.6.0
 */