/*    */ package org.jboss.jms.client.container;
/*    */ 
/*    */ import javax.jms.JMSException;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class ExceptionInterceptor
/*    */   implements Interceptor
/*    */ {
/* 48 */   private static final Logger log = Logger.getLogger(ExceptionInterceptor.class);
/*    */ 
/* 50 */   private boolean trace = log.isTraceEnabled();
/*    */ 
/*    */   public String getName()
/*    */   {
/* 64 */     return "ExceptionInterceptor";
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable
/*    */   {
/*    */     try
/*    */     {
/* 71 */       return invocation.invokeNext();
/*    */     }
/*    */     catch (JMSException e)
/*    */     {
/* 76 */       if (this.trace) log.trace("Caught JMSException", e);
/* 77 */       throw e;
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 83 */       log(t);
/*    */     }
/* 85 */     throw t;
/*    */   }
/*    */ 
/*    */   private void log(Throwable e)
/*    */   {
/* 97 */     log.error("Caught throwable", e);
/* 98 */     Throwable e2 = e.getCause();
/* 99 */     if (e2 != null)
/*    */     {
/* 101 */       log(e2);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.container.ExceptionInterceptor
 * JD-Core Version:    0.6.0
 */