/*     */ package org.jboss.jms.client.container;
/*     */ 
/*     */ import javax.jms.BytesMessage;
/*     */ import javax.jms.Destination;
/*     */ import javax.jms.MapMessage;
/*     */ import javax.jms.Message;
/*     */ import javax.jms.ObjectMessage;
/*     */ import javax.jms.StreamMessage;
/*     */ import javax.jms.TextMessage;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.jms.client.delegate.DelegateSupport;
/*     */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*     */ import org.jboss.jms.client.state.ConnectionState;
/*     */ import org.jboss.jms.client.state.ProducerState;
/*     */ import org.jboss.jms.client.state.SessionState;
/*     */ import org.jboss.jms.delegate.ConnectionDelegate;
/*     */ import org.jboss.jms.delegate.SessionDelegate;
/*     */ import org.jboss.jms.message.JBossBytesMessage;
/*     */ import org.jboss.jms.message.JBossMapMessage;
/*     */ import org.jboss.jms.message.JBossMessage;
/*     */ import org.jboss.jms.message.JBossObjectMessage;
/*     */ import org.jboss.jms.message.JBossStreamMessage;
/*     */ import org.jboss.jms.message.JBossTextMessage;
/*     */ import org.jboss.jms.message.MessageIdGenerator;
/*     */ import org.jboss.jms.message.MessageProxy;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ProducerAspect
/*     */ {
/*  66 */   private static final Logger log = Logger.getLogger(ProducerAspect.class);
/*     */ 
/*  70 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public Object handleSend(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  80 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/*  82 */     Object[] args = mi.getArguments();
/*     */ 
/*  84 */     Destination destination = (Destination)args[0];
/*  85 */     Message m = (Message)args[1];
/*  86 */     int deliveryMode = ((Integer)args[2]).intValue();
/*  87 */     int priority = ((Integer)args[3]).intValue();
/*  88 */     long timeToLive = ((Long)args[4]).longValue();
/*     */ 
/*  90 */     boolean keepID = args.length > 5 ? ((Boolean)args[5]).booleanValue() : false;
/*     */ 
/*  92 */     String keptId = null;
/*     */ 
/*  96 */     ProducerState producerState = getProducerState(mi);
/*     */ 
/*  98 */     if (deliveryMode == -1)
/*     */     {
/* 101 */       deliveryMode = producerState.getDeliveryMode();
/* 102 */       if (this.trace) log.trace("Using producer's default delivery mode: " + deliveryMode);
/*     */     }
/* 104 */     m.setJMSDeliveryMode(deliveryMode);
/*     */ 
/* 106 */     if (priority == -1)
/*     */     {
/* 109 */       priority = producerState.getPriority();
/* 110 */       if (this.trace) log.trace("Using producer's default priority: " + priority);
/*     */     }
/* 112 */     m.setJMSPriority(priority);
/*     */ 
/* 114 */     if (producerState.isDisableMessageTimestamp())
/*     */     {
/* 116 */       m.setJMSTimestamp(0L);
/*     */     }
/*     */     else
/*     */     {
/* 120 */       m.setJMSTimestamp(System.currentTimeMillis());
/*     */     }
/*     */ 
/* 123 */     if (timeToLive == -9223372036854775808L)
/*     */     {
/* 126 */       timeToLive = producerState.getTimeToLive();
/* 127 */       if (this.trace) log.trace("Using producer's default timeToLive: " + timeToLive);
/*     */     }
/*     */ 
/* 130 */     if (timeToLive == 0L)
/*     */     {
/* 133 */       m.setJMSExpiration(0L);
/*     */     }
/*     */     else
/*     */     {
/* 137 */       m.setJMSExpiration(System.currentTimeMillis() + timeToLive);
/*     */     }
/*     */ 
/* 140 */     if (destination == null)
/*     */     {
/* 143 */       destination = producerState.getDestination();
/*     */ 
/* 145 */       if (destination == null)
/*     */       {
/* 147 */         throw new UnsupportedOperationException("Destination not specified");
/*     */       }
/*     */ 
/* 150 */       if (this.trace) log.trace("Using producer's default destination: " + destination);
/*     */ 
/*     */     }
/* 157 */     else if ((producerState.getDestination() != null) && (!producerState.getDestination().equals(destination)))
/*     */     {
/* 160 */       throw new UnsupportedOperationException("Where a default destination is specified for the sender and a destination is specified in the arguments to the send, these destinations must be equal");
/*     */     }
/*     */ 
/* 167 */     SessionState sessionState = (SessionState)producerState.getParent();
/*     */ 
/* 170 */     ConnectionState connectionState = (ConnectionState)sessionState.getParent();
/*     */ 
/* 172 */     long id = 0L;
/*     */ 
/* 175 */     boolean foreign = false;
/*     */     JBossMessage messageToSend;
/* 177 */     if (!(m instanceof MessageProxy))
/*     */     {
/* 181 */       foreign = true;
/*     */       JBossMessage messageToSend;
/*     */       JBossMessage messageToSend;
/* 187 */       if ((m instanceof BytesMessage))
/*     */       {
/* 189 */         messageToSend = new JBossBytesMessage((BytesMessage)m, 0L);
/*     */       }
/*     */       else
/*     */       {
/*     */         JBossMessage messageToSend;
/* 191 */         if ((m instanceof MapMessage))
/*     */         {
/* 193 */           messageToSend = new JBossMapMessage((MapMessage)m, 0L);
/*     */         }
/*     */         else
/*     */         {
/*     */           JBossMessage messageToSend;
/* 195 */           if ((m instanceof ObjectMessage))
/*     */           {
/* 197 */             messageToSend = new JBossObjectMessage((ObjectMessage)m, 0L);
/*     */           }
/*     */           else
/*     */           {
/*     */             JBossMessage messageToSend;
/* 199 */             if ((m instanceof StreamMessage))
/*     */             {
/* 201 */               messageToSend = new JBossStreamMessage((StreamMessage)m, 0L);
/*     */             }
/*     */             else
/*     */             {
/*     */               JBossMessage messageToSend;
/* 203 */               if ((m instanceof TextMessage))
/*     */               {
/* 205 */                 messageToSend = new JBossTextMessage((TextMessage)m, 0L);
/*     */               }
/*     */               else
/*     */               {
/* 209 */                 messageToSend = new JBossMessage(m, 0L);
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/* 212 */       messageToSend.setJMSMessageID(null);
/*     */ 
/* 215 */       messageToSend.setJMSDestination(destination);
/* 216 */       if (connectionState.getRemotingConnection().isStrictTck())
/*     */       {
/* 218 */         m.setJMSDestination(destination);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 224 */       MessageProxy proxy = (MessageProxy)m;
/*     */ 
/* 226 */       if (keepID)
/*     */       {
/* 228 */         keptId = m.getJMSMessageID();
/*     */       }
/*     */ 
/* 232 */       m.setJMSDestination(destination);
/*     */ 
/* 236 */       proxy.setJMSMessageID(null);
/*     */ 
/* 239 */       messageToSend = proxy.getMessage();
/*     */ 
/* 241 */       proxy.beforeSend();
/*     */     }
/*     */ 
/* 246 */     id = connectionState.getIdGenerator().getId((ConnectionDelegate)connectionState.getDelegate());
/* 247 */     messageToSend.setMessageId(id);
/*     */ 
/* 249 */     if (keptId != null)
/*     */     {
/* 251 */       messageToSend.setJMSMessageID(keptId);
/*     */     }
/*     */ 
/* 256 */     messageToSend.doBeforeSend();
/*     */ 
/* 259 */     if (foreign)
/*     */     {
/* 261 */       m.setJMSMessageID(messageToSend.getJMSMessageID());
/*     */     }
/*     */ 
/* 266 */     ((SessionDelegate)sessionState.getDelegate()).send(messageToSend, false);
/*     */ 
/* 268 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleSetDisableMessageID(Invocation invocation) throws Throwable
/*     */   {
/* 273 */     Object[] args = ((MethodInvocation)invocation).getArguments();
/*     */ 
/* 275 */     getProducerState(invocation).setDisableMessageID(((Boolean)args[0]).booleanValue());
/*     */ 
/* 277 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleGetDisableMessageID(Invocation invocation) throws Throwable
/*     */   {
/* 282 */     return getProducerState(invocation).isDisableMessageID() ? Boolean.TRUE : Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object handleSetDisableMessageTimestamp(Invocation invocation) throws Throwable
/*     */   {
/* 287 */     Object[] args = ((MethodInvocation)invocation).getArguments();
/*     */ 
/* 289 */     getProducerState(invocation).setDisableMessageTimestamp(((Boolean)args[0]).booleanValue());
/*     */ 
/* 291 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleGetDisableMessageTimestamp(Invocation invocation) throws Throwable
/*     */   {
/* 296 */     return getProducerState(invocation).isDisableMessageTimestamp() ? Boolean.TRUE : Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object handleSetDeliveryMode(Invocation invocation) throws Throwable
/*     */   {
/* 301 */     Object[] args = ((MethodInvocation)invocation).getArguments();
/*     */ 
/* 303 */     getProducerState(invocation).setDeliveryMode(((Integer)args[0]).intValue());
/*     */ 
/* 305 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleGetDeliveryMode(Invocation invocation) throws Throwable
/*     */   {
/* 310 */     return new Integer(getProducerState(invocation).getDeliveryMode());
/*     */   }
/*     */ 
/*     */   public Object handleSetPriority(Invocation invocation) throws Throwable
/*     */   {
/* 315 */     Object[] args = ((MethodInvocation)invocation).getArguments();
/*     */ 
/* 317 */     getProducerState(invocation).setPriority(((Integer)args[0]).intValue());
/*     */ 
/* 319 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleGetPriority(Invocation invocation) throws Throwable
/*     */   {
/* 324 */     return new Integer(getProducerState(invocation).getPriority());
/*     */   }
/*     */ 
/*     */   public Object handleSetTimeToLive(Invocation invocation) throws Throwable
/*     */   {
/* 329 */     Object[] args = ((MethodInvocation)invocation).getArguments();
/*     */ 
/* 331 */     getProducerState(invocation).setTimeToLive(((Long)args[0]).longValue());
/*     */ 
/* 333 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleGetTimeToLive(Invocation invocation) throws Throwable
/*     */   {
/* 338 */     return new Long(getProducerState(invocation).getTimeToLive());
/*     */   }
/*     */ 
/*     */   public Object handleGetDestination(Invocation invocation) throws Throwable
/*     */   {
/* 343 */     return getProducerState(invocation).getDestination();
/*     */   }
/*     */ 
/*     */   public Object handleSetDestination(Invocation invocation) throws Throwable
/*     */   {
/* 348 */     Object[] args = ((MethodInvocation)invocation).getArguments();
/*     */ 
/* 350 */     getProducerState(invocation).setDestination((Destination)args[0]);
/*     */ 
/* 352 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleClosing(Invocation invocation) throws Throwable
/*     */   {
/* 357 */     return new Long(-1L);
/*     */   }
/*     */ 
/*     */   public Object handleClose(Invocation invocation) throws Throwable
/*     */   {
/* 362 */     return null;
/*     */   }
/*     */ 
/*     */   private ProducerState getProducerState(Invocation inv)
/*     */   {
/* 375 */     return (ProducerState)((DelegateSupport)inv.getTargetObject()).getState();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.container.ProducerAspect
 * JD-Core Version:    0.6.0
 */